/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPathMappingsUtil {
    public static String replaceStarForMapping(@NotNull String mapping, @Nullable String matchedStar) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(0);
        }
        return matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
    }

    public static boolean checkMappingPattern(@NotNull String path2, @NotNull Pattern pattern) {
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(2);
        }
        Matcher m = pattern.matcher(path2);
        return m.find();
    }

    @Nullable
    public static Pattern createMappingPattern(@Nullable String pattern, @Nullable VirtualFile contextFile) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, JSPathMappingsUtil.isCaseSensitive(contextFile) ? 0 : 2);
    }

    private static boolean isCaseSensitive(@Nullable VirtualFile configDir) {
        if (configDir == null) {
            return true;
        }
        return configDir.isCaseSensitive();
    }

    @NotNull
    public static Collection<String> substituteMappings(@NotNull String path2, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> substitutions) {
        Pair<? extends JSModulePathSubstitution, String> max;
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(3);
        }
        if (substitutions == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(4);
        }
        if ((max = substitutions.findMaxElementByPaths(path2)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)max.first;
        String matchedStar = (String)max.second;
        ArrayList<String> result2 = new ArrayList<String>();
        if (matchedStar == null) {
            Collection<String> collection = matchedPattern.getMappings();
            if (collection == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(6);
            }
            return collection;
        }
        for (String mapping : JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false)) {
            result2.add(JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar));
        }
        for (String mapping : JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true)) {
            if (matchedPattern.canStartWith()) {
                result2.add(mapping + matchedStar);
                continue;
            }
            result2.add(JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static String substituteStarForMapping(@NotNull String path2, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> substitutions) {
        Pair<? extends JSModulePathSubstitution, String> max;
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(8);
        }
        if (substitutions == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(9);
        }
        if ((max = substitutions.findMaxElementByPaths(path2)) == null) {
            String string = path2;
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        JSModulePathSubstitution substitution = (JSModulePathSubstitution)max.first;
        String matchedStar = (String)max.second;
        Iterator<String> iterator = substitution.getMappings().iterator();
        if (iterator.hasNext()) {
            String mapping = iterator.next();
            String string = JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar);
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static List<String> getPathForFileReferences(@NotNull VirtualFile url, @NotNull Collection<String> forFileReference) {
        if (url == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(13);
        }
        if (forFileReference == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(14);
        }
        List list2 = ContainerUtil.map(forFileReference, el -> JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(url, JSPathMappingsUtil.getPatternOrMappingWithoutStar(el)));
        if (list2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public static List<String> getPathForExactReferences(@NotNull VirtualFile url, @Nullable String matchedStar, @NotNull Collection<String> forExactReference) {
        if (url == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(16);
        }
        if (forExactReference == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(17);
        }
        List<String> list2 = forExactReference.stream().map(mapping -> JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar)).map(el -> JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(url, el)).collect(Collectors.toList());
        if (list2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @Nullable
    public static <T extends JSModulePattern> Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch, @NotNull Collection<? extends T> paths) {
        if (textToMatch == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(19);
        }
        if (paths == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(20);
        }
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePattern path2 : paths) {
            String suffix;
            String pattern = path2.getPattern();
            int prefixMatchIndex = pattern.indexOf("*");
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path2.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                if (!pattern.equals(textToMatch)) continue;
                return Pair.create((Object)path2, null);
            }
            String prefix = pattern.substring(0, prefixMatchIndex);
            if (!JSPathMappingsUtil.checkPrefix(textToMatch, prefix, suffix = pattern.substring(suffixMatchIndex)) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            matchedElement = Pair.create((Object)path2, (Object)textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length()));
        }
        return matchedElement;
    }

    private static boolean checkPrefix(@NotNull String unquotedRefText, @NotNull String prefix, @NotNull String suffix) {
        if (unquotedRefText == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(21);
        }
        if (prefix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(22);
        }
        if (suffix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(23);
        }
        return unquotedRefText.length() >= prefix.length() + suffix.length() && unquotedRefText.startsWith(prefix) && unquotedRefText.endsWith(suffix);
    }

    public static boolean isPatternOrMappingEndsWithStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(24);
        }
        return patternOrMapping.endsWith("/*") || patternOrMapping.endsWith("\\*");
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(25);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(26);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping)) {
            return baseUrl.getFileSystem().findFileByPath(mapping);
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    public static boolean isAbsolutePath(@NotNull String mapping) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(27);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && mapping.startsWith("/")) {
            return true;
        }
        return FileUtil.isAbsolute((String)mapping);
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(28);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(29);
        }
        String path2 = FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)mapping), (char)'/');
        return baseUrl.isValid() ? baseUrl.findFileByRelativePath(path2) : null;
    }

    public static String getPatternOrMappingWithoutStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(30);
        }
        int length = patternOrMapping.length();
        return patternOrMapping.endsWith("*") ? patternOrMapping.substring(0, patternOrMapping.length() > 2 ? length - 2 : 1) : patternOrMapping;
    }

    @NotNull
    public static Collection<String> getMappings(@NotNull JSModulePathSubstitution matchedPattern, @Nullable String matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(31);
        }
        return JSPathMappingsUtil.getMappings(matchedPattern, matchedPattern.getMappings(), matchedStar, endsWithStar);
    }

    @NotNull
    public static Collection<String> getMappings(@NotNull JSModulePathSubstitution matchedPattern, @NotNull Collection<String> mappings, @Nullable String matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(32);
        }
        if (mappings == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(33);
        }
        String pattern = matchedPattern.getPattern();
        boolean patternEndsWithStart = matchedStar != null && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || matchedPattern.canStartWith());
        ArrayList<String> result2 = new ArrayList<String>();
        for (String mapping : mappings) {
            boolean mappingEndsWithStar = patternEndsWithStart && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(mapping) || matchedPattern.canStartWith());
            if (mappingEndsWithStar != endsWithStar) continue;
            result2.add(mapping);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(35);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(36);
        }
        return JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl.getPath(), mapping);
    }

    @NotNull
    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull String canonicalUrl, @NotNull String mapping) {
        if (canonicalUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(37);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(38);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping) || JSUrlImportsUtil.isSupportedRemoteModuleUrl(mapping)) {
            String string = mapping;
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        String canonicalMapping = FileUtil.toSystemIndependentName((String)mapping);
        if (!((String)canonicalUrl).isEmpty()) {
            canonicalUrl = (String)canonicalUrl + "/";
        }
        String string = FileUtil.toCanonicalPath((String)((String)canonicalUrl + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping)), (char)'/');
        if (string == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getRelativeOrAbsoluteFilePath(@NotNull String path2, VirtualFile baseDir) {
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(41);
        }
        if (StringUtil.isEmptyOrSpaces((String)path2)) {
            return baseDir;
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path2));
        if (StringUtil.isEmpty((String)normalizedPath)) {
            return baseDir;
        }
        if (!JSPathMappingsUtil.isAbsolutePath(path2)) {
            return baseDir.findFileByRelativePath(normalizedPath);
        }
        return LocalFileSystem.getInstance().findFileByPath(normalizedPath);
    }

    @NotNull
    public static JSModulePattern createPatternForString(final @NotNull String partOfString, final boolean canStartWith) {
        if (partOfString == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(42);
        }
        return new JSModulePattern(){

            @Override
            @NotNull
            public String getPattern() {
                String string = partOfString;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean canStartWith() {
                return canStartWith;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil$1", "getPattern"));
            }
        };
    }

    public static AsteriskCount hasZeroOrOneAsteriskCharacter(String str) {
        boolean seenAsterisk = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '*') continue;
            if (!seenAsterisk) {
                seenAsterisk = true;
                continue;
            }
            return AsteriskCount.MORE;
        }
        return seenAsterisk ? AsteriskCount.ONE : AsteriskCount.ZERO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 10, 11, 12, 15, 18, 34, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 34: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFileReference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forExactReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMatch";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternOrMapping";
                break;
            }
            case 25: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPattern";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalUrl";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partOfString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteMappings";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteStarForMapping";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForFileReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForExactReferences";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStarForMapping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMappingPattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteMappings";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 34: 
            case 39: 
            case 40: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteStarForMapping";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPathForFileReferences";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPathForExactReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMaxElementByPaths";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPatternOrMappingEndsWithStar";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrMappingWithoutStar";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeOrAbsoluteFilePath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createPatternForString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 10, 11, 12, 15, 18, 34, 39, 40 -> new IllegalStateException(string);
        };
    }

    public static enum AsteriskCount {
        ZERO,
        ONE,
        MORE;

    }
}

