/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPackageJsonMappingContributorBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0007H\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonExportsMappingContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase;", "()V", "buildReferenceForExternalPackage", "Lcom/intellij/psi/PsiReference;", "mappings", "", "", "matchedStar", "unquotedRefText", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "getModuleDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependencyName", "placeRoot", "getModuleRoot", "getSubstitutions", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "packageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "isPlaceAcceptableForImport", "", "moduleRoot", "isRefTextAcceptable", "isRootAcceptable", "intellij.javascript.impl"})
public class JSPackageJsonExportsMappingContributor
extends JSPackageJsonMappingContributorBase {
    @Override
    @Nullable
    protected VirtualFile getModuleRoot(@NotNull String unquotedRefText, @NotNull PsiElement host, @NotNull VirtualFile placeRoot) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        String string = NodeModuleSearchUtil.extractDependencyName(unquotedRefText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
        String dependencyName = string;
        if (((CharSequence)dependencyName).length() == 0) {
            return null;
        }
        return this.getModuleDirectory(host, dependencyName, placeRoot);
    }

    @Override
    protected boolean isRefTextAcceptable(@NotNull String unquotedRefText) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        return !JSFileReferencesUtil.isRelative(unquotedRefText);
    }

    @Override
    protected boolean isRootAcceptable(@NotNull VirtualFile placeRoot) {
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        return true;
    }

    @Override
    @Nullable
    protected PsiReference buildReferenceForExternalPackage(@NotNull List<String> mappings, @Nullable String matchedStar, @NotNull String unquotedRefText, @NotNull PsiElement host, int offset) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return null;
    }

    @Override
    @NotNull
    protected JSModulePathMappings<JSModulePathSubstitution> getSubstitutions(@NotNull PackageJsonData packageJsonData) {
        Intrinsics.checkNotNullParameter((Object)packageJsonData, (String)"packageJsonData");
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = packageJsonData.getExports();
        Intrinsics.checkNotNullExpressionValue(jSModulePathMappings, (String)"getExports(...)");
        return jSModulePathMappings;
    }

    private final VirtualFile getModuleDirectory(PsiElement host, String dependencyName, VirtualFile placeRoot) {
        InstalledPackageVersion existingPackage = new NodeInstalledPackageFinder(host.getProject(), placeRoot).findInstalledPackage(dependencyName);
        InstalledPackageVersion installedPackageVersion = existingPackage;
        if (installedPackageVersion == null || (installedPackageVersion = installedPackageVersion.getPackageDir()) == null) {
            return null;
        }
        return installedPackageVersion;
    }

    @Override
    protected boolean isPlaceAcceptableForImport(@NotNull VirtualFile placeRoot, @NotNull VirtualFile moduleRoot) {
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
        return !Intrinsics.areEqual((Object)placeRoot, (Object)moduleRoot);
    }
}

