/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsBase;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsKt;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsLarge;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0019\u001aB\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J \u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge;", "T", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsBase;", "substitutions", "", "(Ljava/util/Collection;)V", "pathsData", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PathsData;", "getPathsData", "()Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PathsData;", "pathsData$delegate", "Lkotlin/Lazy;", "buildData", "equals", "", "other", "", "findMaxElementByPaths", "Lcom/intellij/openapi/util/Pair;", "", "textToMatch", "hashCode", "", "isEmpty", "PathsData", "PatternData", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSModulePathMappings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSModulePathMappings.kt\ncom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
final class JSModulePathMappingsLarge<T extends JSModulePathSubstitution>
extends JSModulePathMappingsBase<T> {
    @NotNull
    private final Lazy pathsData$delegate;

    public JSModulePathMappingsLarge(@NotNull Collection<? extends T> substitutions) {
        Intrinsics.checkNotNullParameter(substitutions, (String)"substitutions");
        super(substitutions);
        this.pathsData$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<PathsData<T>>(this){
            final /* synthetic */ JSModulePathMappingsLarge<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PathsData<T> invoke() {
                return JSModulePathMappingsLarge.access$buildData(this.this$0);
            }
        });
    }

    private final PathsData<T> getPathsData() {
        Lazy lazy = this.pathsData$delegate;
        return (PathsData)lazy.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.getSubstitutions().isEmpty();
    }

    @Override
    @Nullable
    public Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch) {
        PathsData<T> pathsData2;
        Intrinsics.checkNotNullParameter((Object)textToMatch, (String)"textToMatch");
        if (((CharSequence)textToMatch).length() == 0) {
            return null;
        }
        PathsData<T> $this$findMaxElementByPaths_u24lambda_u241 = pathsData2 = this.getPathsData();
        boolean bl = false;
        JSModulePathSubstitution jSModulePathSubstitution = (JSModulePathSubstitution)$this$findMaxElementByPaths_u24lambda_u241.getStraightMappings().get(textToMatch);
        if (jSModulePathSubstitution != null) {
            JSModulePathSubstitution it = jSModulePathSubstitution;
            boolean bl2 = false;
            return Pair.create((Object)it, null);
        }
        int maxPrefixLength = textToMatch.length();
        NavigableMap<String, List<PatternData<T>>> navigableMap = $this$findMaxElementByPaths_u24lambda_u241.getPatternMappings().headMap(textToMatch, true).descendingMap();
        Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"descendingMap(...)");
        for (Map.Entry entry : ((Map)navigableMap).entrySet()) {
            String prefix = (String)entry.getKey();
            List substitutions = (List)entry.getValue();
            if (prefix.length() > maxPrefixLength) continue;
            Intrinsics.checkNotNull((Object)prefix);
            int commonPrefixLength = JSModulePathMappingsKt.commonPrefixLength$default(textToMatch, prefix, false, 2, null);
            if (commonPrefixLength < $this$findMaxElementByPaths_u24lambda_u241.getShortestPrefixLength()) break;
            maxPrefixLength = Math.min(maxPrefixLength, commonPrefixLength);
            if (commonPrefixLength != prefix.length()) continue;
            for (PatternData substitution : substitutions) {
                String suffix = substitution.getSuffix();
                if (textToMatch.length() < suffix.length() + prefix.length() || !StringsKt.endsWith$default((String)textToMatch, (String)suffix, (boolean)false, (int)2, null)) continue;
                Object t = substitution.getPathSubstitution();
                String string = textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Pair.create(t, (Object)string);
            }
        }
        return null;
    }

    private final PathsData<T> buildData() {
        Map straightMappings = new LinkedHashMap();
        TreeMap patternMappings = new TreeMap();
        int shortestPrefixLength = Integer.MAX_VALUE;
        for (JSModulePathSubstitution path2 : this.getSubstitutions()) {
            String suffix;
            String prefix;
            String pattern;
            Intrinsics.checkNotNullExpressionValue((Object)path2.getPattern(), (String)"getPattern(...)");
            int prefixMatchIndex = StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)0, (boolean)false, (int)6, null);
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path2.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                straightMappings.put(pattern, path2);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pattern.substring(0, prefixMatchIndex), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)pattern.substring(suffixMatchIndex), (String)"substring(...)");
            shortestPrefixLength = Math.min(prefix.length(), shortestPrefixLength);
            List list2 = patternMappings.computeIfAbsent(prefix, arg_0 -> JSModulePathMappingsLarge.buildData$lambda$2(buildData.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsLarge.PatternData<T of com.intellij.lang.javascript.frameworks.modules.JSModulePathMappingsLarge>>");
            TypeIntrinsics.asMutableList((Object)list2).add(new PatternData<JSModulePathSubstitution>(suffix, path2));
        }
        return new PathsData(straightMappings, patternMappings, shortestPrefixLength);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof JSModulePathMappingsBase && Intrinsics.areEqual(((JSModulePathMappingsBase)other).getSubstitutions(), this.getSubstitutions());
    }

    public int hashCode() {
        return ((Object)this.getSubstitutions()).hashCode();
    }

    private static final List buildData$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ PathsData access$buildData(JSModulePathMappingsLarge $this) {
        return $this.buildData();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003BA\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003J!\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t0\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\fH\u00c6\u0003JQ\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00010\u00052 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PathsData;", "T", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "", "straightMappings", "", "", "patternMappings", "Ljava/util/TreeMap;", "", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PatternData;", "shortestPrefixLength", "", "(Ljava/util/Map;Ljava/util/TreeMap;I)V", "getPatternMappings", "()Ljava/util/TreeMap;", "getShortestPrefixLength", "()I", "getStraightMappings", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.javascript.psi.impl"})
    private static final class PathsData<T extends JSModulePathSubstitution> {
        @NotNull
        private final Map<String, T> straightMappings;
        @NotNull
        private final TreeMap<String, List<PatternData<T>>> patternMappings;
        private final int shortestPrefixLength;

        public PathsData(@NotNull Map<String, ? extends T> straightMappings, @NotNull TreeMap<String, List<PatternData<T>>> patternMappings, int shortestPrefixLength) {
            Intrinsics.checkNotNullParameter(straightMappings, (String)"straightMappings");
            Intrinsics.checkNotNullParameter(patternMappings, (String)"patternMappings");
            this.straightMappings = straightMappings;
            this.patternMappings = patternMappings;
            this.shortestPrefixLength = shortestPrefixLength;
        }

        @NotNull
        public final Map<String, T> getStraightMappings() {
            return this.straightMappings;
        }

        @NotNull
        public final TreeMap<String, List<PatternData<T>>> getPatternMappings() {
            return this.patternMappings;
        }

        public final int getShortestPrefixLength() {
            return this.shortestPrefixLength;
        }

        @NotNull
        public final Map<String, T> component1() {
            return this.straightMappings;
        }

        @NotNull
        public final TreeMap<String, List<PatternData<T>>> component2() {
            return this.patternMappings;
        }

        public final int component3() {
            return this.shortestPrefixLength;
        }

        @NotNull
        public final PathsData<T> copy(@NotNull Map<String, ? extends T> straightMappings, @NotNull TreeMap<String, List<PatternData<T>>> patternMappings, int shortestPrefixLength) {
            Intrinsics.checkNotNullParameter(straightMappings, (String)"straightMappings");
            Intrinsics.checkNotNullParameter(patternMappings, (String)"patternMappings");
            return new PathsData<T>(straightMappings, patternMappings, shortestPrefixLength);
        }

        public static /* synthetic */ PathsData copy$default(PathsData pathsData2, Map map, TreeMap treeMap, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                map = pathsData2.straightMappings;
            }
            if ((n2 & 2) != 0) {
                treeMap = pathsData2.patternMappings;
            }
            if ((n2 & 4) != 0) {
                n = pathsData2.shortestPrefixLength;
            }
            return pathsData2.copy(map, treeMap, n);
        }

        @NotNull
        public String toString() {
            return "PathsData(straightMappings=" + this.straightMappings + ", patternMappings=" + this.patternMappings + ", shortestPrefixLength=" + this.shortestPrefixLength + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.straightMappings).hashCode();
            result2 = result2 * 31 + this.patternMappings.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.shortestPrefixLength);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathsData)) {
                return false;
            }
            PathsData pathsData2 = (PathsData)other;
            if (!Intrinsics.areEqual(this.straightMappings, pathsData2.straightMappings)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.patternMappings, pathsData2.patternMappings)) {
                return false;
            }
            return this.shortestPrefixLength == pathsData2.shortestPrefixLength;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PatternData;", "T", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "", "suffix", "", "pathSubstitution", "(Ljava/lang/String;Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;)V", "getPathSubstitution", "()Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "getSuffix", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;)Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappingsLarge$PatternData;", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.psi.impl"})
    private static final class PatternData<T extends JSModulePathSubstitution> {
        @NotNull
        private final String suffix;
        @NotNull
        private final T pathSubstitution;

        public PatternData(@NotNull String suffix, @NotNull T pathSubstitution) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter(pathSubstitution, (String)"pathSubstitution");
            this.suffix = suffix;
            this.pathSubstitution = pathSubstitution;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public final T getPathSubstitution() {
            return this.pathSubstitution;
        }

        @NotNull
        public final String component1() {
            return this.suffix;
        }

        @NotNull
        public final T component2() {
            return this.pathSubstitution;
        }

        @NotNull
        public final PatternData<T> copy(@NotNull String suffix, @NotNull T pathSubstitution) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter(pathSubstitution, (String)"pathSubstitution");
            return new PatternData<T>(suffix, pathSubstitution);
        }

        public static /* synthetic */ PatternData copy$default(PatternData patternData, String string, JSModulePathSubstitution jSModulePathSubstitution, int n, Object object) {
            if ((n & 1) != 0) {
                string = patternData.suffix;
            }
            if ((n & 2) != 0) {
                jSModulePathSubstitution = patternData.pathSubstitution;
            }
            return patternData.copy(string, jSModulePathSubstitution);
        }

        @NotNull
        public String toString() {
            return "PatternData(suffix=" + this.suffix + ", pathSubstitution=" + this.pathSubstitution + ")";
        }

        public int hashCode() {
            int result2 = this.suffix.hashCode();
            result2 = result2 * 31 + this.pathSubstitution.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatternData)) {
                return false;
            }
            PatternData patternData = (PatternData)other;
            if (!Intrinsics.areEqual((Object)this.suffix, (Object)patternData.suffix)) {
                return false;
            }
            return Intrinsics.areEqual(this.pathSubstitution, patternData.pathSubstitution);
        }
    }
}

