/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.folding;

import com.intellij.json.psi.impl.JsonCollectionPsiPresentationUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.SourceMapUtil;
import com.intellij.lang.javascript.folding.JSCodeFoldingSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.types.JSBlockStatementElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSStringTemplateExpressionElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class JavaScriptFoldingBuilderBase
extends CustomFoldingBuilder {
    private static final int IMPORT_OFFSET = "import ".length();
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT});
    private static final TokenSet IMPORTS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.IMPORT_DECLARATION, JSStubElementTypes.IMPORT_STATEMENT});
    private static final int SHORT_COMMENT_LENGTH = 150;
    private static final Pattern DOC_COMMENT_CONTENT = Pattern.compile("^\\s*/?\\**(\\s*)(.*?)\\s*\\**/?$");
    private static final Pattern DOC_TYPE_COMMENT = Pattern.compile("\\s*@type\\s+(?:((?:[.#~])?(?:import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)|\\{(.+)}) ");
    private static final int MAX_COMMENT_TEXT_LEFT = 50;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document2, boolean quick) {
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (root == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        this.appendDescriptors(root.getNode(), document2, descriptors);
    }

    protected ASTNode appendDescriptors(ASTNode node, Document document2, List<? super FoldingDescriptor> descriptors) {
        PsiElement objectLiteralExpression2;
        ProgressManager.checkCanceled();
        IElementType type2 = node.getElementType();
        if (JavaScriptFoldingBuilderBase.isFunctionBlockBody(node) && !this.foldSmallBlock(node, document2, descriptors)) {
            boolean collapsedByDefault = this.getCodeFoldingSettings().isCollapseMethods();
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), this.getBlockPlaceholderText(), collapsedByDefault);
        } else if (JavaScriptFoldingBuilderBase.isShorthandArrowFunctionBody(node) && !this.foldSmallBlock(node, document2, descriptors)) {
            boolean collapsedByDefault = this.getCodeFoldingSettings().isCollapseMethods();
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), "...", collapsedByDefault);
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type2) && !this.foldSmallBlock(node, document2, descriptors)) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), this.getBlockPlaceholderText(), false);
        } else if (type2 == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION && !this.foldSmallBlock(node, document2, descriptors)) {
            JSObjectLiteralExpression objectLiteralExpression2 = (JSObjectLiteralExpression)node.getPsi(JSObjectLiteralExpression.class);
            String placeHolder = objectLiteralExpression2 == null ? this.getBlockPlaceholderText() : this.getObjectPlaceholderText(objectLiteralExpression2);
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), placeHolder, this.getCodeFoldingSettings().isCollapseObjectLiterals());
        } else if (type2 == JSElementTypes.ARRAY_LITERAL_EXPRESSION && !this.foldSmallBlock(node, document2, descriptors) && (objectLiteralExpression2 = node.getPsi()) instanceof JSArrayLiteralExpression) {
            JSArrayLiteralExpression jsArray = (JSArrayLiteralExpression)objectLiteralExpression2;
            String collapsedNodeText = JsonCollectionPsiPresentationUtils.getCollectionPsiPresentationText((int)jsArray.getExpressions().length);
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), collapsedNodeText, this.getCodeFoldingSettings().isCollapseArrayLiterals());
        } else if (JSElementTypes.XML_LITERALS.contains(type2) && !this.foldSmallBlock(node, document2, descriptors)) {
            ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
            ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(node);
            end = end == null ? XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node) : end;
            TextRange nodeRange = node.getTextRange();
            TextRange range = end == null || child != null && child.getText().endsWith("Fragment") ? new TextRange(nodeRange.getStartOffset() + 1, nodeRange.getEndOffset() - 1) : new TextRange(end.getStartOffset(), nodeRange.getEndOffset() - 1);
            this.addDescriptorForRange(node, descriptors, range, "...", this.getCodeFoldingSettings().isCollapseXmlLiterals());
        } else if (type2 == TypeScriptStubElementTypes.OBJECT_TYPE && !this.foldSmallBlock(node, document2, descriptors)) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), "{...}", false);
        } else if (type2 == JSElementTypes.SWITCH_STATEMENT) {
            TextRange textRange2;
            ASTNode lBrace = node.findChildByType(JSTokenTypes.LBRACE);
            ASTNode rBrace = node.findChildByType(JSTokenTypes.RBRACE);
            if (lBrace != null && rBrace != null && (textRange2 = new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)).getEndOffset() < document2.getTextLength() && document2.getLineNumber(textRange2.getStartOffset()) != document2.getLineNumber(textRange2.getEndOffset())) {
                this.addDescriptorForRange(node, descriptors, textRange2, this.getBlockPlaceholderText(), false);
            }
        } else if (type2 == JSElementTypes.CASE_CLAUSE) {
            ASTNode bodyStart;
            ASTNode caseKeyword = node.findChildByType(JSTokenTypes.CASE_KEYWORD);
            ASTNode keyword = caseKeyword != null ? caseKeyword : node.findChildByType(JSTokenTypes.DEFAULT_KEYWORD);
            ASTNode labelEnd = node.findChildByType(JSTokenTypes.COLON, keyword);
            if (labelEnd != null && (bodyStart = labelEnd.getTreeNext()) != null) {
                this.addDescriptorForRange(node, descriptors, new TextRange(bodyStart.getStartOffset(), node.getTextRange().getEndOffset()), "...", false);
            }
        } else if (type2 == JSTokenTypes.DOC_COMMENT) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), JavaScriptFoldingBuilderBase.docCommentPlaceholder(node), this.getCodeFoldingSettings().isCollapseDocComments() && !JavaScriptFoldingBuilderBase.isShortSingleLineComment(node));
        } else if (type2 == JSTokenTypes.C_STYLE_COMMENT) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), JavaScriptFoldingBuilderBase.cStyleCommentPlaceholder(node), this.isCollapseFileHeaderComment(node) && !JavaScriptFoldingBuilderBase.isShortSingleLineComment(node));
        } else {
            if (type2 == JSTokenTypes.END_OF_LINE_COMMENT) {
                return this.collapseConsequentNodesOfSpecifiedType(node, descriptors, COMMENTS, JavaScriptFoldingBuilderBase.endOfLineCommentPlaceholder(node), this.isCollapseFileHeaderComment(node) || SourceMapUtil.isSourceMapsComment(node));
            }
            if (this.isImportNode(type2)) {
                return this.collapseImport(document2, node, descriptors);
            }
            if (type2 instanceof JSClassElementTypeBase || type2 == JSStubElementTypes.PACKAGE_STATEMENT || type2 == JSStubElementTypes.TYPESCRIPT_ENUM || type2 instanceof TypeScriptModuleElementType) {
                ASTNode lbrace = node.findChildByType(JSTokenTypes.LBRACE);
                if (lbrace != null) {
                    this.addDescriptorForRange(node, descriptors, new TextRange(lbrace.getStartOffset(), node.getTextRange().getEndOffset()), this.getBlockPlaceholderText(), false);
                }
            } else if (type2 instanceof JSStringTemplateExpressionElementType && !this.foldSmallBlock(node, document2, descriptors)) {
                this.addDescriptorForRange(node, descriptors, node.getTextRange(), JavaScriptFoldingBuilderBase.getStringTemplatePlaceholder(node), false);
            }
        }
        if (type2 instanceof JSFileElementType) {
            node.getPsi().getFirstChild();
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            IElementType iElementType = child.getElementType();
            if (iElementType == JSElementTypes.BINARY_EXPRESSION || iElementType == JSElementTypes.COMMA_EXPRESSION) {
                JSBinaryExpression expression = (JSBinaryExpression)child.getPsi();
                JSExpression lOperand = expression.getLOperand();
                while (JSSymbolUtil.binaryOpTypeToAvoidRecursions(expression.getOperationSign()) && lOperand instanceof JSBinaryExpression) {
                    ASTNode rOperandNode;
                    JSExpression rOperand = expression.getROperand();
                    ASTNode aSTNode = rOperandNode = rOperand != null ? rOperand.getNode() : null;
                    if (rOperandNode != null) {
                        this.appendDescriptors(rOperandNode, document2, descriptors);
                    }
                    expression = (JSBinaryExpression)lOperand;
                    lOperand = expression.getLOperand();
                }
                this.appendDescriptors(expression.getNode(), document2, descriptors);
                child = child.getTreeNext();
                continue;
            }
            child = this.appendDescriptors(child, document2, descriptors).getTreeNext();
        }
        return node;
    }

    private static boolean isShortSingleLineComment(ASTNode node) {
        String text2 = node.getText();
        if (text2.indexOf(10) != -1) {
            return false;
        }
        return text2.length() < 150;
    }

    private boolean foldSmallBlock(ASTNode node, Document document2, List<? super FoldingDescriptor> descriptors) {
        TextRange textRange2 = node.getTextRange();
        return textRange2.getEndOffset() > document2.getTextLength() || document2.getLineNumber(textRange2.getStartOffset()) == document2.getLineNumber(textRange2.getEndOffset()) || this.tryFoldOneLineBlockFunction(node, document2, descriptors) || JavaScriptFoldingBuilderBase.isModulePatternChild(node) || JavaScriptFoldingBuilderBase.blockStatementIsEntireSwitchClause(document2, node);
    }

    private boolean tryFoldOneLineBlockFunction(@NotNull ASTNode node, @NotNull Document document2, @NotNull List<? super FoldingDescriptor> descriptors) {
        String functionLeftText;
        int leftStart;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        if (!JSCodeFoldingSettings.getInstance().isCollapseOneLineFunctions()) {
            return false;
        }
        if (!JavaScriptFoldingBuilderBase.isFunctionBlockBody(node)) {
            return false;
        }
        ASTNode nodeTreeParent = node.getTreeParent();
        JSFunction function2 = (JSFunction)ObjectUtils.tryCast((Object)nodeTreeParent.getPsi(), JSFunction.class);
        if (function2 == null) {
            return false;
        }
        JSBlockStatement body2 = function2.getBlock();
        if (body2 == null) {
            return false;
        }
        JSSourceElement[] statements = body2.getStatementListItems();
        if (statements.length > 1) {
            return false;
        }
        ASTNode left = body2.getNode().findChildByType(JSTokenTypes.LBRACE);
        ASTNode right = body2.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (left == null || right == null) {
            return false;
        }
        boolean showAsAnonymous = function2 instanceof JSFunctionExpression && !function2.isArrowFunction();
        TextRange functionRange = function2.getTextRange();
        if (showAsAnonymous) {
            leftStart = functionRange.getStartOffset();
            functionLeftText = JavaScriptFoldingBuilderBase.getFunctionLeftText(function2);
        } else {
            PsiElement nonSpaceBeforeLeft = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)body2);
            leftStart = nonSpaceBeforeLeft != null ? nonSpaceBeforeLeft.getTextRange().getEndOffset() : left.getTextRange().getStartOffset();
            functionLeftText = " { ";
        }
        int rightEnd = functionRange.getEndOffset();
        if (statements.length == 0) {
            if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, left.getTextRange().getEndOffset(), right.getTextRange().getStartOffset(), 2)) {
                return false;
            }
            FoldingGroup group = FoldingGroup.newGroup((String)"empty-one-liner");
            String text2 = StringUtil.trimTrailing((String)functionLeftText) + "}";
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(nodeTreeParent, new TextRange(leftStart, rightEnd), group, text2, Boolean.valueOf(this.getCodeFoldingSettings().isCollapseOneLineFunctions()), Collections.emptySet()));
            return true;
        }
        JSSourceElement statement = statements[0];
        if (statement == null) {
            return false;
        }
        TextRange stRange = statement.getTextRange();
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, stRange.getStartOffset(), stRange.getEndOffset(), 0)) {
            return false;
        }
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, left.getTextRange().getEndOffset(), stRange.getStartOffset(), 1) || !JavaScriptFoldingBuilderBase.linesAreClose(document2, stRange.getEndOffset(), right.getTextRange().getEndOffset(), 1)) {
            return false;
        }
        int leftEnd = stRange.getStartOffset();
        int rightStart = stRange.getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptors.add((FoldingDescriptor)new FoldingDescriptor(left, new TextRange(leftStart, leftEnd), group, functionLeftText, Boolean.valueOf(true), Collections.emptySet()));
        descriptors.add((FoldingDescriptor)new FoldingDescriptor(right, new TextRange(rightStart, rightEnd), group, " }", Boolean.valueOf(true), Collections.emptySet()));
        return true;
    }

    private static String getFunctionLeftText(@NotNull JSFunction function2) {
        String parameters;
        String name;
        if (function2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        int length = function2.getParameters().length;
        String string = name = function2 instanceof JSFunctionExpression ? null : function2.getName();
        if (length > 0) {
            boolean wrap = length != 1 || !StringUtil.isEmptyOrSpaces((String)name);
            parameters = Arrays.stream(function2.getParameters()).map(p -> p.getName()).collect(Collectors.joining(", ", wrap ? "(" : "", wrap ? ")" : ""));
        } else {
            parameters = "()";
        }
        JSAttributeList attributes = function2.getAttributeList();
        String attributesText = attributes == null ? null : StringUtil.notNullize((String)attributes.getText()) + " ";
        return Stream.of(attributesText, function2.isGetProperty() ? "get " : (function2.isSetProperty() ? "set " : ""), function2.isGenerator() ? "*" : "", name, parameters, name == null ? " => {" : " {").filter(m -> !StringUtil.isEmptyOrSpaces((String)m)).collect(Collectors.joining("", "", " "));
    }

    private static boolean linesAreClose(@NotNull Document document2, int off1, int off2, int maxDiff) {
        int ln2;
        int ln1;
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        return Math.abs((ln1 = document2.getLineNumber(off1)) - (ln2 = document2.getLineNumber(off2))) <= maxDiff;
    }

    private static boolean blockStatementIsEntireSwitchClause(Document document2, ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return node.getElementType() instanceof JSBlockStatementElementType && parent.getElementType() == JSElementTypes.CASE_CLAUSE && document2.getLineNumber(node.getStartOffset()) == document2.getLineNumber(parent.getStartOffset());
    }

    private static boolean isModulePatternChild(ASTNode node) {
        PsiElement parent = node.getTreeParent().getPsi();
        if (parent instanceof JSFunctionExpression && (parent = parent.getParent()) instanceof JSParenthesizedExpression) {
            PsiElement currentParent = parent;
            return (parent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == currentParent && JavaScriptFoldingBuilderBase.isModulePattern(PsiTreeUtil.getParentOfType((PsiElement)parent, JSStatement.class));
        }
        return false;
    }

    private static boolean isModulePattern(PsiElement element) {
        PsiElement sibling;
        if (element == null || !(element.getParent() instanceof JSFile)) {
            return false;
        }
        for (sibling = element.getNextSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            return false;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getPrevSibling()) {
        }
        return sibling == null;
    }

    private void addDescriptorForRange(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull TextRange range, @NotNull String placeHolder, boolean collapsedByDefault) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        if (range == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        if (placeHolder == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        if (range.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor(node, range, null, placeHolder, Boolean.valueOf(collapsedByDefault), Collections.emptySet());
            descriptor.setCanBeRemovedWhenCollapsed(this.isImportNode(node.getElementType()));
            descriptors.add((FoldingDescriptor)descriptor);
        }
    }

    private ASTNode collapseImport(@NotNull Document document2, @NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors) {
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(13);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        int sizeBeforeCollapse = descriptors.size();
        String placeHolder = "...";
        ASTNode nodeResult = this.collapseConsequentNodesOfSpecifiedType(node, descriptors, this.getImportTokenTypes(), placeHolder, this.getCodeFoldingSettings().isCollapseImports());
        if (descriptors.size() != sizeBeforeCollapse) {
            return nodeResult;
        }
        if (JavaScriptFoldingBuilderBase.isMultiline(document2, node)) {
            TextRange nodeRange = node.getTextRange();
            this.addDescriptorForRange(node, descriptors, new TextRange(nodeRange.getStartOffset() + IMPORT_OFFSET, nodeRange.getEndOffset()), placeHolder, this.getCodeFoldingSettings().isCollapseImports());
        }
        return node;
    }

    protected TokenSet getImportTokenTypes() {
        return IMPORTS;
    }

    private static boolean isMultiline(Document document2, ASTNode node) {
        if (!JavaScriptFoldingBuilderBase.isMultilineNodeType(node)) {
            return false;
        }
        TextRange nodeRange = node.getTextRange();
        int startNumber = document2.getLineNumber(nodeRange.getStartOffset());
        int endNumber = document2.getLineNumber(nodeRange.getEndOffset());
        return endNumber - startNumber > 0;
    }

    private static boolean isMultilineNodeType(ASTNode node) {
        return ES6StubElementTypes.IMPORT_DECLARATION == node.getElementType();
    }

    @NotNull
    private ASTNode collapseConsequentNodesOfSpecifiedType(@NotNull ASTNode startNode, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull TokenSet tokens, @NotNull String placeHolder, boolean collapsedBD) {
        String text2;
        if (startNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        if (tokens == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if (placeHolder == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        PsiElement endElement = startNode.getPsi();
        PsiElement current = endElement.getNextSibling();
        boolean stopAtFirstNontrivialLine = startNode.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        boolean containsCustomRegionMarker = JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
        while (!(!(current instanceof PsiWhiteSpace) || stopAtFirstNontrivialLine && (text2 = current.getText()).startsWith("\n") && text2.indexOf(10, 1) > 0)) {
            if ((current = current.getNextSibling()) == null || !tokens.contains(current.getNode().getElementType())) continue;
            endElement = current;
            containsCustomRegionMarker |= JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
            current = current.getNextSibling();
        }
        boolean sourceMaps = SourceMapUtil.isSourceMapsComment(startNode);
        if (startNode.getPsi() != endElement || sourceMaps) {
            int adjustmentOffset = 0;
            if (this.isImportNode(startNode.getElementType())) {
                adjustmentOffset = IMPORT_OFFSET;
            } else if (sourceMaps) {
                adjustmentOffset = "//# sourceMappingURL=data:application/json;".length();
            }
            TextRange rangeToFold = new TextRange(startNode.getStartOffset() + adjustmentOffset, endElement.getNode().getStartOffset() + endElement.getTextLength());
            if (!containsCustomRegionMarker) {
                this.addDescriptorForRange(startNode, descriptors, rangeToFold, placeHolder, collapsedBD);
            }
            ASTNode aSTNode = endElement.getNode();
            if (aSTNode == null) {
                JavaScriptFoldingBuilderBase.$$$reportNull$$$0(19);
            }
            return aSTNode;
        }
        ASTNode aSTNode = startNode;
        if (aSTNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        return aSTNode;
    }

    private boolean isImportNode(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        return this.getImportTokenTypes().contains(type2);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        if (range == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(23);
        }
        return null;
    }

    @NotNull
    private static String endOfLineCommentPlaceholder(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(24);
        }
        if (SourceMapUtil.isSourceMapsComment(node)) {
            return "...";
        }
        ASTNode treeNext = node.getTreeNext();
        while (JavaScriptFoldingBuilderBase.isNewLine(treeNext)) {
            String text2 = node.getText();
            if (text2.startsWith("//") && (text2 = text2.substring(2).trim()).length() > 1) {
                String string = "// " + (text2.length() > 50 ? text2.substring(0, 50) : text2) + "...";
                if (string == null) {
                    JavaScriptFoldingBuilderBase.$$$reportNull$$$0(25);
                }
                return string;
            }
            node = treeNext.getTreeNext();
            treeNext = node == null ? null : node.getTreeNext();
        }
        return "//...";
    }

    @NotNull
    private static String cStyleCommentPlaceholder(@NotNull ASTNode node) {
        String text2;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(26);
        }
        ASTNode treePrev = node.getTreePrev();
        ASTNode treeNext = node.getTreeNext();
        if (JavaScriptFoldingBuilderBase.isShortSingleLineComment(node)) {
            return "/*...*/";
        }
        if ((treePrev == null || JavaScriptFoldingBuilderBase.isNewLine(treePrev)) && (treeNext == null || JavaScriptFoldingBuilderBase.isNewLine(treeNext)) && (text2 = node.getText()).startsWith("/*") && text2.endsWith("*/") && text2.length() >= 4) {
            String[] parts;
            text2 = text2.substring(2, text2.length() - 2);
            for (String part : parts = text2.split("[\r\n]")) {
                if ((part = StringUtil.trimLeading((String)part.trim(), (char)'*')).length() <= 1) continue;
                if (part.length() > 50) {
                    part = part.substring(0, 50);
                }
                String string = "/* " + part + "...*/";
                if (string == null) {
                    JavaScriptFoldingBuilderBase.$$$reportNull$$$0(27);
                }
                return string;
            }
        }
        return "/*...*/";
    }

    @NotNull
    private static String docCommentPlaceholder(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(28);
        }
        String text2 = node.getText();
        StringTokenizer tokenizer = new StringTokenizer(text2, "\n\r");
        Object firstLine = "";
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String content;
            ProgressManager.checkCanceled();
            String candidate = tokenizer.nextToken();
            Matcher matcher = DOC_COMMENT_CONTENT.matcher(candidate);
            if (matcher.matches() && !StringUtil.isEmpty((String)(content = matcher.group(2)))) {
                firstLine = matcher.group(1) + content + " ";
                break;
            }
            firstToken = false;
        }
        if (firstToken) {
            Matcher matcher = DOC_TYPE_COMMENT.matcher((CharSequence)firstLine);
            if (matcher.matches()) {
                String typeString = matcher.group(1);
                if (StringUtil.isEmpty((String)typeString)) {
                    typeString = matcher.group(2);
                }
                if (!StringUtil.isEmpty((String)typeString)) {
                    String string = "/*" + typeString + "*/";
                    if (string == null) {
                        JavaScriptFoldingBuilderBase.$$$reportNull$$$0(29);
                    }
                    return string;
                }
            }
            return "/**...*/";
        }
        Object object = JavaScriptFoldingBuilderBase.isShortSingleLineComment(node) ? "/**...*/" : "/**" + (String)firstLine + "...*/";
        if (object == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(30);
        }
        return object;
    }

    private static boolean isNewLine(ASTNode treePrev) {
        return treePrev instanceof PsiWhiteSpace && treePrev.getText().contains("\n");
    }

    protected String getBlockPlaceholderText() {
        return "{...}";
    }

    private String getObjectPlaceholderText(@NotNull JSObjectLiteralExpression node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(31);
        }
        JSProperty[] properties = node.getProperties();
        JSProperty candidate = null;
        for (JSProperty property : properties) {
            String name = property.getName();
            boolean isId = "id".equals(name) || "name".equals(name);
            JSExpression value = property.getValue();
            if (!JSSymbolUtil.isAccurateReferenceExpression(value) && (!(value instanceof JSLiteralExpression) || !isId && !((JSLiteralExpression)value).isQuotedLiteral())) continue;
            if (candidate == null || isId) {
                candidate = property;
            }
            if (isId) break;
        }
        if (candidate != null) {
            PsiElement nameElement = candidate.getNameIdentifier();
            JSExpression valueElement = candidate.getValue();
            return this.getFoldedTestByProperty(nameElement != null ? nameElement.getText() : "", valueElement != null ? valueElement.getText() : "");
        }
        return JsonCollectionPsiPresentationUtils.getCollectionPsiPresentationText((int)properties.length);
    }

    @NotNull
    private static String getStringTemplatePlaceholder(@NotNull ASTNode templateExpressionNode) {
        if (templateExpressionNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(32);
        }
        String text2 = templateExpressionNode.getText();
        text2 = StringUtil.unquoteString((String)text2, (char)'`');
        int lineEnd = (text2 = StringUtil.unescapeChar((String)text2, (char)'`')).indexOf(10);
        if (lineEnd >= 0) {
            text2 = text2.substring(0, lineEnd);
        }
        text2 = text2.substring(0, Math.min(text2.length(), 50));
        text2 = text2.trim();
        String string = "`" + text2 + "...`";
        if (string == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    protected String getFoldedTestByProperty(String nameText, String valueText) {
        String string = "{" + nameText + ": " + valueText + "...}";
        if (string == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(34);
        }
        return string;
    }

    protected abstract JSCodeFoldingSettings getCodeFoldingSettings();

    private boolean isCollapseFileHeaderComment(@NotNull ASTNode node) {
        ASTNode parentNode;
        IElementType parentType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(35);
        }
        IElementType iElementType = parentType = (parentNode = node.getTreeParent()) != null ? parentNode.getElementType() : null;
        if (parentType instanceof JSFileElementType && node.getTreePrev() == null && node.getPsi() instanceof PsiComment) {
            return this.getCodeFoldingSettings().isCollapseFileHeaders();
        }
        return false;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(36);
        }
        return false;
    }

    private static boolean isFunctionBlockBody(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(37);
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(node.getElementType())) {
            ASTNode parent = node.getTreeParent();
            return parent != null && JavaScriptFoldingBuilderBase.isFunction(parent.getElementType());
        }
        return false;
    }

    private static boolean isShorthandArrowFunctionBody(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(38);
        }
        if (JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(node.getElementType())) {
            ASTNode parent = node.getTreeParent();
            return parent != null && JavaScriptFoldingBuilderBase.isFunction(parent.getElementType());
        }
        return false;
    }

    private static boolean isFunction(IElementType type2) {
        return JSElementTypes.FUNCTION_DECLARATIONS.contains(type2) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type2) || JSStubElementTypes.TYPESCRIPT_FUNCTION.equals(type2) || JSStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION.equals(type2);
    }

    protected final boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(39);
        }
        return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || node.getPsi() instanceof PsiComment && !node.textContains('\n');
    }

    protected final boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(40);
        }
        return (nodeType = node.getElementType()) == JSFileElementTypes.FILE || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(nodeType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 25, 27, 29, 30, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 19: 
            case 20: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpressionNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "endOfLineCommentPlaceholder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "cStyleCommentPlaceholder";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "docCommentPlaceholder";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringTemplatePlaceholder";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedTestByProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryFoldOneLineBlockFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLeftText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "linesAreClose";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorForRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collapseImport";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 19: 
            case 20: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isImportNode";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "endOfLineCommentPlaceholder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "cStyleCommentPlaceholder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "docCommentPlaceholder";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPlaceholderText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStringTemplatePlaceholder";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCollapseFileHeaderComment";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionBlockBody";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunctionBody";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 25, 27, 29, 30, 33, 34 -> new IllegalStateException(string);
        };
    }
}

