/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.flow.lsp.FlowJSOpenedFilesTracker;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\nH\u0016J)\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0014J'\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0018R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSOpenedFilesTracker;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "openedFiles", "Ljava/util/HashMap;", "", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lkotlin/collections/HashMap;", "closeLastEditor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "executor", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl;", "closeLastEditor$intellij_javascript_impl", "dispose", "fileSaved", "fileSaved$intellij_javascript_impl", "openEditor", "service", "Lcom/intellij/lang/javascript/flow/lsp/FlowJSLspService;", "openEditor$intellij_javascript_impl", "intellij.javascript.impl"})
public final class FlowJSOpenedFilesTracker
implements Disposable {
    @NotNull
    private final HashMap<String, DocumentListener> openedFiles;

    public FlowJSOpenedFilesTracker(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.openedFiles = new HashMap();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public final void openEditor$intellij_javascript_impl(@NotNull VirtualFile file, @NotNull FlowJSLspService service2, @Nullable JSLanguageServiceExecutorImpl executor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
            String uri = FlowJSLspServiceKt.toURI(file);
            Object[] objectArray = (Object[])ApplicationManager.getApplication().runReadAction(() -> FlowJSOpenedFilesTracker.openEditor$lambda$0(file));
            if (objectArray == null) {
                return;
            }
            Object[] document2 = objectArray;
            JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl = executor;
            if (jSLanguageServiceExecutorImpl == null) break block1;
            objectArray = new Object[]{uri};
            jSLanguageServiceExecutorImpl.submit(EditorBundle.message((String)"editor.open.file.progress", (Object[])objectArray), () -> FlowJSOpenedFilesTracker.openEditor$lambda$1(this, uri, (Document)document2, service2, executor));
        }
    }

    public final void closeLastEditor$intellij_javascript_impl(@NotNull VirtualFile file, @Nullable LanguageServer languageServer, @Nullable JSLanguageServiceExecutorImpl executor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document2 = FileDocumentManager.getInstance().getDocument(file);
            if (document2 == null) {
                return;
            }
            Document document3 = document2;
            JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl = executor;
            if (jSLanguageServiceExecutorImpl == null) break block1;
            jSLanguageServiceExecutorImpl.submit(null, () -> FlowJSOpenedFilesTracker.closeLastEditor$lambda$2(file, this, document3, languageServer));
        }
    }

    public final void fileSaved$intellij_javascript_impl(@NotNull VirtualFile file, @Nullable LanguageServer languageServer, @Nullable JSLanguageServiceExecutorImpl executor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl = executor;
            if (jSLanguageServiceExecutorImpl == null) break block0;
            jSLanguageServiceExecutorImpl.submit(null, () -> FlowJSOpenedFilesTracker.fileSaved$lambda$3(file, this, languageServer));
        }
    }

    public void dispose() {
    }

    private static final Document openEditor$lambda$0(VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return FileDocumentManager.getInstance().getDocument($file);
    }

    private static final Unit openEditor$lambda$1(FlowJSOpenedFilesTracker this$0, String $uri, Document $document, FlowJSLspService $service, JSLanguageServiceExecutorImpl $executor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
            Intrinsics.checkNotNullParameter((Object)$service, (String)"$service");
            if (this$0.openedFiles.containsKey($uri)) {
                return Unit.INSTANCE;
            }
            DocumentListener documentListener2 = new DocumentListener($uri, $executor, $service){
                final /* synthetic */ String $uri;
                final /* synthetic */ JSLanguageServiceExecutorImpl $executor;
                final /* synthetic */ FlowJSLspService $service;
                {
                    this.$uri = $uri;
                    this.$executor = $executor;
                    this.$service = $service;
                }

                public void beforeDocumentChange(@NotNull DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Document document2 = event.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                    Document eventDocument = document2;
                    VersionedTextDocumentIdentifier documentId = new VersionedTextDocumentIdentifier(this.$uri, Integer.valueOf((int)eventDocument.getModificationStamp()));
                    Range range = new Range(FlowJSLspServiceKt.getPositionByOffset(eventDocument, event.getOffset()), FlowJSLspServiceKt.getPositionByOffset(eventDocument, event.getOffset() + event.getOldLength()));
                    TextDocumentContentChangeEvent lspEvent = new TextDocumentContentChangeEvent(range, Integer.valueOf(event.getOldLength()), ((Object)event.getNewFragment()).toString());
                    Object[] objectArray = new TextDocumentContentChangeEvent[]{lspEvent};
                    DidChangeTextDocumentParams didChangeTextDocumentParams = new DidChangeTextDocumentParams(documentId, CollectionsKt.mutableListOf((Object[])objectArray));
                    objectArray = new Object[]{this.$uri};
                    this.$executor.submit(JavaScriptBundle.message("progress.text.modifying", objectArray), () -> openEditor.1.documentListener.1.beforeDocumentChange$lambda$0(this.$service, didChangeTextDocumentParams));
                }

                private static final Unit beforeDocumentChange$lambda$0(FlowJSLspService $service, DidChangeTextDocumentParams $didChangeTextDocumentParams) {
                    Intrinsics.checkNotNullParameter((Object)$service, (String)"$service");
                    Intrinsics.checkNotNullParameter((Object)$didChangeTextDocumentParams, (String)"$didChangeTextDocumentParams");
                    LanguageServer languageServer = $service.getLanguageServer();
                    if (languageServer != null && (languageServer = languageServer.getTextDocumentService()) != null) {
                        languageServer.didChange($didChangeTextDocumentParams);
                    }
                    $service.requestSave();
                    return Unit.INSTANCE;
                }
            };
            ((Map)this$0.openedFiles).put($uri, documentListener2);
            $document.addDocumentListener(documentListener2, (Disposable)this$0);
            TextDocumentItem textDocumentItem = new TextDocumentItem($uri, "javascript", (int)$document.getModificationStamp(), $document.getText());
            LanguageServer languageServer = $service.getLanguageServer();
            if (languageServer == null || (languageServer = languageServer.getTextDocumentService()) == null) break block1;
            languageServer.didOpen(new DidOpenTextDocumentParams(textDocumentItem));
        }
        return Unit.INSTANCE;
    }

    private static final Unit closeLastEditor$lambda$2(VirtualFile $file, FlowJSOpenedFilesTracker this$0, Document $document, LanguageServer $languageServer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
            String uri = FlowJSLspServiceKt.toURI($file);
            DocumentListener listener2 = this$0.openedFiles.remove(uri);
            if (listener2 == null) break block1;
            $document.removeDocumentListener(listener2);
            LanguageServer languageServer = $languageServer;
            if (languageServer != null && (languageServer = languageServer.getTextDocumentService()) != null) {
                languageServer.didClose(new DidCloseTextDocumentParams(new TextDocumentIdentifier(uri)));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit fileSaved$lambda$3(VirtualFile $file, FlowJSOpenedFilesTracker this$0, LanguageServer $languageServer) {
        block0: {
            LanguageServer languageServer;
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            String uri = FlowJSLspServiceKt.toURI($file);
            if (!((Map)this$0.openedFiles).containsKey(uri) || (languageServer = $languageServer) == null || (languageServer = languageServer.getTextDocumentService()) == null) break block0;
            languageServer.didSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(uri)));
        }
        return Unit.INSTANCE;
    }
}

