/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.evaluation;

import com.intellij.psi.PsiElement;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeEvaluationLocationProvider {
    private static final ThreadLocal<State> evaluationLocation = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withTypeEvaluationLocation(@Nullable PsiElement location, @NotNull Supplier<T> supplier) {
        if (supplier == null) {
            JSTypeEvaluationLocationProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            return supplier.get();
        }
        State currentState = evaluationLocation.get();
        if (currentState == null) {
            evaluationLocation.set(new State(location, false));
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (currentState == null) {
                evaluationLocation.remove();
            }
        }
    }

    public static void withTypeEvaluationLocation(@Nullable PsiElement location, @NotNull Runnable runnable) {
        if (runnable == null) {
            JSTypeEvaluationLocationProvider.$$$reportNull$$$0(1);
        }
        if (location == null) {
            runnable.run();
            return;
        }
        State currentState = evaluationLocation.get();
        if (currentState == null) {
            evaluationLocation.set(new State(location, false));
        }
        try {
            runnable.run();
        }
        finally {
            if (currentState == null) {
                evaluationLocation.remove();
            }
        }
    }

    public static void withGistCalculation(@Nullable PsiElement location, @NotNull Runnable runnable) {
        if (runnable == null) {
            JSTypeEvaluationLocationProvider.$$$reportNull$$$0(2);
        }
        State currentState = evaluationLocation.get();
        evaluationLocation.set(new State(location, true));
        try {
            runnable.run();
        }
        finally {
            if (currentState == null) {
                evaluationLocation.remove();
            } else {
                evaluationLocation.set(currentState);
            }
        }
    }

    @Nullable
    public static PsiElement getTypeEvaluationLocation() {
        State state = evaluationLocation.get();
        if (state == null) {
            return null;
        }
        return state.location();
    }

    public static boolean isCalculatingGists() {
        State state = evaluationLocation.get();
        return state != null && state.calculatingGists;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/evaluation/JSTypeEvaluationLocationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withTypeEvaluationLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withGistCalculation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record State(@Nullable PsiElement location, boolean calculatingGists) {
    }
}

