/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileImportsBase;
import com.intellij.lang.javascript.config.JSSimpleFileInclude;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileExportsImpl
extends JSFileImportsBase {
    @NotNull
    private static final TokenSet EXPORTS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DECLARATION});
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final PsiManager myPsiManager;
    private final boolean myHasNodeModulesDirInPath;

    public JSFileExportsImpl(@NotNull Project project, @NotNull JSConfig config, @NotNull VirtualFile startFile) {
        if (project == null) {
            JSFileExportsImpl.$$$reportNull$$$0(0);
        }
        if (config == null) {
            JSFileExportsImpl.$$$reportNull$$$0(1);
        }
        if (startFile == null) {
            JSFileExportsImpl.$$$reportNull$$$0(2);
        }
        super(project, config);
        this.myFile = startFile;
        this.myHasNodeModulesDirInPath = NodeModuleUtil.hasNodeModulesDirInPath(startFile, null);
        this.myPsiManager = PsiManager.getInstance((Project)this.myProject);
    }

    public JSFileExportsImpl(@NotNull Project project, @NotNull JSSimpleFileInclude include, @NotNull VirtualFile startFile) {
        if (project == null) {
            JSFileExportsImpl.$$$reportNull$$$0(3);
        }
        if (include == null) {
            JSFileExportsImpl.$$$reportNull$$$0(4);
        }
        if (startFile == null) {
            JSFileExportsImpl.$$$reportNull$$$0(5);
        }
        super(project, include.getResolveContext(), include.getImportResolver());
        this.myFile = startFile;
        this.myHasNodeModulesDirInPath = NodeModuleUtil.hasNodeModulesDirInPath(startFile, null);
        this.myPsiManager = PsiManager.getInstance((Project)this.myProject);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Set<VirtualFile> set = Collections.singleton(this.myFile);
        if (set == null) {
            JSFileExportsImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        PsiFile psiFile2;
        if (file == null) {
            JSFileExportsImpl.$$$reportNull$$$0(7);
        }
        if (!((psiFile2 = this.myPsiManager.findFile(file)) instanceof JSFile)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSFileExportsImpl.$$$reportNull$$$0(8);
            }
            return set;
        }
        PsiElement[] elements = JSStubBasedPsiTreeUtil.getChildrenByType((PsiElement)psiFile2, EXPORTS_TOKEN_SET);
        if (elements.length == 0) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSFileExportsImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(elements.length);
        for (PsiElement el : elements) {
            VirtualFile resolved;
            String text2;
            ES6ExportDeclaration declaration = (ES6ExportDeclaration)el;
            ES6FromClause clause = declaration.getFromClause();
            if (clause == null || (text2 = clause.getReferenceText()) == null || !this.isAcceptable(resolved = this.resolveFile(ES6FileIncludeProvider.preProcessPath(text2), file))) continue;
            result2.add(resolved);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSFileExportsImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Contract(value="null->false")
    protected boolean isAcceptable(@Nullable VirtualFile resolved) {
        return resolved != null && this.myHasNodeModulesDirInPath == NodeModuleUtil.hasNodeModulesDirInPath(resolved, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/config/JSFileExportsImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/config/JSFileExportsImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOutFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

