/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NpmRunConfigurationUtil {
    private NpmRunConfigurationUtil() {
    }

    public static void check(@NotNull Project project, @NotNull NpmRunSettings settings2) throws RuntimeConfigurationError {
        String message;
        NodePackage npmPkg;
        String packageJsonPath;
        if (project == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        if ((packageJsonPath = settings2.getPackageJsonSystemIndependentPath()).isEmpty()) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.please.specify.package.json", new Object[0]));
        }
        File packageJson2 = new File(packageJsonPath);
        if (!packageJson2.isAbsolute() || !packageJson2.isFile()) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.please.specify.package.json.correctly", new Object[0]));
        }
        if (settings2.getCommand() == NpmCommand.RUN_SCRIPT) {
            NpmRunConfigurationUtil.validateScript(project, packageJsonPath, settings2.getScriptNames());
        }
        NodeJsInterpreter interpreter2 = settings2.getInterpreterRef().resolve(project);
        NodeInterpreterUtil.checkForRunConfiguration(interpreter2);
        try {
            npmPkg = NpmUtil.resolvePackageRefOrThrow(settings2.getPackageManagerPackageRef(), project, interpreter2);
        }
        catch (ExecutionException e) {
            throw new RuntimeConfigurationError(e.getMessage());
        }
        if (!(interpreter2 instanceof NodeJsRemoteInterpreter) && (message = npmPkg.validateAndGetErrorMessage("npm/yarn", project, interpreter2)) != null) {
            throw new RuntimeConfigurationError(message);
        }
        NpmRunConfigurationUtil.validateCommand(settings2.getCommand(), npmPkg);
    }

    private static void validateScript(@NotNull Project project, @NotNull String packageJsonPath, @NotNull List<String> scriptNames) throws RuntimeConfigurationError {
        if (project == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        if (packageJsonPath == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (scriptNames == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        if (scriptNames.isEmpty()) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.please.specify.npm.scripts.to.run", new Object[0]));
        }
        VirtualFile packageJson2 = LocalFileSystem.getInstance().findFileByPath(packageJsonPath);
        if (packageJson2 != null && packageJson2.isValid() && !packageJson2.isDirectory()) {
            try {
                NpmScriptsStructure structure = NpmScriptsService.getInstance(project).fetchBuildfileStructure(packageJson2);
                for (String scriptName : scriptNames) {
                    if (structure.getTaskNames().contains(scriptName)) continue;
                    throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.no.npm.script", scriptName));
                }
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {
                // empty catch block
            }
        }
    }

    private static void validateCommand(@NotNull NpmCommand command, @NotNull NodePackage npmPkg) throws RuntimeConfigurationError {
        boolean yarn;
        if (command == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        if (npmPkg == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (!NpmCommand.getCommands(yarn = NpmUtil.isYarnAlikePackage(npmPkg)).contains((Object)command)) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.command.supported.by", command.getCliOption(yarn), npmPkg.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateScript";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

