/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myGulpfilePath;
    private final String myGulpfileSystemIndependentPath;
    private final List<String> myTasks;
    private final String myArguments;
    private final EnvironmentVariablesData myEnvData;
    private final boolean myNewEnvFormat;

    public GulpRunSettings(@NotNull Builder builder2) {
        if (builder2 == null) {
            GulpRunSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterRef = builder2.myInterpreterRef;
        this.myNodeOptions = builder2.myNodeOptions;
        this.myGulpfilePath = FileUtil.toSystemDependentName((String)builder2.myGulpfilePath);
        this.myGulpfileSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder2.myGulpfilePath);
        this.myTasks = List.copyOf(builder2.myTasks);
        this.myArguments = builder2.myArguments;
        this.myEnvData = builder2.myEnvData;
        this.myNewEnvFormat = builder2.myNewEnvFormat;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            GulpRunSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGulpfilePath() {
        String string = this.myGulpfilePath;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public VirtualFile getGulpfile() {
        if (this.myGulpfileSystemIndependentPath.isEmpty()) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myGulpfileSystemIndependentPath);
        return file == null || file.isDirectory() ? null : file;
    }

    @NotNull
    public String getGulpfileSystemIndependentPath() {
        String string = this.myGulpfileSystemIndependentPath;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            GulpRunSettings.$$$reportNull$$$0(5);
        }
        return environmentVariablesData;
    }

    public boolean isNewEnvFormat() {
        return this.myNewEnvFormat;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list2 = this.myTasks;
        if (list2 == null) {
            GulpRunSettings.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GulpRunSettings that = (GulpRunSettings)o;
        return this.myEnvData.equals((Object)that.myEnvData) && this.myNodeOptions.equals(that.myNodeOptions) && this.myGulpfilePath.equals(that.myGulpfilePath) && this.myTasks.equals(that.myTasks) && this.myArguments.equals(that.myArguments);
    }

    public int hashCode() {
        int result2 = this.myGulpfilePath.hashCode();
        result2 = 31 * result2 + this.myNodeOptions.hashCode();
        result2 = 31 * result2 + this.myTasks.hashCode();
        result2 = 31 * result2 + this.myArguments.hashCode();
        result2 = 31 * result2 + this.myEnvData.hashCode();
        return result2;
    }

    @NotNull
    public static Builder builder(@NotNull GulpRunSettings settings2) {
        if (settings2 == null) {
            GulpRunSettings.$$$reportNull$$$0(8);
        }
        return new Builder(settings2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpfilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpfileSystemIndependentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myGulpfilePath;
        private List<String> myTasks;
        private String myArguments;
        private EnvironmentVariablesData myEnvData;
        private boolean myNewEnvFormat;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
        }

        public Builder(@NotNull GulpRunSettings settings2) {
            if (settings2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
            this.myNodeOptions = settings2.getNodeOptions();
            this.myGulpfilePath = settings2.getGulpfilePath();
            this.myTasks = List.copyOf(settings2.getTasks());
            this.myEnvData = settings2.getEnvData();
            this.myNewEnvFormat = settings2.isNewEnvFormat();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setNodeOptions(@Nullable String nodeOptions) {
            this.myNodeOptions = StringUtil.notNullize((String)nodeOptions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        public Builder setGulpfilePath(@Nullable String gulpfilePath) {
            this.myGulpfilePath = StringUtil.notNullize((String)gulpfilePath);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder setTasks(@NotNull List<String> tasks) {
            if (tasks == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myTasks = List.copyOf(tasks);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myEnvData = envData;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        public void setNewEnvFormat(boolean newEnvFormat) {
            this.myNewEnvFormat = newEnvFormat;
        }

        @NotNull
        public GulpRunSettings build() {
            return new GulpRunSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGulpfilePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTasks";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTasks";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6, 8, 10 -> new IllegalStateException(string);
            };
        }
    }
}

