/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParseException;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParser;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpJsonTaskListParser
implements GulpTaskListParser {
    public static final GulpJsonTaskListParser INSTANCE = new GulpJsonTaskListParser();
    private static final String NO_JSON_MESSAGE = "No JSON found";

    @Override
    @NotNull
    public List<Pair<String, List<String>>> parseTaskList(@NotNull String text2) throws GulpTaskListParseException {
        char[] buffer;
        int endInd;
        if (text2 == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(0);
        }
        if ((endInd = CharArrayUtil.lastIndexOf((char[])(buffer = text2.toCharArray()), (char)'}', (int)0, (int)buffer.length)) < 0) {
            throw new GulpTaskListParseException(NO_JSON_MESSAGE);
        }
        GulpTaskListParseException firstException = null;
        int startInd = CharArrayUtil.indexOf((char[])buffer, (char)'{', (int)0, (int)endInd);
        while (startInd >= 0 && startInd < endInd) {
            List<Pair<String, List<String>>> list2;
            try {
                list2 = GulpJsonTaskListParser.doParse((CharSequence)new CharArrayCharSequence(buffer, startInd, endInd + 1));
            }
            catch (GulpTaskListParseException e) {
                if (firstException == null) {
                    firstException = e;
                }
                startInd = CharArrayUtil.indexOf((char[])buffer, (char)'{', (int)(startInd + 1), (int)endInd);
                continue;
            }
            if (list2 == null) {
                GulpJsonTaskListParser.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (firstException != null) {
            throw firstException;
        }
        throw new GulpTaskListParseException(NO_JSON_MESSAGE);
    }

    private static List<Pair<String, List<String>>> doParse(@NotNull CharSequence jsonString) throws GulpTaskListParseException {
        List<Pair<String, List<String>>> list2;
        if (jsonString == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(2);
        }
        JsonReader jsonReader = new JsonReader((Reader)new CharSequenceReader(jsonString));
        try {
            list2 = GulpJsonTaskListParser.doParse(jsonReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GulpTaskListParseException("Failed to parse JSON", e);
            }
        }
        jsonReader.close();
        return list2;
    }

    @NotNull
    private static List<Pair<String, List<String>>> doParse(JsonReader reader2) throws IOException {
        reader2.beginObject();
        List<Pair<String, List<String>>> result2 = new ArrayList<Pair<String, List<String>>>();
        while (reader2.hasNext()) {
            String name = reader2.nextName();
            if ("nodes".equals(name)) {
                result2 = GulpJsonTaskListParser.readNodes(reader2);
                continue;
            }
            reader2.skipValue();
        }
        reader2.endObject();
        ArrayList<Pair<String, List<String>>> arrayList = result2;
        if (arrayList == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<Pair<String, List<String>>> readNodes(@NotNull JsonReader reader2) throws IOException {
        if (reader2 == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(4);
        }
        reader2.beginArray();
        ArrayList<Pair<String, List<String>>> result2 = new ArrayList<Pair<String, List<String>>>();
        while (reader2.hasNext()) {
            JsonToken token = reader2.peek();
            if (token == JsonToken.BEGIN_OBJECT) {
                Pair<String, List<String>> pair = GulpJsonTaskListParser.readTask(reader2);
                if (pair == null) continue;
                result2.add(pair);
                continue;
            }
            reader2.skipValue();
        }
        reader2.endArray();
        ArrayList<Pair<String, List<String>>> arrayList = result2;
        if (arrayList == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static Pair<String, List<String>> readTask(@NotNull JsonReader reader2) throws IOException {
        JsonToken token;
        if (reader2 == null) {
            GulpJsonTaskListParser.$$$reportNull$$$0(6);
        }
        if ((token = reader2.peek()) != JsonToken.BEGIN_OBJECT) {
            reader2.skipValue();
            return null;
        }
        reader2.beginObject();
        String taskName = null;
        String type2 = null;
        while (reader2.hasNext()) {
            String key2 = reader2.nextName();
            if ("label".equals(key2)) {
                taskName = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            if ("type".equals(key2)) {
                type2 = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            reader2.skipValue();
        }
        reader2.endObject();
        if ("task".equals(type2) && taskName != null) {
            return Pair.create((Object)taskName, Collections.emptyList());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonString";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTaskList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseTaskList";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }
}

