/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlink;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlinkSupport;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtFileListener;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtPersistentPath;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListingFailUtil;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayout;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayoutManager;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeUiState;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtTaskTreeView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JsbtTaskTreeView.class);
    private static final String ROOT = "<root>";
    private final Project myProject;
    private final JsbtService myService;
    private final String myLayoutPlace;
    private final JsbtFileManager myBuildfileManager;
    private final DefaultMutableTreeNode myTreeRoot;
    private final DefaultTreeModel myTreeModel;
    private final Tree myTree;
    private final MyJsbtFileListener myListener;
    private int myActiveTaskReloadCount;
    private final List<Runnable> myActionCallbacks;

    public JsbtTaskTreeView(@NotNull JsbtService service2, @NotNull Project project, @Nullable String layoutPlace) {
        if (service2 == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(1);
        }
        this.myActiveTaskReloadCount = 0;
        this.myActionCallbacks = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myService = service2;
        this.myLayoutPlace = layoutPlace;
        this.myBuildfileManager = this.myService.getFileManager();
        this.myTreeRoot = new DefaultMutableTreeNode(ROOT, true);
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot, false);
        this.myTree = new JsbtTree(project, this.myTreeModel, this);
        this.myListener = new MyJsbtFileListener();
    }

    public void init() {
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.getEmptyText().setText(this.getEmptyText());
        this.myTree.setToggleClickCount(0);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new JsbtTreeCellRenderer()));
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.installSpeedSearch(this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.installUpDownCycleScrollingInPopups();
        this.installPopupActions();
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        this.myBuildfileManager.addListener(this.myListener, null);
        for (VirtualFile buildfile : this.myBuildfileManager.getBuildfiles()) {
            this.addBuildfile(buildfile);
        }
        this.restoreLayout();
        this.reloadTasksForAllBuildfiles(true, false);
        UiNotifyConnector.installOn((Component)this.myTree, (Activatable)new Activatable(){
            private boolean myShowing = false;

            public void showNotify() {
                if (!this.myShowing) {
                    JsbtTaskTreeView.this.reloadTasksForAllBuildfiles(true, true);
                    this.myShowing = true;
                }
            }

            public void hideNotify() {
                this.myShowing = false;
            }
        });
    }

    private void installUpDownCycleScrollingInPopups() {
        if (this.myLayoutPlace == null || !UISettings.getInstance().getCycleScrolling()) {
            return;
        }
        this.myTree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path2;
                int size = JsbtTaskTreeView.this.myTree.getRowCount();
                int row = JsbtTaskTreeView.this.myTree.getLeadSelectionRow();
                if (size <= 1 || row > 0) {
                    TreeUtil.moveUp((JTree)JsbtTaskTreeView.this.myTree);
                } else if (row == 0 && (path2 = JsbtTaskTreeView.this.myTree.getPathForRow(size - 1)) != null) {
                    TreeUtil.selectPath((JTree)JsbtTaskTreeView.this.myTree, (TreePath)path2);
                }
            }
        });
        this.myTree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = JsbtTaskTreeView.this.myTree.getRowCount();
                int row = JsbtTaskTreeView.this.myTree.getLeadSelectionRow();
                if (size <= 1 || row < size - 1) {
                    TreeUtil.moveDown((JTree)JsbtTaskTreeView.this.myTree);
                } else {
                    TreeUtil.promiseSelectFirst((JTree)JsbtTaskTreeView.this.myTree);
                }
            }
        });
    }

    @NotNull
    @NlsContexts.StatusText
    private String getEmptyText() {
        Shortcut shortcut = JsbtAddBuildfileAction.getKeyboardShortcut();
        if (shortcut != null) {
            String string = JavaScriptBundle.message("buildTools.add.with", this.myService.getApplicationService().getBuildfileCommonName(), KeymapUtil.getShortcutText((Shortcut)shortcut));
            if (string == null) {
                JsbtTaskTreeView.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = JavaScriptBundle.message("buildTools.no.files.added", new Object[0]);
        if (string == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract void addBuildfileChildren(@NotNull DefaultMutableTreeNode var1, @NotNull JsbtFileStructure var2);

    protected abstract boolean hasTaskNodes(@NotNull DefaultMutableTreeNode var1);

    protected abstract void customizeCell(@NotNull Project var1, @NotNull ColoredTreeCellRenderer var2, @NotNull DefaultMutableTreeNode var3);

    @Nullable
    protected abstract String getPersistentId(@NotNull DefaultMutableTreeNode var1);

    @Nullable
    @Nls
    protected final String getPresentableName(@NotNull DefaultMutableTreeNode node) {
        JsbtFileStructure structure;
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(4);
        }
        if ((structure = JsbtTree.getUserObject(node, JsbtFileStructure.class)) != null) {
            return structure.getPresentablePath();
        }
        return this.getPresentableTaskName(node);
    }

    @Nls
    protected abstract String getPresentableTaskName(@NotNull DefaultMutableTreeNode var1);

    @Nullable
    protected abstract JsbtTaskSet createTaskSetFromSelectedNodes();

    @Nullable
    protected abstract Navigatable createJumpToSourceDescriptor(@NotNull Project var1, @NotNull DefaultMutableTreeNode var2);

    protected boolean shouldShowSettingMenuItem() {
        return true;
    }

    private void restoreLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        JsbtTreeLayout layout = JsbtTreeLayoutManager.getInstance(this.myProject).getLayout(this.myLayoutPlace);
        if (layout == null) {
            return;
        }
        Point viewPosition = layout.getScrollPaneViewPosition();
        if (viewPosition != null) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myTree, () -> {
                JScrollPane scrollPane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
                if (scrollPane != null) {
                    scrollPane.getViewport().setViewPosition(viewPosition);
                }
            });
        }
        for (JsbtPersistentPath path2 : layout.getSelectedPaths()) {
            TreeNode nodeToSelect = this.findNodeByPath(path2);
            if (nodeToSelect == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
        }
    }

    private void saveLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        Point scrollPaneViewPosition = null;
        JScrollPane scrollPane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
        if (scrollPane != null) {
            scrollPaneViewPosition = scrollPane.getViewport().getViewPosition();
        }
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedNodes();
        ArrayList<JsbtPersistentPath> selectedPaths = new ArrayList<JsbtPersistentPath>();
        for (DefaultMutableTreeNode node : selectedNodes) {
            JsbtPersistentPath path2 = this.toPersistentPath(node);
            if (path2 == null) continue;
            selectedPaths.add(path2);
        }
        JsbtTreeLayout layout = new JsbtTreeLayout(this.myLayoutPlace, scrollPaneViewPosition, selectedPaths);
        JsbtTreeLayoutManager.getInstance(this.myProject).add(layout);
    }

    @Nullable
    private JsbtPersistentPath toPersistentPath(@NotNull DefaultMutableTreeNode node) {
        TreeNode n;
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(5);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (n = node; n != this.myTreeRoot && n instanceof DefaultMutableTreeNode; n = n.getParent()) {
            String id = this.getPersistentId((DefaultMutableTreeNode)n);
            if (id == null) {
                return null;
            }
            ids.add(id);
        }
        Collections.reverse(ids);
        return n == this.myTreeRoot ? new JsbtPersistentPath(ids) : null;
    }

    public void dispose() {
        this.saveLayout();
        this.myBuildfileManager.removeListener(this.myListener);
        this.myActionCallbacks.clear();
    }

    private void selectBuildfile(@NotNull VirtualFile buildfile) {
        DefaultMutableTreeNode node;
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(6);
        }
        if ((node = this.findBuildfileNode(buildfile)) != null) {
            DefaultMutableTreeNode child;
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myTree.setSelectionPath(path2);
            TreePath scrollPath = path2;
            if (this.myTree.isExpanded(path2) && node.getChildCount() > 0 && (child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(0), DefaultMutableTreeNode.class)) != null) {
                scrollPath = TreeUtil.getPathFromRoot((TreeNode)child);
            }
            this.myTree.scrollPathToVisible(scrollPath);
        }
    }

    public void addActionCallback(@NotNull Runnable callback) {
        if (callback == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(7);
        }
        this.myActionCallbacks.add(callback);
    }

    public void fireAction() {
        for (Runnable callback : this.myActionCallbacks) {
            callback.run();
        }
    }

    private void installSpeedSearch(@NotNull Tree tree) {
        if (tree == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(8);
        }
        TreeSpeedSearch.installOn((JTree)tree, (boolean)true, path2 -> {
            DefaultMutableTreeNode node = JsbtTree.toNode(path2);
            if (node != null) {
                return StringUtil.notNullize((String)this.getPresentableName(node));
            }
            return "";
        });
    }

    private void installPopupActions() {
        AnAction copyPathsAction;
        List actionList = List.of(new RunAction(), new DebugAction(), new EditRunSettingsAction(), new Separator(), new ShowTaskListSettingAction(), new JumpToSourceAction(), new ReloadTasks());
        AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
        if (copyAction != null) {
            copyAction.registerCustomShortcutSet(copyAction.getShortcutSet(), (JComponent)this.myTree);
        }
        if ((copyPathsAction = ActionManager.getInstance().getAction("CopyPaths")) != null) {
            actionList = ContainerUtil.append(actionList, (Object[])new AnAction[]{copyPathsAction});
        }
        actionList = ContainerUtil.append((List)actionList, (Object[])new AnAction[]{new JsbtRemoveBuildfileAction(this.myService.getApplicationService(), this)});
        DefaultActionGroup actionGroup = new DefaultActionGroup(actionList);
        for (AnAction action : actionList) {
            action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)this.myTree);
        }
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)actionGroup, (String)"JavaScriptBuildTool");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                JsbtTaskSet taskSet;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event.getButton() == 1 && clickCount == 2 && (taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                    new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).run();
                    JsbtTaskTreeView.this.fireAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$4", "onClick"));
            }
        }.installOn((Component)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode findBuildfileNode(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(9);
        }
        Ref buildfileNodeRef = Ref.create(null);
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileTreeNode -> {
            JsbtFileStructure structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class);
            if (structure != null && structure.getBuildfile().equals(buildfile)) {
                buildfileNodeRef.set(buildfileTreeNode);
                return false;
            }
            return true;
        }));
        return (DefaultMutableTreeNode)buildfileNodeRef.get();
    }

    public void reloadTasksForAllBuildfiles(boolean silently, boolean reloadFailedOnly) {
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileTreeNode -> {
            if (!reloadFailedOnly || JsbtTaskTreeView.getErrorInfo(buildfileTreeNode) != null) {
                this.reloadTasksFor((DefaultMutableTreeNode)buildfileTreeNode, silently);
            }
            return true;
        }));
    }

    private void iterateBuildfileNodes(@NotNull Processor<DefaultMutableTreeNode> processor) {
        DefaultMutableTreeNode buildfileTreeNode;
        if (processor == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(10);
        }
        int childCount = this.myTreeRoot.getChildCount();
        for (int i = 0; i < childCount && ((buildfileTreeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)this.myTreeRoot.getChildAt(i), DefaultMutableTreeNode.class)) == null || processor.process((Object)buildfileTreeNode)); ++i) {
        }
    }

    private void addBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(11);
        }
        if (!buildfile.isValid() || buildfile.isDirectory()) {
            return;
        }
        JsbtFileStructure structure = this.getOrCreateStructure(buildfile);
        this.updateBuildfileStructure(structure, () -> {
            DefaultMutableTreeNode buildfileTreeNode = new DefaultMutableTreeNode(structure, true);
            this.myTreeModel.insertNodeInto(buildfileTreeNode, this.myTreeRoot, this.myTreeRoot.getChildCount());
            this.setBuildfileChildren(buildfileTreeNode, structure, null);
            if (UIUtil.isShowing((Component)this.myTree)) {
                this.reloadTasksFor(buildfileTreeNode, true);
            }
        });
    }

    @NotNull
    private JsbtFileStructure getOrCreateStructure(@NotNull VirtualFile buildfile) {
        JsbtFileStructure structure;
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(12);
        }
        if ((structure = this.myBuildfileManager.getCachedStructure(buildfile)) == null) {
            structure = this.myService.createEmptyFileStructure(buildfile);
        }
        JsbtFileStructure jsbtFileStructure = structure;
        if (jsbtFileStructure == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(13);
        }
        return jsbtFileStructure;
    }

    private void updateBuildfileStructure(@NotNull JsbtFileStructure structure, @NotNull Runnable edtCallback) {
        if (structure == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(14);
        }
        if (edtCallback == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            structure.updateInBackground(this.myProject);
            ApplicationManager.getApplication().invokeLater(edtCallback, ModalityState.any(), this.myProject.getDisposed());
        });
    }

    private void reloadTasksFor(final @NotNull DefaultMutableTreeNode buildfileTreeNode, boolean silently) {
        StructureFetchErrorInfo errorInfo;
        JsbtFileStructure structure;
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(16);
        }
        if ((structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class)) == null) {
            LOG.warn("reloadTasksFor called on wrong tree node");
            return;
        }
        this.structureFetchStarted();
        boolean showLoadingNode = true;
        if (silently) {
            boolean bl = showLoadingNode = !this.hasTaskNodes(buildfileTreeNode);
        }
        if ((errorInfo = JsbtTaskTreeView.getErrorInfo(buildfileTreeNode)) != null) {
            JsbtTaskListingFailUtil.hideError(this.myProject, errorInfo.getException());
        }
        if (showLoadingNode) {
            boolean expand = buildfileTreeNode.getChildCount() == 0;
            buildfileTreeNode.removeAllChildren();
            buildfileTreeNode.add((MutableTreeNode)new LoadingNode());
            this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
            if (expand) {
                this.expandNode(buildfileTreeNode);
            }
        }
        this.myBuildfileManager.fetchStructureWithPresentableName(structure.getBuildfile(), (CatchingConsumer<? super JsbtFileStructure, ? super JsbtTaskFetchException.WrapperException>)new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException.WrapperException>(){

            public void consume(JsbtFileStructure structure) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, structure, null);
                JsbtTaskTreeView.this.structureFetchDone();
            }

            public void consume(JsbtTaskFetchException.WrapperException e) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, null, e);
                JsbtTaskTreeView.this.structureFetchDone();
            }
        });
    }

    @Nullable
    private static StructureFetchErrorInfo getErrorInfo(@NotNull DefaultMutableTreeNode buildfileTreeNode) {
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(17);
        }
        int childCount = buildfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)buildfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(childNode);
            if (errorInfo == null) continue;
            return errorInfo;
        }
        return null;
    }

    private void structureFetchStarted() {
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(true);
        }
        ++this.myActiveTaskReloadCount;
    }

    private void structureFetchDone() {
        --this.myActiveTaskReloadCount;
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(false);
        }
    }

    private void setBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @Nullable JsbtFileStructure structure, @Nullable JsbtTaskFetchException.WrapperException e) {
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(18);
        }
        if (structure == null && e == null) {
            LOG.error("Undefined structure and exception");
            return;
        }
        JsbtTreeUiState uiState = buildfileTreeNode.getChildCount() > 0 ? this.getUiState(buildfileTreeNode) : null;
        buildfileTreeNode.removeAllChildren();
        if (structure != null) {
            buildfileTreeNode.setUserObject(structure);
            this.addBuildfileChildren(buildfileTreeNode, structure);
            this.sort(buildfileTreeNode, this.getSortingMode());
        } else {
            buildfileTreeNode.setUserObject(e.getEmptyFileStructure());
            buildfileTreeNode.add(new DefaultMutableTreeNode(new StructureFetchErrorInfo(this.myProject, e.getJsbtTaskFetchException(), this), false));
        }
        this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
        if (uiState != null) {
            this.restoreUiState(uiState, buildfileTreeNode);
        } else {
            this.expandNode(buildfileTreeNode);
        }
    }

    private void sortAll(@NotNull JsbtSortingMode newSortingMode) {
        if (newSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(19);
        }
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileNode -> {
            JsbtTreeUiState uiState = buildfileNode.getChildCount() > 0 ? this.getUiState((DefaultMutableTreeNode)buildfileNode) : null;
            this.sort((DefaultMutableTreeNode)buildfileNode, newSortingMode);
            this.myTreeModel.nodeStructureChanged((TreeNode)buildfileNode);
            if (uiState != null) {
                this.restoreUiState(uiState, (DefaultMutableTreeNode)buildfileNode);
            }
            return true;
        }));
    }

    private void sort(@NotNull DefaultMutableTreeNode buildfileNode, @NotNull JsbtSortingMode newSortingMode) {
        if (buildfileNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(20);
        }
        if (newSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(21);
        }
        TreeUtil.sortRecursively((MutableTreeNode)buildfileNode, (node1, node2) -> this.compareNodes((DefaultMutableTreeNode)node1, (DefaultMutableTreeNode)node2, newSortingMode));
    }

    protected abstract int compareNodes(@NotNull DefaultMutableTreeNode var1, @NotNull DefaultMutableTreeNode var2, @NotNull JsbtSortingMode var3);

    @NotNull
    private JsbtTreeUiState getUiState(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(22);
        }
        JsbtTreeUiState state = new JsbtTreeUiState();
        this.addUiState(state, root, new JsbtPersistentPath(Collections.emptyList()));
        JsbtTreeUiState jsbtTreeUiState = state;
        if (jsbtTreeUiState == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(23);
        }
        return jsbtTreeUiState;
    }

    private void addUiState(@NotNull JsbtTreeUiState state, @NotNull TreeNode node, @NotNull JsbtPersistentPath path2) {
        boolean expanded;
        if (state == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(24);
        }
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(25);
        }
        if (path2 == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(26);
        }
        if (node instanceof LoadingNode) {
            return;
        }
        TreePath treePath = TreeUtil.getPathFromRoot((TreeNode)node);
        if (this.myTree.isPathSelected(treePath)) {
            state.addSelectedPath(path2);
        }
        if (!(expanded = this.myTree.isExpanded(treePath))) {
            state.addCollapsedPath(path2);
        }
        if (expanded) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null) continue;
                this.addUiState(state, child, path2.createChildPath(childId));
            }
        }
    }

    private void restoreUiState(@NotNull JsbtTreeUiState state, @NotNull DefaultMutableTreeNode root) {
        TreeNode node;
        if (state == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(27);
        }
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(28);
        }
        for (JsbtPersistentPath path2 : state.getSelectedPaths()) {
            node = this.findNodeByPath(path2, root);
            if (node == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
        for (JsbtPersistentPath path2 : state.getCollapsedPaths()) {
            node = this.findNodeByPath(path2, root);
            if (node == null) continue;
            this.myTree.collapsePath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path2) {
        if (path2 == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(29);
        }
        return this.findNodeByPath(path2, this.myTreeRoot);
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path2, @NotNull TreeNode root) {
        if (path2 == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(30);
        }
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(31);
        }
        TreeNode parent = root;
        for (String id : path2.getIds()) {
            DefaultMutableTreeNode newParent = null;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null || !childId.equals(id)) continue;
                newParent = child;
                break;
            }
            if (newParent == null) {
                return null;
            }
            parent = newParent;
        }
        return parent;
    }

    private void expandNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(32);
        }
        this.myTree.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
    }

    public boolean isReloading() {
        return this.myActiveTaskReloadCount > 0;
    }

    @NotNull
    public JsbtService getService() {
        JsbtService jsbtService = this.myService;
        if (jsbtService == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(33);
        }
        return jsbtService;
    }

    @NotNull
    public Tree getComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(34);
        }
        return tree;
    }

    @NotNull
    public List<DefaultMutableTreeNode> getSelectedNodes() {
        List<DefaultMutableTreeNode> list2 = JsbtTree.getSelectedNodes((JTree)this.myTree);
        if (list2 == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(35);
        }
        return list2;
    }

    public void showError(@NotNull Project project, @NotNull JsbtTaskFetchException e) {
        if (project == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(36);
        }
        if (e == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(37);
        }
        if (e.hasInvalidSettings()) {
            boolean ok = this.myService.showTaskListingSettingsDialog(e.getBuildfile());
            if (ok) {
                this.reloadTasksForAllBuildfiles(true, false);
            }
        } else {
            JsbtTaskListFetchFail fetchFail = e.getFetchFail();
            if (fetchFail != null) {
                JsbtTaskListingFailUtil.showError(project, fetchFail);
            } else {
                VirtualFile buildfile = e.getBuildfile();
                if (buildfile.isValid()) {
                    PsiNavigationSupport.getInstance().createNavigatable(this.myProject, buildfile, -1).navigate(true);
                } else {
                    PopupUtil.showBalloonForComponent((Component)this.myTree, (String)JavaScriptBundle.message("buildTools.no.such.file", new Object[0]), (MessageType)MessageType.WARNING, (boolean)true, null);
                }
            }
        }
    }

    @Nullable
    private JsbtFileStructure getSelectedBuildfileStructure() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.size() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes);
            return JsbtTree.getUserObject(node, JsbtFileStructure.class);
        }
        return null;
    }

    @NotNull
    public JsbtSortingMode getSortingMode() {
        JsbtSortingMode jsbtSortingMode = this.myService.getFileManager().getSortingMode();
        if (jsbtSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(38);
        }
        return jsbtSortingMode;
    }

    public void setSortingMode(@NotNull JsbtSortingMode sortingMode) {
        if (sortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(39);
        }
        this.myService.getFileManager().setSortingMode(sortingMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 13, 23, 33, 34, 35, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView";
                break;
            }
            case 4: 
            case 5: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtCallback";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileTreeNode";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSortingMode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileNode";
                break;
            }
            case 22: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateStructure";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPersistentPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectBuildfile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addActionCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installSpeedSearch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateBuildfileNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBuildfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateStructure";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateBuildfileStructure";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reloadTasksFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setBuildfileChildren";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sortAll";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUiState";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addUiState";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "restoreUiState";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByPath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setSortingMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 13, 23, 33, 34, 35, 38 -> new IllegalStateException(string);
        };
    }

    private class MyJsbtFileListener
    implements JsbtFileListener {
        private MyJsbtFileListener() {
        }

        @Override
        public void onBuildfileAdded(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(0);
            }
            JsbtTaskTreeView.this.addBuildfile(buildfile);
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileSelected(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(1);
            }
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileChanged(@NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
            DefaultMutableTreeNode buildfileNode;
            if (oldBuildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(2);
            }
            if (newBuildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(3);
            }
            if ((buildfileNode = JsbtTaskTreeView.this.findBuildfileNode(oldBuildfile)) != null) {
                JsbtFileStructure structure = JsbtTaskTreeView.this.getOrCreateStructure(newBuildfile);
                JsbtTaskTreeView.this.updateBuildfileStructure(structure, () -> {
                    buildfileNode.setUserObject(structure);
                    JsbtTaskTreeView.this.reloadTasksFor(buildfileNode, true);
                    JsbtTaskTreeView.this.myTreeModel.nodeChanged(buildfileNode);
                });
            }
        }

        @Override
        public void onBuildfileRemoved(@NotNull VirtualFile buildfile) {
            DefaultMutableTreeNode buildfileNode;
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(4);
            }
            if ((buildfileNode = JsbtTaskTreeView.this.findBuildfileNode(buildfile)) != null) {
                DefaultMutableTreeNode nodeToSelect = null;
                if (JsbtTaskTreeView.this.myTree.isPathSelected(TreeUtil.getPathFromRoot((TreeNode)buildfileNode)) && (nodeToSelect = buildfileNode.getNextSibling()) == null) {
                    nodeToSelect = buildfileNode.getPreviousSibling();
                }
                JsbtTaskTreeView.this.myTreeModel.removeNodeFromParent(buildfileNode);
                if (nodeToSelect != null) {
                    JsbtTaskTreeView.this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
                }
            }
        }

        @Override
        public void onSortingModeChanged(@NotNull JsbtSortingMode newSortingMode) {
            if (newSortingMode == null) {
                MyJsbtFileListener.$$$reportNull$$$0(5);
            }
            JsbtTaskTreeView.this.sortAll(newSortingMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildfile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldBuildfile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBuildfile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSortingMode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$MyJsbtFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileSelected";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSortingModeChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class JsbtTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeCellHyperlinkSupport myCellHyperlinkSupport;

        private JsbtTreeCellRenderer() {
            this.myCellHyperlinkSupport = TreeCellHyperlinkSupport.installOn((JTree)JsbtTaskTreeView.this.myTree);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                JsbtTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node instanceof LoadingNode) {
                    String text2 = (String)ObjectUtils.tryCast((Object)node.getUserObject(), String.class);
                    text2 = StringUtil.notNullize((String)text2, (String)LoadingNode.getText());
                    this.append(text2, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    return;
                }
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    this.setIcon(AllIcons.General.ExclMark);
                    this.setIconOnTheRight(false);
                    this.append(JavaScriptBundle.message("buildTools.failed.to.list.tasks", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append("  ");
                    int style = 0;
                    if (this.myCellHyperlinkSupport.isMouseInsideHyperlink()) {
                        style |= 0x10;
                    }
                    boolean hyperlinkBoundsUndefined = errorInfo.getHyperlinkBounds() == null;
                    Dimension dimensionBefore = null;
                    if (hyperlinkBoundsUndefined) {
                        dimensionBefore = this.computePreferredSize(false);
                    }
                    this.append(JavaScriptBundle.message("buildTools.failed.to.list.tasks.details.reference", new Object[0]), new SimpleTextAttributes(null, PlatformColors.BLUE, null, style));
                    if (hyperlinkBoundsUndefined) {
                        Dimension dimensionAfter = this.computePreferredSize(false);
                        Rectangle b = new Rectangle(dimensionBefore.width, 0, dimensionAfter.width - dimensionBefore.width, dimensionAfter.height);
                        errorInfo.setHyperlinkBounds(b);
                    }
                } else {
                    JsbtTaskTreeView.this.customizeCell(JsbtTaskTreeView.this.myProject, this, node);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JsbtTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private final class RunAction
    extends ExecuteAction {
        private RunAction() {
            super(DefaultRunExecutor.getRunExecutorInstance());
            this.setShortcutSet(CommonShortcuts.ENTER);
        }
    }

    private final class DebugAction
    extends ExecuteAction {
        private DebugAction() {
            super(DefaultDebugExecutor.getDebugExecutorInstance());
            ActionUtil.copyFrom((AnAction)this, (String)DefaultDebugExecutor.getDebugExecutorInstance().getContextActionId());
        }
    }

    private final class EditRunSettingsAction
    extends AnAction
    implements DumbAware {
        private EditRunSettingsAction() {
            super(AllIcons.Actions.EditSource);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                EditRunSettingsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditRunSettingsAction.$$$reportNull$$$0(1);
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText(JavaScriptBundle.message("buildTools.EditRunSettingsAction.text", taskSet.getName()));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtTaskSet taskSet;
            if (e == null) {
                EditRunSettingsAction.$$$reportNull$$$0(2);
            }
            if ((taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                JsbtExecutor executor = new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet);
                executor.editSettings();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$EditRunSettingsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$EditRunSettingsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ShowTaskListSettingAction
    extends AnAction
    implements DumbAware {
        private ShowTaskListSettingAction() {
            super(JsbtTaskTreeView.this.myService.getApplicationService().getToolWindowSettingsActionName(), null, AllIcons.General.GearPlain);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowTaskListSettingAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowTaskListSettingAction.$$$reportNull$$$0(1);
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            e.getPresentation().setEnabledAndVisible(JsbtTaskTreeView.this.shouldShowSettingMenuItem() && structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtFileStructure structure;
            if (e == null) {
                ShowTaskListSettingAction.$$$reportNull$$$0(2);
            }
            if ((structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure()) != null) {
                JsbtTaskTreeView.this.myService.showTaskListingSettingsDialog(structure.getBuildfile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ShowTaskListSettingAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ShowTaskListSettingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class JumpToSourceAction
    extends AnAction
    implements DumbAware {
        private JumpToSourceAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"EditSource");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                JumpToSourceAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                JumpToSourceAction.$$$reportNull$$$0(1);
            }
            List<DefaultMutableTreeNode> nodes = JsbtTaskTreeView.this.getSelectedNodes();
            boolean enabled = false;
            if (nodes.size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    e.getPresentation().setText(JavaScriptBundle.messagePointer("action.show.error.details.text", new Object[0]));
                    enabled = true;
                } else {
                    Navigatable descriptor = this.createDescriptor(node);
                    if (descriptor != null) {
                        enabled = true;
                    }
                }
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(enabled);
        }

        @Nullable
        private Navigatable createDescriptor(@NotNull DefaultMutableTreeNode node) {
            JsbtFileStructure structure;
            if (node == null) {
                JumpToSourceAction.$$$reportNull$$$0(2);
            }
            if ((structure = JsbtTree.getUserObject(node, JsbtFileStructure.class)) != null) {
                VirtualFile buildfile = structure.getBuildfile();
                return buildfile.isValid() ? PsiNavigationSupport.getInstance().createNavigatable(JsbtTaskTreeView.this.myProject, buildfile, -1) : null;
            }
            return JsbtTaskTreeView.this.createJumpToSourceDescriptor(JsbtTaskTreeView.this.myProject, node);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DefaultMutableTreeNode> nodes;
            if (e == null) {
                JumpToSourceAction.$$$reportNull$$$0(3);
            }
            if ((nodes = JsbtTaskTreeView.this.getSelectedNodes()).size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    JsbtTaskTreeView.this.showError(JsbtTaskTreeView.this.myProject, errorInfo.getException());
                } else {
                    Navigatable descriptor = this.createDescriptor(node);
                    if (descriptor != null) {
                        descriptor.navigate(true);
                        JsbtTaskTreeView.this.fireAction();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ReloadTasks
    extends AnAction
    implements DumbAware {
        private ReloadTasks() {
            super(JsbtTaskTreeView.this.myService.getApplicationService().getReloadTasksActionName(), null, AllIcons.Actions.Refresh);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ReloadTasks.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadTasks.$$$reportNull$$$0(1);
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            e.getPresentation().setEnabledAndVisible(structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode node;
            List<DefaultMutableTreeNode> nodes;
            if (e == null) {
                ReloadTasks.$$$reportNull$$$0(2);
            }
            if ((nodes = JsbtTaskTreeView.this.getSelectedNodes()).size() == 1 && (node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes)) != null) {
                JsbtTaskTreeView.this.reloadTasksFor(node, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ReloadTasks";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ReloadTasks";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class StructureFetchErrorInfo
    implements TreeCellHyperlink {
        private final Project myProject;
        private final JsbtTaskFetchException myException;
        private final JsbtTaskTreeView myTreeView;
        private Rectangle myHyperlinkBounds;

        public StructureFetchErrorInfo(@NotNull Project project, @NotNull JsbtTaskFetchException e, @NotNull JsbtTaskTreeView treeView) {
            if (project == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(0);
            }
            if (e == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(1);
            }
            if (treeView == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myException = e;
            this.myTreeView = treeView;
        }

        @NotNull
        public JsbtTaskFetchException getException() {
            JsbtTaskFetchException jsbtTaskFetchException = this.myException;
            if (jsbtTaskFetchException == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(3);
            }
            return jsbtTaskFetchException;
        }

        @Override
        @NotNull
        public Runnable getClickHandler() {
            Runnable runnable = () -> this.myTreeView.showError(this.myProject, this.myException);
            if (runnable == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(4);
            }
            return runnable;
        }

        @Override
        @Nullable
        public Rectangle getHyperlinkBounds() {
            return this.myHyperlinkBounds;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return JavaScriptBundle.message("buildTools.tooltip.click.to.show.error.details", new Object[0]);
        }

        public void setHyperlinkBounds(Rectangle hyperlinkBounds) {
            this.myHyperlinkBounds = hyperlinkBounds;
        }

        @Nullable
        public static StructureFetchErrorInfo getUserObject(@Nullable DefaultMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            return (StructureFetchErrorInfo)ObjectUtils.tryCast((Object)node.getUserObject(), StructureFetchErrorInfo.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeView";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClickHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private abstract class ExecuteAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecuteAction(Executor executor) {
            if (executor == null) {
                ExecuteAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), null, executor.getIcon());
            this.myExecutor = executor;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ExecuteAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteAction.$$$reportNull$$$0(2);
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText(this.myExecutor.getStartActionText(taskSet.getName()));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtTaskSet taskSet;
            if (e == null) {
                ExecuteAction.$$$reportNull$$$0(3);
            }
            if ((taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).execute(this.myExecutor);
                JsbtTaskTreeView.this.fireAction();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ExecuteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ExecuteAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

