/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.navigation;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL_ID__TEST_SUITE = "suite";
    public static final String PROTOCOL_ID__TEST = "test";
    private final boolean myLocationUrlStartsWithTestFilePath;

    public JSTestLocationProvider() {
        this(false);
    }

    public JSTestLocationProvider(boolean locationUrlStartsWithTestFilePath) {
        this.myLocationUrlStartsWithTestFilePath = locationUrlStartsWithTestFilePath;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path2, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (protocol == null) {
            JSTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            JSTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            JSTestLocationProvider.$$$reportNull$$$0(3);
        }
        if ("file".equals(protocol)) {
            List list2 = FileUrlProvider.INSTANCE.getLocation(protocol, path2, project, scope2);
            if (list2 == null) {
                JSTestLocationProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        Location<?> location = PROTOCOL_ID__TEST_SUITE.equals(protocol) || PROTOCOL_ID__TEST.equals(protocol) ? this.getTestLocation(project, path2, PROTOCOL_ID__TEST_SUITE.equals(protocol)) : null;
        if (location != null) {
            List<Location> list3 = Collections.singletonList(location);
            if (list3 == null) {
                JSTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<Location> list4 = Collections.emptyList();
        if (list4 == null) {
            JSTestLocationProvider.$$$reportNull$$$0(6);
        }
        return list4;
    }

    @Nullable
    private Location<?> getTestLocation(@NotNull Project project, @NotNull String locationData, boolean suite) {
        List<String> path2;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(7);
        }
        if (locationData == null) {
            JSTestLocationProvider.$$$reportNull$$$0(8);
        }
        if ((path2 = EscapeUtils.split(locationData, '.')).isEmpty()) {
            return null;
        }
        String testFilePath = null;
        List<String> names = path2;
        if (this.myLocationUrlStartsWithTestFilePath) {
            testFilePath = (String)ContainerUtil.getFirstItem(path2);
            names = path2.subList(1, path2.size());
        }
        if (names.isEmpty()) {
            return null;
        }
        PsiElement element = this.findFqnElement(project, new JsTestFqn(JSTestFileType.JASMINE, names, suite), testFilePath);
        if (element == null) {
            element = this.findFqnElement(project, new JsTestFqn(JSTestFileType.QUNIT, names, suite), testFilePath);
        }
        if (element == null) {
            element = this.findFqnElement(project, new JsTestFqn(JSTestFileType.TDD, names, suite), testFilePath);
        }
        if (element == null) {
            element = this.findFqnElement(project, new JsTestFqn(JSTestFileType.NODE_JS_TEST_RUNNER, names, suite), testFilePath);
        }
        return element != null ? PsiLocation.fromPsiElement((PsiElement)element) : null;
    }

    public boolean isLocationUrlStartedWithTestFilePath() {
        return this.myLocationUrlStartsWithTestFilePath;
    }

    @Nullable
    private PsiElement findFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @Nullable String preferredTestFilePath) {
        PsiElement result2;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (testFqn == null) {
            JSTestLocationProvider.$$$reportNull$$$0(10);
        }
        GlobalSearchScope scope2 = GlobalSearchScope.projectScope((Project)project);
        VirtualFile testFile = null;
        if (StringUtil.isNotEmpty((String)preferredTestFilePath)) {
            List files2 = TestsLocationProviderUtil.findSuitableFilesFor((String)preferredTestFilePath, (Project)project);
            testFile = (VirtualFile)ContainerUtil.getFirstItem((List)files2);
        }
        if (testFile != null && (result2 = JSTestLocationProvider.doFindFqnElement(project, testFqn, Collections.singletonList(testFile))) != null) {
            return result2;
        }
        if (this.myLocationUrlStartsWithTestFilePath) {
            return null;
        }
        List<VirtualFile> testFiles = JsTestFileByTestNameIndex.findFiles(testFqn, scope2, testFile);
        return JSTestLocationProvider.doFindFqnElement(project, testFqn, testFiles);
    }

    @Nullable
    private static PsiElement doFindFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @NotNull List<VirtualFile> testFiles) {
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (testFqn == null) {
            JSTestLocationProvider.$$$reportNull$$$0(12);
        }
        if (testFiles == null) {
            JSTestLocationProvider.$$$reportNull$$$0(13);
        }
        for (VirtualFile file : testFiles) {
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile2 instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile2;
            Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> structureBuilders = JsTestFileIndexingHandler.getFileStructureBuildersForFile(jsFile);
            for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> structureBuilder : structureBuilders) {
                AbstractTestFileStructure structure;
                PsiElement element;
                if (testFqn.getType() != structureBuilder.getJsTestFileType() || (element = (structure = structureBuilder.fetchCachedTestFileStructure(jsFile)).findPsiElement(testFqn)) == null || !element.isValid()) continue;
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqn";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFqnElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doFindFqnElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

