/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.nodejs.testRunner.NodeJsTestFileStructure;
import com.intellij.javascript.testFramework.nodejs.testRunner.NodeJsTestFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.impl.JsTestFileInfo;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileIndexingHandler
extends FrameworkIndexingHandler {
    @Override
    public void processFile(@NotNull JSFile psiFile2, @NotNull JSFileCachedData data) {
        VirtualFile file;
        if (psiFile2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(0);
        }
        if (data == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(1);
        }
        if ((file = JsTestFileIndexingHandler.getOriginalFile(psiFile2)) != null && JsTestFileIndexingHandler.isEligibleTestFile(file)) {
            JSTestFileType testFileType = JsTestFileIndexingHandler.getTestFileType(psiFile2);
            data.setTestFileType(testFileType);
        }
    }

    @Nullable
    private static VirtualFile getOriginalFile(@NotNull JSFile psiFile2) {
        VirtualFile virtualFile;
        VirtualFile file;
        if (psiFile2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(2);
        }
        if ((file = psiFile2.getViewProvider().getVirtualFile()) instanceof LightVirtualFile) {
            LightVirtualFile lightVirtualFile = (LightVirtualFile)file;
            virtualFile = lightVirtualFile.getOriginalFile();
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    static boolean isEligibleTestFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(3);
        }
        if (!JsTestFileIndexingHandler.isEligibleTestFileFast(file)) {
            return false;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L) && !JsTestFileInfo.Companion.isTestFileName(file.getName())) {
            return false;
        }
        return !JSLibraryUtil.isProbableLibraryFile(file) && !TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isEligibleTestFileFast(@NotNull VirtualFile file) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(4);
        }
        return file.isValid() && !file.isDirectory() && file.isInLocalFileSystem();
    }

    @Nullable
    private static JSTestFileType getTestFileType(@NotNull JSFile psiFile2) {
        NodeJsTestFileStructure nodeJsTestRunner;
        if (psiFile2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(5);
        }
        if (!(nodeJsTestRunner = (NodeJsTestFileStructure)NodeJsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile2)).isEmpty()) {
            return JSTestFileType.NODE_JS_TEST_RUNNER;
        }
        JasmineFileStructure jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile2);
        if (!jasmine.isEmpty()) {
            return JSTestFileType.JASMINE;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile2);
        if (!qunit.isEmpty()) {
            return JSTestFileType.QUNIT;
        }
        MochaTddFileStructure tdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile2);
        if (!tdd.isEmpty()) {
            return JSTestFileType.TDD;
        }
        return null;
    }

    public static boolean isTestFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(7);
        }
        if (!JsTestFileIndexingHandler.isEligibleTestFileFast(file)) {
            return false;
        }
        PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file));
        if (psiFile2 instanceof JSFile) {
            JSFile jsFile = (JSFile)psiFile2;
            return jsFile.isTestFile();
        }
        return false;
    }

    @Override
    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        VirtualFile vFile;
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(8);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(9);
        }
        if ((vFile = JsTestFileIndexingHandler.getOriginalFile(file)) != null && JsTestFileIndexingHandler.isEligibleTestFile(vFile)) {
            for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> builder2 : JsTestFileIndexingHandler.getFileStructureBuildersForFile(file)) {
                JsTestFileIndexingHandler.putTestFileStructure(file, indexBuilder, builder2);
            }
        }
    }

    public static Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> getFileStructureBuildersForFile(JSFile file) {
        if (file.getTestFileType() == JSTestFileType.NODE_JS_TEST_RUNNER) {
            return List.of(NodeJsTestFileStructureBuilder.getInstance());
        }
        return Arrays.asList(JasmineFileStructureBuilder.getInstance(), QUnitFileStructureBuilder.getInstance(), MochaTddFileStructureBuilder.getInstance());
    }

    private static <T extends AbstractTestFileStructure> void putTestFileStructure(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder, @NotNull AbstractTestFileStructureBuilder<T> builder2) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(10);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(11);
        }
        if (builder2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(12);
        }
        T testStructure = builder2.buildTestFileStructure(file);
        indexBuilder.putAdditionalData(builder2.KEY, testStructure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEligibleTestFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEligibleTestFileFast";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestFileType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "putTestFileStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

