/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.javascript.protractor.ProtractorConsoleProperties;
import com.intellij.javascript.testing.JsTestConsoleProperties;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProtractorOutputToGeneralTestEventsConverter
extends JsTestConsoleProperties.JSTestEventsConverter {
    private boolean myPostponedChunksEnabled;
    private final List<TextChunk> myPostponedChunks;

    public ProtractorOutputToGeneralTestEventsConverter(@NotNull ProtractorConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        super(consoleProperties);
        this.myPostponedChunksEnabled = true;
        this.myPostponedChunks = new ArrayList<TextChunk>();
    }

    @Deprecated(forRemoval=true)
    public ProtractorOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean stdinEnabled) {
        if (testFrameworkName == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        super(testFrameworkName, stdinEnabled);
        this.myPostponedChunksEnabled = true;
        this.myPostponedChunks = new ArrayList<TextChunk>();
    }

    protected void processConsistentText(@NotNull String text2, @NotNull Key<?> outputType) {
        if (text2 == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (ProcessOutputType.isStdout(outputType)) {
            this.processStdoutConsistentText(text2, outputType);
        } else {
            super.processConsistentText(text2, outputType);
        }
    }

    private void printAndDisablePostponedChunks() {
        if (this.myPostponedChunksEnabled) {
            for (TextChunk chunk : this.myPostponedChunks) {
                if (chunk == null) continue;
                super.processConsistentText(chunk.myText, chunk.myOutputType);
            }
            this.myPostponedChunks.clear();
            this.myPostponedChunksEnabled = false;
        }
    }

    private void discardAndDisablePostponedChunks() {
        this.myPostponedChunks.clear();
        this.myPostponedChunksEnabled = false;
    }

    private void resetPostponedChunks() {
        this.myPostponedChunks.clear();
        this.myPostponedChunksEnabled = true;
    }

    private void processStdoutConsistentText(String text2, Key<?> outputType) {
        int logPrefixLength = -1;
        if (this.myPostponedChunksEnabled) {
            if (this.myPostponedChunks.size() == 0) {
                logPrefixLength = ProtractorOutputToGeneralTestEventsConverter.getProtractorLogPrefixLength(text2);
                if (logPrefixLength == text2.length()) {
                    this.myPostponedChunks.add(new TextChunk(text2, outputType));
                } else if (logPrefixLength == 0 && ProtractorOutputToGeneralTestEventsConverter.isTestStatusCharacter(text2)) {
                    this.myPostponedChunks.add(null);
                    this.myPostponedChunks.add(new TextChunk(text2, outputType));
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else if (this.myPostponedChunks.size() == 1) {
                if (ProtractorOutputToGeneralTestEventsConverter.isTestStatusCharacter(text2)) {
                    this.myPostponedChunks.add(new TextChunk(text2, outputType));
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else if (this.myPostponedChunks.size() == 2) {
                if (text2.startsWith("##teamcity[")) {
                    this.discardAndDisablePostponedChunks();
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else {
                this.printAndDisablePostponedChunks();
            }
        }
        if (!this.myPostponedChunksEnabled) {
            int ind = text2.indexOf("##teamcity[");
            if (ind > 0) {
                if (ind != logPrefixLength) {
                    super.processConsistentText(text2.substring(0, ind), outputType);
                }
                super.processConsistentText(text2.substring(ind), outputType);
            } else {
                super.processConsistentText(text2, outputType);
            }
        }
        if (StringUtil.getLineSeparatorAt((CharSequence)text2, (int)(text2.length() - 1)) != null) {
            this.printAndDisablePostponedChunks();
            this.resetPostponedChunks();
        }
    }

    private static boolean isTestStatusCharacter(@NotNull String text2) {
        if (text2 == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        return text2.length() == 1 && ".F".contains(text2);
    }

    private static int getProtractorLogPrefixLength(@NotNull String line) {
        int len;
        if (line == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        if ((len = line.length()) == 0) {
            return 0;
        }
        if (line.charAt(0) != '[') {
            return 0;
        }
        int endInd = StringUtil.indexOf((CharSequence)line, (CharSequence)"] ");
        while (endInd > 0) {
            if (ProtractorOutputToGeneralTestEventsConverter.endsWithDefaultTaskId(line, endInd)) {
                return endInd + 2;
            }
            endInd = StringUtil.indexOf((CharSequence)line, (CharSequence)"] ", (int)(endInd + 1));
        }
        return 0;
    }

    private static boolean endsWithDefaultTaskId(@NotNull String line, int endInd) {
        int startInd;
        if (line == null) {
            ProtractorOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        if ((startInd = line.lastIndexOf(" #", endInd)) == -1) {
            return false;
        }
        for (int i = startInd + 2; i < endInd; ++i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processConsistentText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestStatusCharacter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProtractorLogPrefixLength";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "endsWithDefaultTaskId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TextChunk {
        private final String myText;
        private final Key<?> myOutputType;

        TextChunk(String text2, Key<?> outputType) {
            this.myText = text2;
            this.myOutputType = outputType;
        }
    }
}

