/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packages;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfo {
    private final String myPackageName;
    @Nls
    private final String myDescription;
    private final ImmutableList<String> myVersions;
    private final String myLatestVersion;
    private final String myAuthor;
    private final String myRepositoryUrl;

    public NodePackageInfo(@NotNull String packageName, @NotNull @Nls String description, @NotNull List<String> versions2, @Nullable String latestVersion, @Nullable String author, @Nullable String repositoryUrl) {
        if (packageName == null) {
            NodePackageInfo.$$$reportNull$$$0(0);
        }
        if (description == null) {
            NodePackageInfo.$$$reportNull$$$0(1);
        }
        if (versions2 == null) {
            NodePackageInfo.$$$reportNull$$$0(2);
        }
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myVersions = ImmutableList.copyOf(versions2);
        this.myLatestVersion = latestVersion;
        this.myAuthor = author;
        this.myRepositoryUrl = repositoryUrl;
    }

    @NotNull
    public ImmutableList<String> getVersions() {
        ImmutableList<String> immutableList = this.myVersions;
        if (immutableList == null) {
            NodePackageInfo.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    @Nls
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            NodePackageInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getLatestVersion() {
        return this.myLatestVersion;
    }

    @NotNull
    @Nls
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        NodePackageInfo.addSection(buf, null, this.myDescription, false);
        NodePackageInfo.addSection(buf, "Version", this.myLatestVersion, false);
        NodePackageInfo.addSection(buf, "Author", this.myAuthor, false);
        NodePackageInfo.addSection(buf, "Repository", this.myRepositoryUrl, true);
        NodePackageInfo.addSection(buf, "More details", "https://npmjs.org/package/" + this.myPackageName, true);
        return NodePackageInfo.createHtml(buf.toString());
    }

    @NotNull
    @Nls
    public static String createHtml(@NotNull String innerBodyHtml) {
        if (innerBodyHtml == null) {
            NodePackageInfo.$$$reportNull$$$0(5);
        }
        Font font = StartupUiUtil.getLabelFont();
        String string = "<html><head>" + UIUtil.getCssFontDeclaration((Font)font, null, null, null) + "<style>h4 {font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;}</style></head><body>" + innerBodyHtml + "</body></html>";
        if (string == null) {
            NodePackageInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void addSection(@NotNull StringBuilder buf, @Nullable String title, @Nullable String data, boolean url) {
        if (buf == null) {
            NodePackageInfo.$$$reportNull$$$0(7);
        }
        if (data != null) {
            if (title != null) {
                buf.append("<h4>").append(StringUtil.escapeXmlEntities((String)title)).append("</h4>");
            }
            if (url) {
                buf.append("<a href=\"").append(data).append("\">").append(StringUtil.escapeXmlEntities((String)data)).append("</a>");
            } else {
                buf.append(StringUtil.escapeXmlEntities((String)data));
            }
            buf.append("<br/>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packages/NodePackageInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerBodyHtml";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packages/NodePackageInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

