/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmsIoService {
    private NpmsIoService() {
    }

    @Nullable
    public static NpmRegistryService.SearchQuery createSearchQuery(final @NotNull String text2, boolean preferSuggestions) {
        Pair<String, String> scopeAndName;
        if (text2 == null) {
            NpmsIoService.$$$reportNull$$$0(0);
        }
        if ((scopeAndName = NpmsIoService.parseScopeAndName(text2)) == null) {
            return null;
        }
        final String pkgScope = (String)scopeAndName.first;
        final String pkgName = (String)scopeAndName.second;
        final boolean suggestions = preferSuggestions && pkgScope == null;
        return new NpmRegistryService.SearchQuery(text2){

            @Override
            @NotNull
            public String getQueryUrl(int from, int limit) {
                if (suggestions) {
                    String string = "https://api.npms.io/v2/search/suggestions?q=" + URLUtil.encodeURIComponent((String)text2) + "&size=" + (from + limit);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String query2 = pkgScope != null ? ("scope:" + pkgScope + " " + pkgName).stripTrailing() : pkgName;
                String string = "https://api.npms.io/v2/search?q=" + URLUtil.encodeURIComponent((String)query2) + "&from=" + from + "&size=" + limit;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public int getMaxQueryBatchSize() {
                return 100;
            }

            @Override
            @NotNull
            public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
                if (content == null) {
                    1.$$$reportNull$$$0(2);
                }
                JsonReader reader2 = new JsonReader((Reader)new StringReader(content));
                List<NodePackageBasicInfo> list2 = new SearchResultsReader(reader2, suggestions).read();
                List<NodePackageBasicInfo> list3 = list2;
                if (list3 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list3;
                finally {
                    reader2.close();
                }
            }

            public String toString() {
                return "'" + text2 + "*' (powered by npms.io)";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQueryUrl";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "parseContent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Nullable
    private static Pair<String, String> parseScopeAndName(@NotNull String text2) {
        int slashInd;
        if (text2 == null) {
            NpmsIoService.$$$reportNull$$$0(1);
        }
        if (text2.startsWith("@") && (slashInd = text2.indexOf(47, 1)) != -1) {
            String scope2 = text2.substring(1, slashInd);
            String name = text2.substring(Math.min(slashInd + 1, text2.length()));
            if (name.isEmpty() || name.length() >= 4) {
                return Pair.create((Object)scope2, (Object)name);
            }
            return null;
        }
        return Pair.create(null, (Object)text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "text";
        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSearchQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseScopeAndName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SearchResultsReader {
        private final JsonReader myReader;
        private final boolean mySuggestions;
        private final List<NodePackageBasicInfo> myResults;

        SearchResultsReader(@NotNull JsonReader reader2, boolean suggestions) {
            if (reader2 == null) {
                SearchResultsReader.$$$reportNull$$$0(0);
            }
            this.myResults = new ArrayList<NodePackageBasicInfo>();
            this.myReader = reader2;
            this.mySuggestions = suggestions;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (!this.mySuggestions) {
                if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                    this.myReader.skipValue();
                    List<NodePackageBasicInfo> list2 = Collections.emptyList();
                    if (list2 == null) {
                        SearchResultsReader.$$$reportNull$$$0(1);
                    }
                    return list2;
                }
                this.myReader.beginObject();
                while (this.myReader.hasNext()) {
                    String name = this.myReader.nextName();
                    if ("results".equals(name)) {
                        this.readSearchResults();
                        continue;
                    }
                    this.myReader.skipValue();
                }
                this.myReader.endObject();
            } else {
                this.readSearchResults();
            }
            ImmutableList immutableList = ImmutableList.copyOf(this.myResults);
            if (immutableList == null) {
                SearchResultsReader.$$$reportNull$$$0(2);
            }
            return immutableList;
        }

        private void readSearchResults() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readPackageProp();
            }
            this.myReader.endArray();
        }

        private void readPackageProp() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String propName = this.myReader.nextName();
                if ("package".equals(propName)) {
                    ContainerUtil.addIfNotNull(this.myResults, (Object)NpmRegistryServiceImpl.readPackageInfo(this.myReader));
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$SearchResultsReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$SearchResultsReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

