/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpNodePackage
extends NodePackage {
    private static final Logger LOG = Logger.getInstance(YarnPnpNodePackage.class);
    private static final Key<Boolean> YARN_RUN_ADDED = Key.create((String)"yarn run configured");
    @NonNls
    private static final String YARN_SCHEME = "yarn:";
    private final String myRelativePathToPackageJson;
    private final String myPackageName;

    protected YarnPnpNodePackage(@NotNull String url) {
        if (url == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(0);
        }
        super(url);
        int packageNameDelimiterInd = url.lastIndexOf(58);
        if (packageNameDelimiterInd >= YARN_SCHEME.length()) {
            this.myRelativePathToPackageJson = url.substring(YARN_SCHEME.length(), packageNameDelimiterInd);
            this.myPackageName = url.substring(packageNameDelimiterInd + 1);
        } else {
            this.myRelativePathToPackageJson = url.substring(YARN_SCHEME.length());
            this.myPackageName = "";
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myPackageName;
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isValid(@Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        PackageJsonData data;
        if (project == null) {
            return true;
        }
        VirtualFile packageJson2 = this.getPackageJson(project);
        if (packageJson2 != null && (data = PackageJsonData.getOrCreate(packageJson2)).isDependencyOfAnyType(this.myPackageName)) {
            return YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson2, this.myPackageName) != null;
        }
        return false;
    }

    @Override
    @Nullable
    public SemVer getVersion() {
        return null;
    }

    @Override
    @Nullable
    public SemVer getVersion(@Nullable Project project) {
        VirtualFile dependencyPackageJson;
        VirtualFile dependencyRoot;
        VirtualFile packageJson2;
        VirtualFile virtualFile = packageJson2 = project != null ? this.getPackageJson(project) : null;
        if (packageJson2 != null && PackageJsonData.getOrCreate(packageJson2).isDependencyOfAnyType(this.myPackageName) && (dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson2, this.myPackageName)) != null && (dependencyPackageJson = PackageJsonUtil.findChildPackageJsonFile(dependencyRoot)) != null) {
            return PackageJsonData.getOrCreate(dependencyPackageJson).getVersion();
        }
        return null;
    }

    @Override
    @Nullable
    public String validateAndGetErrorMessage(@NotNull String packageName, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        if (packageName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(2);
        }
        String base = JavaScriptBundle.message("dialog.message.package.yarn.installed.package.format.yarn.relative.path.to.package.json.package.name", packageName);
        if (!this.myRelativePathToPackageJson.endsWith("package.json")) {
            return base + JavaScriptBundle.message("dialog.message.no.path.to.package.json.found", new Object[0]);
        }
        if (this.myPackageName.isEmpty()) {
            return base + JavaScriptBundle.message("dialog.message.unspecified.package.name", new Object[0]);
        }
        return null;
    }

    @Nullable
    public String getPackageJsonPath(@NotNull Project project) {
        VirtualFile projectRoot;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(3);
        }
        if ((projectRoot = ProjectUtil.guessProjectDir((Project)project)) != null) {
            return FileUtil.toSystemIndependentName((String)(projectRoot.getPath() + "/" + this.myRelativePathToPackageJson));
        }
        return null;
    }

    @Nullable
    public VirtualFile getPackageJson(@NotNull Project project) {
        String packageJsonPath;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(4);
        }
        if ((packageJsonPath = this.getPackageJsonPath(project)) != null) {
            return LocalFileSystem.getInstance().findFileByPath(packageJsonPath);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public void addYarnRunToCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @Nullable String binaryName) throws ExecutionException {
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(5);
        }
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(6);
        }
        if (interpreter2 == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(7);
        }
        this.addYarnRunToCommandLine(commandLine, project, interpreter2, binaryName, true);
    }

    private void addYarnRunToCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @Nullable String binaryName, boolean canThrowExceptionWithHtml) throws ExecutionException {
        NodePackage yarnPkg;
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(8);
        }
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(9);
        }
        if (interpreter2 == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(10);
        }
        if ((yarnPkg = NpmManager.getInstance(project).getPackage(interpreter2)) == null) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.cannot_find_project_package_manager.dialog.message", new Object[0]));
        }
        this.requireYarnPackageManager(project, NpmUtil.isYarnAlikePackage(yarnPkg), canThrowExceptionWithHtml);
        NpmNodePackage.configureNpmPackage(commandLine, interpreter2, yarnPkg);
        commandLine.addParameter("run");
        commandLine.addParameter("--binaries-only");
        String resultBinaryName = binaryName != null ? binaryName : this.guessBinaryName(project);
        commandLine.addParameter(resultBinaryName);
        YARN_RUN_ADDED.set((UserDataHolder)commandLine, (Object)Boolean.TRUE);
    }

    public void addYarnRunToCommandLine(@NotNull NodeTargetRun targetRun, @Nullable String binaryName, boolean canThrowExceptionWithHtml) throws ExecutionException {
        NodePackage yarnPkg;
        if (targetRun == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(11);
        }
        if ((yarnPkg = NpmManager.getInstance(targetRun.getProject()).getPackage(targetRun.getInterpreter())) == null) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.cannot_find_project_package_manager.dialog.message", new Object[0]));
        }
        this.requireYarnPackageManager(targetRun.getProject(), NpmUtil.isYarnAlikePackage(yarnPkg), canThrowExceptionWithHtml);
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        NpmNodePackage.configureNpmPackage(targetRun, yarnPkg, new String[0]);
        commandLineBuilder.addParameter("run");
        commandLineBuilder.addParameter("--binaries-only");
        String resultBinaryName = binaryName != null ? binaryName : this.guessBinaryName(targetRun.getProject());
        commandLineBuilder.addParameter(resultBinaryName);
        targetRun.setEnableWrappingWithYarnNode(false);
    }

    @NotNull
    private String guessBinaryName(@NotNull Project project) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(12);
        }
        VirtualFile dependencyPackageJson = null;
        try {
            dependencyPackageJson = this.findDependencyPackageJson(project);
        }
        catch (IOException e) {
            LOG.info("Cannot find dependency package.json: " + e.getMessage());
        }
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(dependencyPackageJson, this.myPackageName);
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private VirtualFile findDependencyPackageJson(@NotNull Project project) throws IOException {
        VirtualFile packageJson2;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(14);
        }
        if ((packageJson2 = this.getPackageJson(project)) == null) {
            throw new IOException("Cannot find package.json declaring " + this);
        }
        VirtualFile dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson2, this.myPackageName);
        if (dependencyRoot == null) {
            throw new IOException("Cannot find dependency root for " + this + " (" + packageJson2 + ")");
        }
        VirtualFile dependencyPackageJson = PackageJsonUtil.findChildPackageJsonFile(dependencyRoot);
        if (dependencyPackageJson == null) {
            throw new IOException("Cannot find package.json in " + dependencyRoot.getPath());
        }
        VirtualFile virtualFile = dependencyPackageJson;
        if (virtualFile == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public void requireYarnPackageManager(@NotNull Project project, boolean yarnPackageManager, boolean htmlSupported) throws ExecutionException {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(16);
        }
        if (!yarnPackageManager) {
            String packageManagerText = JavaScriptBundle.message("node.npm.package_manager_link.text", new Object[0]);
            String suffix = htmlSupported ? HtmlChunk.link((String)"", (String)packageManagerText).toString() : packageManagerText;
            throw new NpmManager.InvalidNpmPackageException(project, JavaScriptBundle.message("yarn.package_requires_yarn.dialog.message", this.getSystemIndependentPath(), suffix), null);
        }
    }

    public static boolean isWithYarnRun(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(17);
        }
        return YARN_RUN_ADDED.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    @Nullable
    private String getDependencyPnpLocation(@NotNull Project project) {
        VirtualFile packageJson2;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(18);
        }
        if ((packageJson2 = this.getPackageJson(project)) == null) {
            return null;
        }
        return YarnPnpManager.getInstance(project).getDependencyRequireableLocation(packageJson2, this.myPackageName);
    }

    @Override
    @Nullable
    public String getAbsolutePackagePathToRequire(@NotNull Project project) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(19);
        }
        return this.getDependencyPnpLocation(project);
    }

    @Nullable
    public static YarnPnpNodePackage createFromText(@NotNull String text2) {
        if (text2 == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(20);
        }
        if (text2.startsWith(YARN_SCHEME)) {
            return new YarnPnpNodePackage(text2);
        }
        return null;
    }

    @Nullable
    public static YarnPnpNodePackage create(@NotNull Project project, @NotNull VirtualFile packageJson2, @NotNull String dependencyName, boolean checkIfUnderPnp, boolean checkIfDependencyIsDeclared) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(21);
        }
        if (packageJson2 == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(22);
        }
        if (dependencyName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(23);
        }
        if (!PackageJsonUtil.isPackageJsonFile(packageJson2)) {
            return null;
        }
        if (checkIfUnderPnp && !YarnPnpManager.getInstance(project).isUnderPnp(packageJson2)) {
            return null;
        }
        if (checkIfDependencyIsDeclared && !PackageJsonData.getOrCreate(packageJson2).isDependencyOfAnyType(dependencyName)) {
            return null;
        }
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (projectRoot == null) {
            return null;
        }
        String relativePathToPackageJson = VfsUtilCore.findRelativePath((VirtualFile)projectRoot, (VirtualFile)packageJson2, (char)'/');
        if (relativePathToPackageJson == null) {
            return null;
        }
        return new YarnPnpNodePackage(YarnPnpNodePackage.constructUrl(relativePathToPackageJson, dependencyName));
    }

    @NotNull
    private static String constructUrl(@NotNull String relativePathToPackageJson, @NotNull String packageName) {
        if (relativePathToPackageJson == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(25);
        }
        String string = YARN_SCHEME + relativePathToPackageJson + ":" + packageName;
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 13, 15, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpNodePackage";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToPackageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpNodePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBinaryName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencyPackageJson";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "constructUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateAndGetErrorMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJson";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addYarnRunToCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "guessBinaryName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyPackageJson";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requireYarnPackageManager";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isWithYarnRun";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyPnpLocation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePackagePathToRequire";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "constructUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 13, 15, 26 -> new IllegalStateException(string);
        };
    }
}

