/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NodeJsCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "nodejs";
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        String string = JavaScriptBundle.message("js.commandline.configure.nodejs", new Object[0]);
        if (string == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        List<NodeJsDownloadableInterpreter> interpreters;
        if (context2 == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (!(interpreters = NodeDownloadableInterpreterType.getInstance().getInterpretersIfActive()).isEmpty()) {
            NodeJsDownloadService.Handler.install(interpreters.get(0), null);
        }
    }

    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        if (project == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        final CommandLineInspectionProgressReporter logger = context2.getLogger();
        Set<VirtualFile> packageJsons = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
        context2.getLogger().reportMessage(1, "Detected " + packageJsons.size() + " package.json files under the project to install dependencies");
        double i = 0.0;
        ProgressIndicator indicator = context2.getProgressIndicator();
        indicator.setIndeterminate(false);
        for (VirtualFile packageJson2 : packageJsons) {
            double d = i;
            i = d + 1.0;
            indicator.setFraction(d / (double)packageJsons.size());
            if (context2.getVirtualFilesFilter().test(packageJson2)) {
                logger.reportMessage(2, "File " + packageJson2 + " is skipped");
                continue;
            }
            try {
                NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreterRef().resolveNotNull(project);
                NodePackageRef npmPkgRef = NpmManager.getInstance(project).getPackageRef();
                NodeTargetRun targetRun = new NodeTargetRun(interpreter2, project, null, NodeTargetRunOptions.of(false));
                NpmRunProfileState.configureCommandLine(targetRun, "", npmPkgRef, packageJson2.getPath(), NpmCommand.INSTALL, List.of(), "", EnvironmentVariablesData.DEFAULT, null);
                KillableProcessHandler processHandler = targetRun.startProcessEx().getProcessHandler();
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        logger.reportMessage(3, event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                processHandler.startNotify();
                processHandler.waitFor();
                packageJson2.getParent().refresh(false, true);
            }
            catch (ExecutionException e) {
                logger.reportMessage(1, "Error while running npm install: " + e.getMessage());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

