/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.express;

import com.intellij.javascript.microservices.express.ExpressMapping;
import com.intellij.javascript.microservices.express.ExpressModel;
import com.intellij.javascript.microservices.express.ExpressUrlTargetInfo;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.JavaScriptLanguageIcons;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/microservices/express/ExpressEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/javascript/microservices/express/ExpressMapping;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "group", "endpoint", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "intellij.javascript.langInjection"})
public final class ExpressEndpointsProvider
implements EndpointsUrlTargetProvider<PsiFile, ExpressMapping> {
    @NotNull
    private final EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Express", "Express", JavaScriptLanguageIcons.Nodejs.Express);

    @NotNull
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExpressModel.INSTANCE.hasExpressJs$intellij_javascript_langInjection(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<PsiFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!ExpressModel.INSTANCE.hasExpressJs$intellij_javascript_langInjection(project)) {
            return CollectionsKt.emptyList();
        }
        return ExpressModel.INSTANCE.getEndpointGroups$intellij_javascript_langInjection(project, ((SearchScopeEndpointsFilter)filter).getTransitiveSearchScope());
    }

    @NotNull
    public Iterable<ExpressMapping> getEndpoints(@NotNull PsiFile group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Project project = group.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ExpressModel.INSTANCE.getEndpoints$intellij_javascript_langInjection(project, group);
    }

    public boolean isValidEndpoint(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)endpoint.getPointer().getElement();
        return jSLiteralExpression != null ? jSLiteralExpression.isValid() : false;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getFullPath(), CollectionsKt.toList((Iterable)endpoint.getMethods()), endpoint.getSource(), JavaScriptLanguageIcons.Nodejs.Express, null, 16, null);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)JavascriptLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getPointer().getElement();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)endpoint.getPointer().getElement();
        if (jSLiteralExpression == null) {
            return CollectionsKt.emptyList();
        }
        JSLiteralExpression endpointElement = jSLiteralExpression;
        return CollectionsKt.listOf((Object)new ExpressUrlTargetInfo(UrlConstants.HTTP_SCHEMES, CollectionsKt.listOf((Object)new Authority.Exact("localhost:3000")), endpoint.getPath(), endpoint.getMethods(), (PsiElement)endpointElement));
    }
}

