/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.javascript.microservices.JavaScriptHttpBodyCompletionContributor;
import com.intellij.javascript.microservices.JsRequestBodyDetectionKt;
import com.intellij.javascript.microservices.RequestBodyDeclaration;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/microservices/JavaScriptHttpBodyCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getSchemas", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.langInjection"})
public final class JavaScriptHttpBodyCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        Sequence rootSchemas2 = SequencesKt.mapNotNull(this.getSchemas(position), (Function1)((Function1)new Function1<VirtualFile, JsonSchemaObject>(position){
            final /* synthetic */ PsiElement $position;
            {
                this.$position = $position;
                super(1);
            }

            @Nullable
            public final JsonSchemaObject invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JsonCachedValues.getSchemaObject((VirtualFile)it, (Project)this.$position.getProject());
            }
        }));
        boolean stop = JSJsonLikePsiWalker.INSTANCE_ARRAY_ALLOWED.isName(position) == ThreeState.YES;
        for (JsonSchemaObject rootSchema : rootSchemas2) {
            Intrinsics.checkNotNull((Object)rootSchema);
            JsonSchemaCompletionContributor.Companion.doCompletion(parameters, result2, rootSchema, stop);
        }
    }

    private final Sequence<VirtualFile> getSchemas(PsiElement psiElement) {
        Sequence<RequestBodyDeclaration> bodyDeclarations = JsRequestBodyDetectionKt.findBodyDeclarations(psiElement);
        return SequencesKt.flatMap(bodyDeclarations, (Function1)getSchemas.1.INSTANCE);
    }
}

