/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project.v2;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.util.Disposer;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.v2.ModuleConnectionType;
import com.intellij.uml.java.project.v2.ModuleEdge;
import com.intellij.uml.java.project.v2.ModuleGraphModel;
import com.intellij.uml.java.project.v2.ModuleGraphModelKt;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.Chunk;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.EndpointPair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphFactory;
import com.intellij.util.graph.MutableNetwork;
import com.intellij.util.graph.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u00014B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\"\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\rJ\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f02J\f\u00103\u001a\u00020\u001d*\u00020\u001dH\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR<\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lcom/intellij/uml/java/project/v2/ModuleGraphModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "seedModule", "Lcom/intellij/uml/java/project/ModuleItem;", "myConfContext", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "contentSettings", "Lcom/intellij/uml/java/project/v2/ModuleGraphModel$Settings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/uml/java/project/ModuleItem;Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;Lcom/intellij/uml/java/project/v2/ModuleGraphModel$Settings;)V", "_graph", "Lcom/intellij/util/graph/Network;", "Lcom/intellij/uml/java/project/v2/ModuleEdge;", "getContentSettings", "()Lcom/intellij/uml/java/project/v2/ModuleGraphModel$Settings;", "value", "graph", "getGraph", "()Lcom/intellij/util/graph/Network;", "setGraph", "(Lcom/intellij/util/graph/Network;)V", "myLibraryTableListener", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSeedModule", "()Lcom/intellij/uml/java/project/ModuleItem;", "dependentModulesEnumerator", "Lcom/intellij/openapi/roots/OrderEnumerator;", "Lcom/intellij/openapi/module/Module;", "getDependentModulesEnumerator", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/OrderEnumerator;", "dispose", "", "findOrderEntry", "Lcom/intellij/openapi/roots/ExportableOrderEntry;", "source", "target", "getDependentModulesAndLibs", "", "getItemsToShow", "", "inferDependenciesGraphOf", "moduleItems", "", "isTestDependency", "", "edge", "recomputeGraph", "Ljava/util/concurrent/CompletionStage;", "includeTestsIfNeeded", "Settings", "intellij.diagram.java"})
@SourceDebugExtension(value={"SMAP\nModuleGraphModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleGraphModel.kt\ncom/intellij/uml/java/project/v2/ModuleGraphModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,218:1\n1#2:219\n857#3,2:220\n1360#3:224\n1446#3,2:225\n1549#3:227\n1620#3,3:228\n1448#3,3:231\n288#3,2:245\n288#3,2:258\n1313#4,2:222\n4098#5,11:234\n4098#5,11:247\n*S KotlinDebug\n*F\n+ 1 ModuleGraphModel.kt\ncom/intellij/uml/java/project/v2/ModuleGraphModel\n*L\n99#1:220,2\n158#1:224\n158#1:225,2\n158#1:227\n158#1:228,3\n158#1:231,3\n183#1:245,2\n184#1:258,2\n143#1:222,2\n183#1:234,11\n184#1:247,11\n*E\n"})
public final class ModuleGraphModel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleItem seedModule;
    @NotNull
    private final StructureConfigurableContext myConfContext;
    @NotNull
    private final Settings contentSettings;
    @NotNull
    private volatile Network<ModuleItem, ModuleEdge> _graph;
    @NotNull
    private final LibraryTable.Listener myLibraryTableListener;

    public ModuleGraphModel(@NotNull Project project, @NotNull ModuleItem seedModule, @NotNull StructureConfigurableContext myConfContext, @NotNull Settings contentSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)seedModule, (String)"seedModule");
        Intrinsics.checkNotNullParameter((Object)myConfContext, (String)"myConfContext");
        Intrinsics.checkNotNullParameter((Object)contentSettings, (String)"contentSettings");
        this.project = project;
        this.seedModule = seedModule;
        this.myConfContext = myConfContext;
        this.contentSettings = contentSettings;
        Network network = GraphFactory.getInstance().emptyNetwork();
        Intrinsics.checkNotNullExpressionValue((Object)network, (String)"emptyNetwork(...)");
        this._graph = network;
        this.myLibraryTableListener = ModuleGraphModelKt.setupLibraryRenameListener(this.project);
    }

    public /* synthetic */ ModuleGraphModel(Project project, ModuleItem moduleItem, StructureConfigurableContext structureConfigurableContext, Settings settings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            settings = new Settings(false, false, 3, null);
        }
        this(project, moduleItem, structureConfigurableContext, settings);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ModuleItem getSeedModule() {
        return this.seedModule;
    }

    @NotNull
    public final Settings getContentSettings() {
        return this.contentSettings;
    }

    @NotNull
    public final Network<ModuleItem, ModuleEdge> getGraph() {
        return this._graph;
    }

    private final void setGraph(Network<ModuleItem, ModuleEdge> value) {
        this._graph = value;
    }

    @NotNull
    public final CompletionStage<Network<ModuleItem, ModuleEdge>> recomputeGraph() {
        String string = DiagramJavaBundle.message("modules.chart.building.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return Futures.runAsyncProgressInBackground$default((Project)this.project, (String)string, (boolean)true, null, null, arg_0 -> ModuleGraphModel.recomputeGraph$lambda$0((Function1)new Function1<ProgressIndicator, CompletableFuture<Network<ModuleItem, ModuleEdge>>>(this){
            final /* synthetic */ ModuleGraphModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Network<ModuleItem, ModuleEdge>> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                return CompletableFuture.supplyAsync(ThreadContext.captureThreadContext(() -> recomputeGraph.1.invoke$lambda$1(this.this$0)));
            }

            /*
             * WARNING - void declaration
             */
            private static final Network invoke$lambda$1(ModuleGraphModel this$0) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Set moduleItems = ModuleGraphModel.access$getItemsToShow(this$0, this$0.getSeedModule());
                Network moduleGraph = ModuleGraphModel.access$inferDependenciesGraphOf(this$0, moduleItems);
                Module[] $this$map$iv = ModuleManager.Companion.getInstance(this$0.getProject()).getModules();
                boolean $i$f$map = false;
                Module[] moduleArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void module;
                    void item$iv$iv;
                    void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ModuleProjectStructureElement(ModuleGraphModel.access$getMyConfContext$p(this$0), (Module)module));
                }
                List updates = (List)destination$iv$iv;
                ModuleGraphModel.access$getMyConfContext$p(this$0).getDaemonAnalyzer().queueUpdates((Collection)updates);
                ModuleGraphModel.access$setGraph(this$0, moduleGraph);
                return moduleGraph;
            }
        }, arg_0), (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ModuleItem> getItemsToShow(ModuleItem seedModule) {
        void var3_3;
        void $this$filterTo$iv;
        Object object = new ModuleItem[]{seedModule};
        object = CollectionsKt.mutableListOf((Object[])object);
        Object[] it = object;
        boolean bl = false;
        if (seedModule.isModule()) {
            it.addAll(this.getDependentModulesAndLibs(seedModule));
        }
        object = (Iterable)object;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            ModuleItem it2 = (ModuleItem)element$iv;
            boolean bl2 = false;
            if (!((this.contentSettings.getDoShowLibraries() || !it2.isLibrary()) && !it2.isDisposed())) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    private final Collection<ModuleItem> getDependentModulesAndLibs(ModuleItem seedModule) {
        Object[] objectArray = new Module[1];
        Intrinsics.checkNotNullExpressionValue((Object)seedModule.getModule(), (String)"getModule(...)");
        Set modules = SetsKt.mutableSetOf((Object[])objectArray);
        List items = new ArrayList();
        Module module = seedModule.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        this.getDependentModulesEnumerator(module).forEachModule(arg_0 -> ModuleGraphModel.getDependentModulesAndLibs$lambda$3((Function1)new Function1<Module, Boolean>((List<ModuleItem>)items, (Set<Module>)modules){
            final /* synthetic */ List<ModuleItem> $items;
            final /* synthetic */ Set<Module> $modules;
            {
                this.$items = $items;
                this.$modules = $modules;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Module module) {
                this.$items.add(new ModuleItem(module));
                Intrinsics.checkNotNull((Object)module);
                this.$modules.add(module);
                return true;
            }
        }, arg_0));
        for (Module module2 : modules) {
            OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)module2).librariesOnly();
            Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"librariesOnly(...)");
            this.includeTestsIfNeeded(orderEnumerator).forEachLibrary(arg_0 -> ModuleGraphModel.getDependentModulesAndLibs$lambda$4((Function1)new Function1<Library, Boolean>((List<ModuleItem>)items, module2, this){
                final /* synthetic */ List<ModuleItem> $items;
                final /* synthetic */ Module $module;
                final /* synthetic */ ModuleGraphModel this$0;
                {
                    this.$items = $items;
                    this.$module = $module;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Library library) {
                    this.$items.add(new ModuleItem(this.$module, library, this.this$0.getProject()));
                    return true;
                }
            }, arg_0));
        }
        return items;
    }

    private final OrderEnumerator getDependentModulesEnumerator(Module $this$dependentModulesEnumerator) {
        OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)$this$dependentModulesEnumerator).withoutSdk().withoutModuleSourceEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"withoutModuleSourceEntries(...)");
        return this.includeTestsIfNeeded(orderEnumerator);
    }

    private final OrderEnumerator includeTestsIfNeeded(OrderEnumerator $this$includeTestsIfNeeded) {
        OrderEnumerator orderEnumerator;
        if (this.contentSettings.getDoShowTestDependencies()) {
            orderEnumerator = $this$includeTestsIfNeeded;
        } else {
            OrderEnumerator orderEnumerator2 = $this$includeTestsIfNeeded.productionOnly();
            orderEnumerator = orderEnumerator2;
            Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator2, (String)"productionOnly(...)");
        }
        return orderEnumerator;
    }

    /*
     * WARNING - void declaration
     */
    private final Network<ModuleItem, ModuleEdge> inferDependenciesGraphOf(Iterable<? extends ModuleItem> moduleItems) {
        void $this$flatMapTo$iv$iv;
        void $this$forEach$iv;
        MutableNetwork network = GraphFactory.getInstance().directedNetwork().allowsParallelEdges(true).allowsSelfLoops(true).build();
        MultiMap moduleEdges = new MultiMap();
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence(moduleItems), (Function1)inferDependenciesGraphOf.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module source = (Module)element$iv;
            boolean bl = false;
            OrderEnumerator enumerator = this.getDependentModulesEnumerator(source);
            enumerator.forEachModule(arg_0 -> ModuleGraphModel.inferDependenciesGraphOf$lambda$7$lambda$5((Function1)new Function1<Module, Boolean>((MultiMap<Module, Module>)moduleEdges, source){
                final /* synthetic */ MultiMap<Module, Module> $moduleEdges;
                final /* synthetic */ Module $source;
                {
                    this.$moduleEdges = $moduleEdges;
                    this.$source = $source;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Module target) {
                    this.$moduleEdges.putValue((Object)this.$source, (Object)target);
                    return true;
                }
            }, arg_0));
            if (!this.contentSettings.getDoShowLibraries()) continue;
            enumerator.forEachLibrary(arg_0 -> ModuleGraphModel.inferDependenciesGraphOf$lambda$7$lambda$6((Function1)new Function1<Library, Boolean>((MutableNetwork<ModuleItem, ModuleEdge>)network, source, this){
                final /* synthetic */ MutableNetwork<ModuleItem, ModuleEdge> $network;
                final /* synthetic */ Module $source;
                final /* synthetic */ ModuleGraphModel this$0;
                {
                    this.$network = $network;
                    this.$source = $source;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Library library) {
                    this.$network.addEdge((Object)new ModuleItem(this.$source), (Object)new ModuleItem(library, this.this$0.getProject()), (Object)new ModuleEdge(ModuleConnectionType.LIB));
                    return true;
                }
            }, arg_0));
        }
        Graph it = ModuleManager.Companion.getInstance(this.project).moduleGraph(this.contentSettings.getDoShowTestDependencies());
        boolean $i$a$-let-ModuleGraphModel$inferDependenciesGraphOf$graph$22 = false;
        Graph graph = GraphAlgorithms.getInstance().computeSCCGraph(it);
        Intrinsics.checkNotNullExpressionValue((Object)graph, (String)"let(...)");
        Graph graph2 = graph;
        Collection collection = graph2.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable $i$a$-let-ModuleGraphModel$inferDependenciesGraphOf$graph$22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            Set set = chunk.getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNodes(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Module module = (Module)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(TuplesKt.to((Object)it2, (Object)chunk));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Map module2Chunk = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        for (Module source : moduleEdges.keySet()) {
            for (Module target : moduleEdges.get((Object)source)) {
                ModuleConnectionType relationship = Intrinsics.areEqual(module2Chunk.get(source), module2Chunk.get(target)) ? ModuleConnectionType.CIRCLE_DEPENDENCY : ModuleConnectionType.MODULE;
                network.addEdge((Object)new ModuleItem(source), (Object)new ModuleItem(target), (Object)new ModuleEdge(relationship));
            }
        }
        Intrinsics.checkNotNull((Object)network);
        return (Network)network;
    }

    public final boolean isTestDependency(@NotNull ModuleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        EndpointPair nodes = this.getGraph().incidentNodes((Object)edge);
        Object object = nodes.source();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source(...)");
        ModuleItem moduleItem = (ModuleItem)object;
        Object object2 = nodes.nodeV();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeV(...)");
        ExportableOrderEntry entry = this.findOrderEntry(moduleItem, (ModuleItem)object2);
        return entry != null && entry.getScope() == DependencyScope.TEST;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportableOrderEntry findOrderEntry(ModuleItem source, ModuleItem target) {
        ExportableOrderEntry exportableOrderEntry;
        ModuleRootManager moduleRootManager;
        OrderEntry[] it;
        OrderEntry[] orderEntryArray = source.getModule();
        if (orderEntryArray != null) {
            it = orderEntryArray;
            boolean bl = false;
            moduleRootManager = ModuleRootManager.getInstance((Module)it);
        } else {
            moduleRootManager = null;
        }
        if (moduleRootManager == null) {
            return null;
        }
        ModuleRootManager rootModel = moduleRootManager;
        OrderEntry[] orderEntryArray2 = rootModel.getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray2, (String)"getOrderEntries(...)");
        OrderEntry[] entries = orderEntryArray2;
        if (target.isModule()) {
            Object v3;
            block11: {
                void $this$firstOrNull$iv;
                Object $this$filterIsInstance$iv = entries;
                boolean $i$f$filterIsInstance = false;
                it = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (OrderEntry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ModuleOrderEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModuleOrderEntry it2 = (ModuleOrderEntry)element$iv;
                    boolean bl = false;
                    if (!(it2.getModule() == target.getModule())) continue;
                    v3 = element$iv;
                    break block11;
                }
                v3 = null;
            }
            exportableOrderEntry = v3;
        } else if (target.isLibrary()) {
            Object v5;
            block12: {
                void $this$firstOrNull$iv;
                Object $this$filterIsInstance$iv = entries;
                boolean $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (OrderEntry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LibraryOrderEntry it3 = (LibraryOrderEntry)element$iv;
                    boolean bl = false;
                    if (!(it3.getLibrary() == target.getLibrary())) continue;
                    v5 = element$iv;
                    break block12;
                }
                v5 = null;
            }
            exportableOrderEntry = v5;
        } else {
            exportableOrderEntry = null;
        }
        return exportableOrderEntry;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.myConfContext));
        this.myConfContext.getModulesConfigurator().disposeUIResources();
        ModuleGraphModelKt.removeLibraryRenameListener(this.project, this.myLibraryTableListener);
    }

    private static final CompletableFuture recomputeGraph$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final boolean getDependentModulesAndLibs$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getDependentModulesAndLibs$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean inferDependenciesGraphOf$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean inferDependenciesGraphOf$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ StructureConfigurableContext access$getMyConfContext$p(ModuleGraphModel $this) {
        return $this.myConfContext;
    }

    public static final /* synthetic */ Set access$getItemsToShow(ModuleGraphModel $this, ModuleItem seedModule) {
        return $this.getItemsToShow(seedModule);
    }

    public static final /* synthetic */ Network access$inferDependenciesGraphOf(ModuleGraphModel $this, Iterable moduleItems) {
        return $this.inferDependenciesGraphOf(moduleItems);
    }

    public static final /* synthetic */ void access$setGraph(ModuleGraphModel $this, Network value) {
        $this.setGraph((Network<ModuleItem, ModuleEdge>)value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/uml/java/project/v2/ModuleGraphModel$Settings;", "", "doShowTestDependencies", "", "doShowLibraries", "(ZZ)V", "getDoShowLibraries", "()Z", "setDoShowLibraries", "(Z)V", "getDoShowTestDependencies", "setDoShowTestDependencies", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.diagram.java"})
    public static final class Settings {
        private boolean doShowTestDependencies;
        private boolean doShowLibraries;

        public Settings(boolean doShowTestDependencies, boolean doShowLibraries) {
            this.doShowTestDependencies = doShowTestDependencies;
            this.doShowLibraries = doShowLibraries;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getDoShowTestDependencies() {
            return this.doShowTestDependencies;
        }

        public final void setDoShowTestDependencies(boolean bl) {
            this.doShowTestDependencies = bl;
        }

        public final boolean getDoShowLibraries() {
            return this.doShowLibraries;
        }

        public final void setDoShowLibraries(boolean bl) {
            this.doShowLibraries = bl;
        }

        public final boolean component1() {
            return this.doShowTestDependencies;
        }

        public final boolean component2() {
            return this.doShowLibraries;
        }

        @NotNull
        public final Settings copy(boolean doShowTestDependencies, boolean doShowLibraries) {
            return new Settings(doShowTestDependencies, doShowLibraries);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.doShowTestDependencies;
            }
            if ((n & 2) != 0) {
                bl2 = settings.doShowLibraries;
            }
            return settings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Settings(doShowTestDependencies=" + this.doShowTestDependencies + ", doShowLibraries=" + this.doShowLibraries + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.doShowTestDependencies);
            result = result * 31 + Boolean.hashCode(this.doShowLibraries);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings = (Settings)other;
            if (this.doShowTestDependencies != settings.doShowTestDependencies) {
                return false;
            }
            return this.doShowLibraries == settings.doShowLibraries;
        }

        public Settings() {
            this(false, false, 3, null);
        }
    }
}

