/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramCategory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.Service;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class JavaUmlCategoryManager
extends AbstractDiagramNodeContentManager {
    @NotNull
    public static final DiagramCategory FIELDS = new DiagramCategory(DiagramBundle.messagePointer("category.name.fields", new Object[0]), AllIcons.Nodes.Field);
    @NotNull
    public static final DiagramCategory CONSTRUCTORS = new DiagramCategory(DiagramBundle.messagePointer("category.name.constructors", new Object[0]), UmlIcons.Constructor);
    @NotNull
    public static final DiagramCategory METHODS = new DiagramCategory(DiagramBundle.messagePointer("category.name.methods", new Object[0]), AllIcons.Nodes.Method);
    @NotNull
    public static final DiagramCategory PROPERTIES = new DiagramCategory(DiagramBundle.messagePointer("category.name.properties", new Object[0]), IconManager.getInstance().getPlatformIcon(PlatformIcons.Property));
    @NotNull
    public static final DiagramCategory INNER_CLASSES = new DiagramCategory(DiagramBundle.messagePointer("category.name.inner.classes", new Object[0]), UmlIcons.Innerclass, false, true);
    private static final DiagramCategory @NotNull [] JAVA_CATEGORIES = new DiagramCategory[]{FIELDS, CONSTRUCTORS, METHODS, PROPERTIES, INNER_CLASSES};
    private static final DiagramCategory @NotNull [] KOTLIN_CATEGORIES = new DiagramCategory[]{PROPERTIES, METHODS, CONSTRUCTORS, INNER_CLASSES};

    @Override
    public DiagramCategory @NotNull [] getContentCategories() {
        JavaUmlDataModel dataModel = this.getDataModel();
        DiagramCategory[] diagramCategoryArray = dataModel != null && dataModel.containsKotlinClassesOnly() ? KOTLIN_CATEGORIES : JAVA_CATEGORIES;
        if (diagramCategoryArray == null) {
            JavaUmlCategoryManager.$$$reportNull$$$0(0);
        }
        return diagramCategoryArray;
    }

    @Nullable
    public JavaUmlDataModel getDataModel() {
        return (JavaUmlDataModel)super.getDataModel();
    }

    @Override
    public boolean isInCategory(@Nullable Object nodeElement, @Nullable Object item, @NotNull DiagramCategory category, @Nullable DiagramBuilder builder) {
        if (category == null) {
            JavaUmlCategoryManager.$$$reportNull$$$0(1);
        }
        if (builder == null || !(nodeElement instanceof PsiClass)) {
            return this.isInCategoryOldImpl(item, category);
        }
        JavaUmlDataModel dataModel = (JavaUmlDataModel)DiagramBuilderFactory.getInstance().getModelBuilder(builder).getDataModel();
        if (FIELDS.equals(category)) {
            return item instanceof PsiField && (!this.isCategoryEnabled(PROPERTIES) || dataModel.isPartOfProperty((PsiElement)((PsiClass)nodeElement), (PsiField)item));
        }
        if (CONSTRUCTORS.equals(category)) {
            return item instanceof PsiMethod && ((PsiMethod)item).isConstructor();
        }
        if (METHODS.equals(category)) {
            if (item instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)item;
                return !method.isConstructor() && (!this.isCategoryEnabled(PROPERTIES) && !UmlKotlinUtils.isFromKotlin((PsiElement)method) || !dataModel.isPartOfProperty((PsiElement)((PsiClass)nodeElement), method));
            }
            return false;
        }
        if (PROPERTIES.equals(category)) {
            return item instanceof JavaProperty;
        }
        return false;
    }

    public boolean isInCategoryOldImpl(@Nullable Object element, @NotNull DiagramCategory category) {
        if (category == null) {
            JavaUmlCategoryManager.$$$reportNull$$$0(2);
        }
        if (FIELDS.equals(category)) {
            return element instanceof PsiField && (!this.isCategoryEnabled(PROPERTIES) || JavaProperty.create((PsiField)element, true) == null);
        }
        if (CONSTRUCTORS.equals(category)) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor();
        }
        if (METHODS.equals(category)) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                boolean isPartOfProperty = JavaProperty.create(method) != null;
                return !method.isConstructor() && (!isPartOfProperty || !this.isCategoryEnabled(PROPERTIES) && !UmlKotlinUtils.isFromKotlin((PsiElement)method));
            }
            return false;
        }
        if (PROPERTIES.equals(category)) {
            return element instanceof JavaProperty;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlCategoryManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentCategories";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlCategoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInCategory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInCategoryOldImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

