/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricherBase;
import com.intellij.ml.inline.completion.java.features.correctness.JavaErrorEnrichmentTool;
import com.intellij.ml.inline.completion.java.features.correctness.JavaNamesHighlighterEnricher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000eH\u0014J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/java/features/correctness/JavaSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricherBase;", "isCloud", "", "(Z)V", "buildFileWithSuggestion", "Lcom/intellij/psi/PsiFile;", "originalFile", "suggestionOffset", "", "suggestion", "", "suffix", "matchedEnclosuresIndices", "", "createFile", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "name", "text", "intellij.ml.inline.completion.java"})
public final class JavaSuggestionEnricher
extends SuggestionEnricherBase {
    public JavaSuggestionEnricher(boolean isCloud) {
        Object[] objectArray = new RawEnrichmentTool[]{new JavaErrorEnrichmentTool(isCloud), new JavaNamesHighlighterEnricher()};
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    protected PsiFile buildFileWithSuggestion(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull String suffix, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        String originalText = originalFile.getText();
        boolean bl = false;
        Set<Integer> set = matchedEnclosuresIndices;
        int matchedSize = set != null ? set.size() : 0;
        Intrinsics.checkNotNull((Object)originalText);
        String lastPart = StringsKt.drop((String)originalText, (int)(suggestionOffset + matchedSize));
        boolean shouldClose = StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)suggestion)).toString(), (String)"{", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)suggestion)).toString(), (String)"(", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)suffix)).toString(), (String)")", (boolean)false, (int)2, null);
        String text2 = StringsKt.take((String)originalText, (int)suggestionOffset) + suggestion + (shouldClose ? suffix : "") + " " + lastPart;
        return (PsiFile)this.createFile(project2, name, text2, originalFile);
    }

    private final PsiJavaFile createFile(Project project, String name, String text2, PsiFile originalFile) {
        PsiJavaFile psiJavaFile;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(originalFile.getName(), originalFile.getLanguage(), (CharSequence)text2, true, true);
        PsiJavaFile psiJavaFile2 = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
        if (psiJavaFile2 == null) {
            psiJavaFile2 = (PsiJavaFile)new PsiJavaFileImpl(PsiManagerEx.getInstanceEx((Project)project).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(name, FileTypeManager.getInstance().getFileTypeByFileName(name), (CharSequence)text2), true));
        }
        PsiJavaFile it = psiJavaFile = psiJavaFile2;
        boolean bl = false;
        LanguageLevel level = originalFile instanceof PsiJavaFile ? ((PsiJavaFile)originalFile).getLanguageLevel() : LanguageLevel.HIGHEST;
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)it, (Object)level);
        return psiJavaFile;
    }
}

