/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.codeInsight.Angular2HighlightingUtils;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.inspections.quickfixes.AddJSPropertyQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/angular2/inspections/AngularInvalidSelectorInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.angular"})
public final class AngularInvalidSelectorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof HtmlCompatibleFile) {
            return (PsiElementVisitor)new XmlElementVisitor(holder){
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.$holder = $holder;
                }

                public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                    Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                    if (Intrinsics.areEqual((Object)attribute.getName(), (Object)"select") && Intrinsics.areEqual((Object)attribute.getParent().getName(), (Object)"ng-content")) {
                        XmlAttributeValue xmlAttributeValue = attribute.getValueElement();
                        if (xmlAttributeValue == null) {
                            return;
                        }
                        XmlAttributeValue value = xmlAttributeValue;
                        try {
                            String string = value.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                            Angular2DirectiveSimpleSelector.Companion.parse(string);
                        }
                        catch (Angular2DirectiveSimpleSelector.ParseException e) {
                            PsiElement psiElement = (PsiElement)value;
                            TextRange textRange = e.getErrorRange();
                            String string = value.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            CharSequence charSequence = string;
                            String string2 = value.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                            TextRange textRange2 = textRange.shiftRight(StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null));
                            String string3 = e.getMessage();
                            Intrinsics.checkNotNull((Object)string3);
                            this.$holder.registerProblem(psiElement, textRange2, string3, new LocalQuickFix[0]);
                        }
                    }
                }
            };
        }
        if (DialectDetector.isTypeScript((PsiElement)((PsiElement)holder.getFile()))) {
            PsiFile psiFile = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            if (Angular2LangUtil.isAngular2Context((PsiElement)psiFile)) {
                return (PsiElementVisitor)new JSElementVisitor(holder){
                    final /* synthetic */ ProblemsHolder $holder;
                    {
                        this.$holder = $holder;
                    }

                    public void visitES6Decorator(@NotNull ES6Decorator decorator) {
                        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
                        String[] stringArray = new String[]{"Component", "Directive"};
                        if (Angular2DecoratorUtil.isAngularEntityDecorator(decorator, stringArray)) {
                            JSObjectLiteralExpression jSObjectLiteralExpression = Angular2DecoratorUtil.getObjectLiteralInitializer(decorator);
                            if (jSObjectLiteralExpression == null) {
                                return;
                            }
                            JSObjectLiteralExpression initializer2 = jSObjectLiteralExpression;
                            JSProperty selector2 = initializer2.findProperty("selector");
                            if (selector2 == null) {
                                if (Intrinsics.areEqual((Object)"Directive", (Object)decorator.getDecoratorName())) {
                                    Angular2Directive angular2Directive = Angular2EntitiesProvider.getDirective((PsiElement)decorator);
                                    boolean bl = angular2Directive != null ? !angular2Directive.isStandalone() : false;
                                    if (bl) {
                                        Object[] objectArray = new Object[]{Angular2HighlightingUtils.INSTANCE.withColor("selector", Angular2HighlightingUtils.TextAttributesKind.TS_PROPERTY, (PsiElement)decorator)};
                                        String string = Angular2Bundle.Companion.htmlMessage("angular.inspection.invalid-directive-selector.message.missing", objectArray);
                                        objectArray = new LocalQuickFix[]{new AddJSPropertyQuickFix(initializer2, "selector", "", 0, false)};
                                        this.$holder.registerProblem((PsiElement)initializer2, string, (LocalQuickFix[])objectArray);
                                    }
                                }
                            } else {
                                String string = Angular2DecoratorUtil.getExpressionStringValue(selector2.getValue());
                                if (string == null) {
                                    return;
                                }
                                String text = string;
                                try {
                                    Angular2DirectiveSimpleSelector.Companion.parse(text);
                                }
                                catch (Angular2DirectiveSimpleSelector.ParseException e) {
                                    JSExpression jSExpression = selector2.getValue();
                                    Intrinsics.checkNotNull((Object)jSExpression);
                                    PsiElement psiElement = (PsiElement)jSExpression;
                                    TextRange textRange = e.getErrorRange().shiftRight(1);
                                    String string2 = e.getMessage();
                                    Intrinsics.checkNotNull((Object)string2);
                                    this.$holder.registerProblem(psiElement, textRange, string2, new LocalQuickFix[0]);
                                }
                            }
                        }
                    }
                };
            }
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
        return psiElementVisitor;
    }
}

