/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.tokenizer;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.tokenizer.Tokenizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\t2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;)V", "root", "Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode;", "sortedVocabEntries", "", "Lkotlin/Pair;", "", "", "getTokenizer", "()Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;", "findTrie", "word", "getInternalValuesWithPrefix", "prefix", "strict", "", "getValuesWithCompletionAwarePrefix", "", "getValuesWithPrefix", "TrieNode", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nTokenizerTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1045#2:121\n1559#2:122\n1590#2,4:123\n1549#2:127\n1620#2,3:128\n766#2:131\n857#2,2:132\n1549#2:134\n1620#2,3:135\n1549#2:138\n1620#2,3:139\n1603#2,9:142\n1855#2:151\n1856#2:153\n1612#2:154\n1#3:152\n1#3:155\n*S KotlinDebug\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie\n*L\n8#1:121\n13#1:122\n13#1:123,4\n21#1:127\n21#1:128,3\n22#1:131\n22#1:132,2\n33#1:134\n33#1:135,3\n37#1:138\n37#1:139,3\n43#1:142,9\n43#1:151\n43#1:153\n43#1:154\n43#1:152\n*E\n"})
public final class TokenizerTrie {
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final List<Pair<String, Integer>> sortedVocabEntries;
    @NotNull
    private final TrieNode root;

    /*
     * WARNING - void declaration
     */
    public TokenizerTrie(@NotNull Tokenizer tokenizer) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
        Iterable $this$sortedBy$iv = MapsKt.toList(this.tokenizer.getVocab());
        boolean $i$f$sortedBy = false;
        this.sortedVocabEntries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        });
        this.root = new TrieNode();
        Iterable $this$mapIndexed$iv = this.sortedVocabEntries;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void pair;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair2 = (Pair)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.root.addWord$intellij_fullLine_local((String)pair.getFirst(), (int)index);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.root.trimSubtree$intellij_fullLine_local();
    }

    @NotNull
    public final Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] getValuesWithCompletionAwarePrefix(@NotNull String prefix2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        List<Integer> answer = this.getInternalValuesWithPrefix(prefix2, false);
        Iterable $this$map$iv = answer;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)this.sortedVocabEntries.get((int)it).getFirst());
        }
        List answerStrings = (List)destination$iv$iv;
        Iterable $this$filter$iv = answerStrings;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            int subPrefixLen = it.length();
            if (prefix2.length() > subPrefixLen) {
                String toComplete;
                Intrinsics.checkNotNullExpressionValue((Object)prefix2.substring(subPrefixLen), (String)"substring(...)");
                bl = !((Collection)this.getInternalValuesWithPrefix(toComplete, true)).isEmpty();
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List completableAnswerStrings = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = completableAnswerStrings;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)MapsKt.getValue(this.tokenizer.getVocab(), (Object)it)).intValue());
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] getValuesWithPrefix(@NotNull String prefix2, boolean strict) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Iterable $this$map$iv = this.getInternalValuesWithPrefix(prefix2, strict);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)this.sortedVocabEntries.get((int)it).getSecond()).intValue());
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getInternalValuesWithPrefix(String prefix2, boolean strict) {
        Object answer;
        Pair<TrieNode, List<TrieNode>> pair = this.findTrie(prefix2);
        TrieNode foundTrie = (TrieNode)pair.component1();
        List path = (List)pair.component2();
        Object object = foundTrie;
        if (object == null || (object = ((TrieNode)object).getSubtrieValues$intellij_fullLine_local()) == null) {
            object = answer = CollectionsKt.emptyList();
        }
        if (!strict) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = path;
            Collection collection = (Collection)answer;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                TrieNode it = (TrieNode)element$iv$iv;
                boolean bl2 = false;
                if (it.getValueOrNull() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            answer = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        return answer;
    }

    private final Pair<TrieNode, List<TrieNode>> findTrie(String word) {
        if (((CharSequence)word).length() == 0) {
            return new Pair(null, (Object)CollectionsKt.emptyList());
        }
        TrieNode curNode = null;
        curNode = this.root;
        TrieNode newNode = null;
        List path = new ArrayList();
        int n = word.length();
        for (int i = 0; i < n; ++i) {
            Unit unit;
            char c = word.charAt(i);
            path.add(curNode);
            newNode = TrieNode.moveByChar$intellij_fullLine_local$default(curNode, c, false, 2, null);
            if (newNode != null) {
                boolean bl = false;
                curNode = newNode;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) break;
        }
        return new Pair(newNode, (Object)path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0013J\r\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0016\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode;", "", "()V", "end", "", "moves", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "start", "subtrieValues", "", "getSubtrieValues$intellij_fullLine_local", "()Ljava/util/List;", "value", "addWord", "", "word", "", "addWord$intellij_fullLine_local", "getEndOrNull", "()Ljava/lang/Integer;", "getStartOrNull", "getValueOrNull", "moveByChar", "char", "", "createNew", "", "moveByChar$intellij_fullLine_local", "trimSubtree", "trimSubtree$intellij_fullLine_local", "updateSubtrie", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nTokenizerTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,120:1\n1#2:121\n215#3,2:122\n*S KotlinDebug\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode\n*L\n99#1:122,2\n*E\n"})
    public static final class TrieNode {
        private int value = -1;
        private int start = -1;
        private int end = -1;
        @NotNull
        private final Int2ObjectOpenHashMap<TrieNode> moves = new Int2ObjectOpenHashMap();

        @Nullable
        public final Integer getValueOrNull() {
            Integer n = this.value;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        private final Integer getStartOrNull() {
            Integer n = this.start;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        private final Integer getEndOrNull() {
            Integer n = this.end;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        @NotNull
        public final List<Integer> getSubtrieValues$intellij_fullLine_local() {
            Integer n = this.getStartOrNull();
            if (n == null) {
                return CollectionsKt.emptyList();
            }
            Integer n2 = this.getEndOrNull();
            if (n2 == null) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.toList((Iterable)((Iterable)new IntRange(n.intValue(), n2.intValue())));
        }

        public final void addWord$intellij_fullLine_local(@NotNull String word, int value) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (!(value >= 0)) {
                boolean bl = false;
                String string = "Value must be >= 0. We use -1 instead of null for RAM optimization";
                throw new IllegalArgumentException(string.toString());
            }
            TrieNode curNode = this;
            curNode.updateSubtrie(value);
            int n = word.length();
            for (int i = 0; i < n; ++i) {
                char c = word.charAt(i);
                Intrinsics.checkNotNull((Object)curNode.moveByChar$intellij_fullLine_local(c, true));
                curNode.updateSubtrie(value);
            }
            curNode.value = value;
        }

        public final void trimSubtree$intellij_fullLine_local() {
            this.moves.trim();
            Map $this$forEach$iv = (Map)this.moves;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                TrieNode u = (TrieNode)entry.getValue();
                u.trimSubtree$intellij_fullLine_local();
            }
        }

        @Nullable
        public final TrieNode moveByChar$intellij_fullLine_local(char c, boolean createNew) {
            char charCode = c;
            if (!this.moves.containsKey((int)charCode)) {
                if (createNew) {
                    Integer n = charCode;
                    ((Map)this.moves).put(n, new TrieNode());
                } else {
                    return null;
                }
            }
            return (TrieNode)MapsKt.getValue((Map)((Map)this.moves), (Object)charCode);
        }

        public static /* synthetic */ TrieNode moveByChar$intellij_fullLine_local$default(TrieNode trieNode, char c, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return trieNode.moveByChar$intellij_fullLine_local(c, bl);
        }

        private final void updateSubtrie(int value) {
            int n;
            int n2;
            int n3;
            int it;
            TrieNode trieNode;
            if (!(value >= 0)) {
                boolean bl = false;
                String string = "Value must be >= 0. We use -1 instead of null for RAM optimization";
                throw new IllegalArgumentException(string.toString());
            }
            TrieNode trieNode2 = this;
            Integer n4 = this.getStartOrNull();
            if (n4 != null) {
                int n5 = ((Number)n4).intValue();
                trieNode = trieNode2;
                boolean bl = false;
                n3 = Math.min(it, value);
                trieNode2 = trieNode;
                n2 = n3;
            } else {
                n2 = value;
            }
            trieNode2.start = n2;
            TrieNode trieNode3 = this;
            Integer n6 = this.getEndOrNull();
            if (n6 != null) {
                it = ((Number)n6).intValue();
                trieNode = trieNode3;
                boolean bl = false;
                n3 = Math.max(it, value);
                trieNode3 = trieNode;
                n = n3;
            } else {
                n = value;
            }
            trieNode3.end = n;
        }
    }
}

