/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.tokenizer;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.tokenizer.BPEException;
import org.jetbrains.completion.full.line.local.tokenizer.BPERule;
import org.jetbrains.completion.full.line.local.tokenizer.BPEState;
import org.jetbrains.completion.full.line.local.tokenizer.BaseEncoder;
import org.jetbrains.completion.full.line.local.tokenizer.BasePriorityQueue;
import org.jetbrains.completion.full.line.local.tokenizer.DropoutQueue;
import org.jetbrains.completion.full.line.local.tokenizer.FullLineTokenizerKt;
import org.jetbrains.completion.full.line.local.tokenizer.STLQueue;
import org.jetbrains.completion.full.line.local.tokenizer.Status;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 12\u00020\u0001:\u00041234B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0002J4\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u001d\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\fH\u0002J\r\u0010-\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b.J\u0013\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0000\u00a2\u0006\u0002\b0R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;", "", "bpeState", "Lorg/jetbrains/completion/full/line/local/tokenizer/BPEState;", "id2char", "Lit/unimi/dsi/fastutil/ints/Int2IntMap;", "rule2id", "Lit/unimi/dsi/fastutil/longs/Long2IntMap;", "recipe", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntList;", "spaceToken", "", "(Lorg/jetbrains/completion/full/line/local/tokenizer/BPEState;Lit/unimi/dsi/fastutil/ints/Int2IntMap;Lit/unimi/dsi/fastutil/longs/Long2IntMap;Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;I)V", "getBpeState$intellij_fullLine_local", "()Lorg/jetbrains/completion/full/line/local/tokenizer/BPEState;", "setBpeState$intellij_fullLine_local", "(Lorg/jetbrains/completion/full/line/local/tokenizer/BPEState;)V", "decodeIds", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$DecodingResult;", "ids", "", "decodeSentence", "", "sentenceIds", "encodeAsIds", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$EncodingResult;", "sentences", "bos", "", "eos", "reverse", "dropoutProb", "", "encodeMany", "encodingConfig", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$EncodingConfig;", "encodeSentence", "sentence", "idToSubword", "id", "replaceSpace", "idToSubword$intellij_fullLine_local", "isSpace", "ch", "vocabSize", "vocabSize$intellij_fullLine_local", "vocabulary", "vocabulary$intellij_fullLine_local", "Companion", "DecodingResult", "EncodingConfig", "EncodingResult", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nFullLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,526:1\n1855#2,2:527\n1747#2,3:529\n1549#2:532\n1620#2,3:533\n*S KotlinDebug\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder\n*L\n297#1:527,2\n340#1:529,3\n381#1:532\n381#1:533,3\n*E\n"})
public final class BaseEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BPEState bpeState;
    @NotNull
    private Int2IntMap id2char;
    @NotNull
    private Long2IntMap rule2id;
    @NotNull
    private Int2ObjectMap<IntList> recipe;
    private final int spaceToken;

    private BaseEncoder(BPEState bpeState, Int2IntMap id2char, Long2IntMap rule2id, Int2ObjectMap<IntList> recipe, int spaceToken) {
        this.bpeState = bpeState;
        this.id2char = id2char;
        this.rule2id = rule2id;
        this.recipe = recipe;
        this.spaceToken = spaceToken;
    }

    @NotNull
    public final BPEState getBpeState$intellij_fullLine_local() {
        return this.bpeState;
    }

    public final void setBpeState$intellij_fullLine_local(@NotNull BPEState bPEState) {
        Intrinsics.checkNotNullParameter((Object)bPEState, (String)"<set-?>");
        this.bpeState = bPEState;
    }

    @NotNull
    public final EncodingResult encodeAsIds(@NotNull List<String> sentences, boolean bos, boolean eos, boolean reverse, double dropoutProb) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        EncodingConfig encodingConfig = new EncodingConfig(bos, eos, reverse, dropoutProb);
        EncodingResult encodingParallelResult = this.encodeMany(sentences, encodingConfig);
        List<List<Integer>> decodeResults = encodingParallelResult.getIds();
        Status status = encodingParallelResult.getStatus();
        return new EncodingResult(status, decodeResults);
    }

    private final EncodingResult encodeMany(List<String> sentences, EncodingConfig encodingConfig) {
        if (encodingConfig.getBos() && this.bpeState.getSpecialTokens().getBosId() == -1) {
            return new EncodingResult(new Status(1, "Can't add <BOS> token. Model was trained without it."), null);
        }
        if (encodingConfig.getEos() && this.bpeState.getSpecialTokens().getEosId() == -1) {
            return new EncodingResult(new Status(1, "Can't add <EOS> token. Model was trained without it."), null);
        }
        ArrayList<List<Integer>> ids2 = new ArrayList<List<Integer>>(sentences.size());
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String sentence = (String)element$iv;
            boolean bl = false;
            ids2.add(this.encodeSentence(sentence, encodingConfig));
        }
        return new EncodingResult(new Status(), (List<? extends List<Integer>>)ids2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> encodeSentence(String sentence, EncodingConfig encodingConfig) {
        boolean $this$any$iv2;
        List text;
        HashMap unrecognizedTokens;
        List list;
        ArrayList<Integer> outputIds;
        block23: {
            outputIds = new ArrayList<Integer>();
            if (encodingConfig.getBos()) {
                outputIds.add(this.bpeState.getSpecialTokens().getBosId());
            }
            list = new ArrayList();
            unrecognizedTokens = new HashMap();
            IntStream intStream = sentence.codePoints();
            Intrinsics.checkNotNullExpressionValue((Object)intStream, (String)"codePoints(...)");
            text = StreamsKt.toList((IntStream)intStream);
            Set<Integer> set = this.bpeState.getChar2id().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$any$iv2 = set;
            boolean $i$f$any = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv2) {
                    Integer it = (Integer)element$iv;
                    boolean bl = false;
                    Integer n = it;
                    int n2 = this.spaceToken;
                    if (!(n != null && n == n2)) continue;
                    v2 = true;
                    break block23;
                }
                v2 = $this$any$iv2 = false;
            }
        }
        if (_Assertions.ENABLED && !$this$any$iv2) {
            String $i$f$any = "Assertion failed";
            throw new AssertionError((Object)$i$f$any);
        }
        int newTokensStart = 1000000000;
        int newTokenCur = 0;
        int textIndex = 0;
        while (textIndex < text.size()) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J,\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006\u001c"}, d2={"org/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$encodeSentence$NodeDecoder", "", "tokenId", "", "curPos", "(II)V", "prev", "next", "(III)V", "getNext", "()I", "setNext", "(I)V", "getPrev", "setPrev", "getTokenId", "setTokenId", "component1", "component2", "component3", "copy", "(III)Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$encodeSentence$NodeDecoder;", "equals", "", "other", "hashCode", "toString", "", "intellij.fullLine.local"})
            public final class NodeDecoder {
                private int tokenId;
                private int prev;
                private int next;

                public NodeDecoder(int tokenId, int prev, int next) {
                    this.tokenId = tokenId;
                    this.prev = prev;
                    this.next = next;
                }

                public final int getTokenId() {
                    return this.tokenId;
                }

                public final void setTokenId(int n) {
                    this.tokenId = n;
                }

                public final int getPrev() {
                    return this.prev;
                }

                public final void setPrev(int n) {
                    this.prev = n;
                }

                public final int getNext() {
                    return this.next;
                }

                public final void setNext(int n) {
                    this.next = n;
                }

                public NodeDecoder(int tokenId, int curPos) {
                    this(tokenId, curPos - 1, curPos + 1);
                }

                public final int component1() {
                    return this.tokenId;
                }

                public final int component2() {
                    return this.prev;
                }

                public final int component3() {
                    return this.next;
                }

                @NotNull
                public final NodeDecoder copy(int tokenId, int prev, int next) {
                    return new NodeDecoder(tokenId, prev, next);
                }

                public static /* synthetic */ NodeDecoder copy$default(NodeDecoder nodeDecoder, int n, int n2, int n3, int n4, Object object) {
                    if ((n4 & 1) != 0) {
                        n = nodeDecoder.tokenId;
                    }
                    if ((n4 & 2) != 0) {
                        n2 = nodeDecoder.prev;
                    }
                    if ((n4 & 4) != 0) {
                        n3 = nodeDecoder.next;
                    }
                    return nodeDecoder.copy(n, n2, n3);
                }

                @NotNull
                public String toString() {
                    return "NodeDecoder(tokenId=" + this.tokenId + ", prev=" + this.prev + ", next=" + this.next + ")";
                }

                public int hashCode() {
                    int result = Integer.hashCode(this.tokenId);
                    result = result * 31 + Integer.hashCode(this.prev);
                    result = result * 31 + Integer.hashCode(this.next);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NodeDecoder)) {
                        return false;
                    }
                    NodeDecoder nodeDecoder = (NodeDecoder)other;
                    if (this.tokenId != nodeDecoder.tokenId) {
                        return false;
                    }
                    if (this.prev != nodeDecoder.prev) {
                        return false;
                    }
                    return this.next == nodeDecoder.next;
                }
            }
            boolean ruleId2;
            Object v5;
            Collection<Byte> collection;
            Object object;
            block24: {
                boolean $i$f$mapTo;
                list.clear();
                unrecognizedTokens.clear();
                while (textIndex < text.size() && this.isSpace(((Number)text.get(textIndex)).intValue())) {
                    ++textIndex;
                }
                int beginOfWordIndex = textIndex;
                while (textIndex < text.size() && !this.isSpace(((Number)text.get(textIndex)).intValue())) {
                    ++textIndex;
                }
                int endOfWordIndex = textIndex;
                newTokenCur = newTokensStart;
                list.add(new NodeDecoder(4, 0));
                int charInWordIndex = beginOfWordIndex;
                while (charInWordIndex < endOfWordIndex) {
                    if (!this.bpeState.getChar2id().containsKey(text.get(charInWordIndex))) {
                        void $this$mapTo$iv$iv;
                        int unrecognizedBeginIndex = charInWordIndex;
                        while (charInWordIndex < endOfWordIndex && !this.bpeState.getChar2id().containsKey(text.get(charInWordIndex))) {
                            ++charInWordIndex;
                        }
                        Map map2 = unrecognizedTokens;
                        Integer n = newTokenCur;
                        Object $this$map$iv = CollectionsKt.slice((List)text, (IntRange)new IntRange(unrecognizedBeginIndex, charInWordIndex - 1));
                        boolean $i$f$map = false;
                        object = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            int n3 = ((Number)item$iv$iv).intValue();
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add((byte)it);
                        }
                        $this$map$iv = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                        Intrinsics.checkNotNullExpressionValue((Object)Charset.forName("UTF-8"), (String)"forName(...)");
                        $this$map$iv = new String((byte[])$this$map$iv, $i$f$map);
                        map2.put(n, $this$map$iv);
                        list.add(new NodeDecoder(newTokenCur, list.size()));
                        ++newTokenCur;
                        continue;
                    }
                    list.add(new NodeDecoder(((Number)MapsKt.getValue((Map)this.bpeState.getChar2id(), text.get(charInWordIndex))).intValue(), list.size()));
                    ++charInWordIndex;
                }
                ((NodeDecoder)CollectionsKt.last((List)list)).setNext(-1);
                Function1 pairCode2 = (Function1)new Function1<Integer, Long>((List<NodeDecoder>)list){
                    final /* synthetic */ List<NodeDecoder> $list;
                    {
                        this.$list = $list;
                        super(1);
                    }

                    @NotNull
                    public final Long invoke(int firstPos) {
                        int secondPos = this.$list.get(firstPos).getNext();
                        return FullLineTokenizerKt.access$int2comb(this.$list.get(firstPos).getTokenId(), this.$list.get(secondPos).getTokenId());
                    }
                };
                BasePriorityQueue queue = encodingConfig.getDropoutProb() == 0.0 ? (BasePriorityQueue)new STLQueue() : (BasePriorityQueue)new DropoutQueue(encodingConfig.getDropoutProb());
                Function1 pushInQueueIfRuleExists2 = (Function1)new Function1<Integer, Unit>((Function1<? super Integer, Long>)pairCode2, this, (BasePriorityQueue<MergeEvent2>)queue){
                    final /* synthetic */ Function1<Integer, Long> $pairCode;
                    final /* synthetic */ BaseEncoder this$0;
                    final /* synthetic */ BasePriorityQueue<MergeEvent2> $queue;
                    {
                        this.$pairCode = $pairCode;
                        this.this$0 = $receiver;
                        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"org/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$encodeSentence$MergeEvent2", "", "priority", "", "pos", "(II)V", "getPos", "()I", "getPriority", "compareTo", "other", "(Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$encodeSentence$MergeEvent2;)I", "component1", "component2", "copy", "(II)Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$encodeSentence$MergeEvent2;", "equals", "", "", "hashCode", "toString", "", "intellij.fullLine.local"})
                        public final class MergeEvent2
                        implements Comparable<MergeEvent2> {
                            private final int priority;
                            private final int pos;

                            public MergeEvent2(int priority, int pos) {
                                this.priority = priority;
                                this.pos = pos;
                            }

                            public final int getPriority() {
                                return this.priority;
                            }

                            public final int getPos() {
                                return this.pos;
                            }

                            public int compareTo(@NotNull MergeEvent2 other) {
                                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                                return this.priority != other.priority ? this.priority - other.priority : this.pos - other.pos;
                            }

                            public final int component1() {
                                return this.priority;
                            }

                            public final int component2() {
                                return this.pos;
                            }

                            @NotNull
                            public final MergeEvent2 copy(int priority, int pos) {
                                return new MergeEvent2(priority, pos);
                            }

                            public static /* synthetic */ MergeEvent2 copy$default(MergeEvent2 mergeEvent2, int n, int n2, int n3, Object object) {
                                if ((n3 & 1) != 0) {
                                    n = mergeEvent2.priority;
                                }
                                if ((n3 & 2) != 0) {
                                    n2 = mergeEvent2.pos;
                                }
                                return mergeEvent2.copy(n, n2);
                            }

                            @NotNull
                            public String toString() {
                                return "MergeEvent2(priority=" + this.priority + ", pos=" + this.pos + ")";
                            }

                            public int hashCode() {
                                int result = Integer.hashCode(this.priority);
                                result = result * 31 + Integer.hashCode(this.pos);
                                return result;
                            }

                            public boolean equals(@Nullable Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (!(other instanceof MergeEvent2)) {
                                    return false;
                                }
                                MergeEvent2 mergeEvent2 = (MergeEvent2)other;
                                if (this.priority != mergeEvent2.priority) {
                                    return false;
                                }
                                return this.pos == mergeEvent2.pos;
                            }
                        }
                        this.$queue = $queue;
                        super(1);
                    }

                    public final void invoke(int pos) {
                        long key = ((Number)this.$pairCode.invoke((Object)pos)).longValue();
                        if (BaseEncoder.access$getRule2id$p(this.this$0).containsKey(key)) {
                            this.$queue.push(new MergeEvent2(BaseEncoder.access$getRule2id$p(this.this$0).get(key), pos));
                        }
                    }
                };
                int i = 0;
                int $i$f$map = list.size() - 2;
                if (i <= $i$f$map) {
                    while (true) {
                        pushInQueueIfRuleExists2.invoke((Object)i);
                        if (i == $i$f$map) break;
                        ++i;
                    }
                }
                while ((MergeEvent2)queue.pop() != null) {
                    int pos2;
                    MergeEvent2 event;
                    int ruleId2 = event.getPriority();
                    int pos1 = event.getPos();
                    boolean bl = $i$f$mapTo = pos1 != (pos2 = ((NodeDecoder)list.get(pos1)).getNext());
                    if (_Assertions.ENABLED && !$i$f$mapTo) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if (((NodeDecoder)list.get(pos1)).getTokenId() != this.bpeState.getRules().get(ruleId2).getX() || pos2 == -1 || ((NodeDecoder)list.get(pos2)).getTokenId() != this.bpeState.getRules().get(ruleId2).getY()) continue;
                    int pos0 = ((NodeDecoder)list.get(pos1)).getPrev();
                    int pos3 = ((NodeDecoder)list.get(pos2)).getNext();
                    list.set(pos2, new NodeDecoder(0, -1, -1));
                    list.set(pos1, new NodeDecoder(this.bpeState.getRules().get(ruleId2).getZ(), pos0, pos3));
                    if (pos3 != -1) {
                        ((NodeDecoder)list.get(pos3)).setPrev(pos1);
                    }
                    if (pos0 != -1) {
                        pushInQueueIfRuleExists2.invoke((Object)pos0);
                    }
                    if (pos3 == -1) continue;
                    pushInQueueIfRuleExists2.invoke((Object)pos1);
                }
                Iterable ruleId2 = list;
                collection = list;
                object = ruleId2;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    NodeDecoder it = (NodeDecoder)t;
                    boolean bl = false;
                    if (!(it.getTokenId() != 0)) continue;
                    v5 = t;
                    break block24;
                }
                v5 = null;
            }
            int aliveTokenIndex = CollectionsKt.indexOf(collection, v5);
            boolean bl = ruleId2 = aliveTokenIndex != -1;
            if (_Assertions.ENABLED && !ruleId2) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            while (aliveTokenIndex != -1) {
                int tokenId = ((NodeDecoder)list.get(aliveTokenIndex)).getTokenId();
                if (tokenId >= newTokensStart) {
                    outputIds.add(this.bpeState.getSpecialTokens().getUnkId());
                } else {
                    outputIds.add(tokenId);
                }
                aliveTokenIndex = ((NodeDecoder)list.get(aliveTokenIndex)).getNext();
            }
        }
        return outputIds;
    }

    private final boolean isSpace(int ch) {
        return ch == 10;
    }

    @NotNull
    public final DecodingResult decodeIds(@NotNull List<? extends List<Integer>> ids2) {
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        ArrayList<String> sentences = new ArrayList<String>();
        for (List<Integer> list : ids2) {
            String sentence = this.decodeSentence(list);
            sentences.add(sentence);
        }
        return new DecodingResult(new Status(), (List<String>)sentences);
    }

    private final String decodeSentence(List<Integer> sentenceIds) {
        Object sentence = "";
        Iterator<Integer> iterator2 = sentenceIds.iterator();
        while (iterator2.hasNext()) {
            int id = ((Number)iterator2.next()).intValue();
            sentence = (String)sentence + this.idToSubword$intellij_fullLine_local(id, true);
        }
        return sentence;
    }

    public final int vocabSize$intellij_fullLine_local() {
        return this.bpeState.getRules().size() + this.bpeState.getChar2id().size() + this.bpeState.getSpecialTokens().nSpecialTokens();
    }

    @NotNull
    public final String idToSubword$intellij_fullLine_local(int id, boolean replaceSpace) {
        if (id < 0 || this.vocabSize$intellij_fullLine_local() <= id) {
            throw new IllegalArgumentException("id must be in the range [0, vocab_size - 1]. Current value: vocab_size=" + this.vocabSize$intellij_fullLine_local() + "; id=" + id + ";");
        }
        if (this.bpeState.getSpecialTokens().getUnkId() == id) {
            return "<UNK>";
        }
        if (this.bpeState.getSpecialTokens().getPadId() == id) {
            return "<PAD>";
        }
        if (this.bpeState.getSpecialTokens().getBosId() == id) {
            return "<BOS>";
        }
        if (this.bpeState.getSpecialTokens().getEosId() == id) {
            return "<EOS>";
        }
        boolean bl = this.recipe.containsKey(id);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (replaceSpace && this.spaceToken == 9601) {
            IntList symbols = (IntList)MapsKt.getValue((Map)((Map)this.recipe), (Object)id);
            Integer n = (Integer)MapsKt.getValue((Map)((Map)this.id2char), (Object)symbols.get(0));
            int n2 = this.spaceToken;
            if (n != null && n == n2) {
                IntList intList = symbols.subList(1, symbols.size());
                Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"subList(...)");
                return "\n" + FullLineTokenizerKt.access$token2word((List)intList, this.id2char);
            }
        }
        Object object = MapsKt.getValue((Map)((Map)this.recipe), (Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return FullLineTokenizerKt.access$token2word((List)object, this.id2char);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> vocabulary$intellij_fullLine_local() {
        int n = this.vocabSize$intellij_fullLine_local();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.idToSubword$intellij_fullLine_local((int)it, true));
        }
        return arrayList;
    }

    public /* synthetic */ BaseEncoder(BPEState bpeState, Int2IntMap id2char, Long2IntMap rule2id, Int2ObjectMap recipe, int spaceToken, DefaultConstructorMarker $constructor_marker) {
        this(bpeState, id2char, rule2id, (Int2ObjectMap<IntList>)recipe, spaceToken);
    }

    public static final /* synthetic */ Long2IntMap access$getRule2id$p(BaseEncoder $this) {
        return $this.rule2id;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$Companion;", "", "()V", "load", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;", "modelFile", "Ljava/io/File;", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nFullLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,526:1\n125#2:527\n152#2,3:528\n215#2,2:536\n1559#3:531\n1590#3,4:532\n1855#3,2:538\n*S KotlinDebug\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$Companion\n*L\n248#1:527\n248#1:528,3\n251#1:536,2\n249#1:531\n249#1:532,4\n254#1:538,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BaseEncoder load(@NotNull File modelFile) {
            Object object;
            Map.Entry element$iv;
            void $this$mapIndexedTo$iv$iv;
            Collection collection;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
            BPEState bpeState = new BPEState();
            Int2IntOpenHashMap id2char = new Int2IntOpenHashMap();
            Long2IntOpenHashMap rule2id = new Long2IntOpenHashMap();
            Int2ObjectOpenHashMap recipe = new Int2ObjectOpenHashMap();
            Status status = bpeState.load(modelFile);
            if (!status.ok()) {
                throw new BPEException("Couldn't load model from " + modelFile.getAbsolutePath());
            }
            Map $this$map$iv = bpeState.getChar2id();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it;
                object2 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getValue(), it.getKey()));
            }
            MapsKt.toMap((Iterable)((List)destination$iv$iv), (Map)((Map)id2char));
            Iterable $this$mapIndexed$iv = bpeState.getRules();
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void rule;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BPERule bPERule = (BPERule)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)FullLineTokenizerKt.access$int2comb(rule.getX(), rule.getY()), (Object)((int)i)));
            }
            MapsKt.toMap((Iterable)((List)destination$iv$iv), (Map)((Map)rule2id));
            Object $this$forEach$iv = (Map)id2char;
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry it = element$iv = (Map.Entry)iterator2.next();
                boolean bl = false;
                object = (Map)recipe;
                object2 = it.getKey();
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                IntList intList = IntLists.singleton((int)((Number)k).intValue());
                object.put(object2, intList);
            }
            $this$forEach$iv = bpeState.getRules();
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                IntList intList;
                element$iv = iterator2.next();
                BPERule it = (BPERule)((Object)element$iv);
                boolean bl = false;
                object = (Map)recipe;
                object2 = it.getZ();
                IntList intList2 = intList = (IntList)recipe.get(it.getX());
                if (intList2 == null) {
                    throw new IllegalStateException(((Object)it).toString());
                }
                Intrinsics.checkNotNull((Object)intList2);
                IntList intList3 = intList;
                IntList intList4 = intList = (IntList)recipe.get(it.getY());
                if (intList4 == null) {
                    throw new IllegalStateException(((Object)it).toString());
                }
                Intrinsics.checkNotNull((Object)intList4);
                intList = FullLineTokenizerKt.access$concatVectors(intList3, intList);
                object.put(object2, intList);
            }
            int spaceToken = id2char.get(4);
            return new BaseEncoder(bpeState, (Int2IntMap)id2char, (Long2IntMap)rule2id, (Int2ObjectMap)recipe, spaceToken, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$DecodingResult;", "", "status", "Lorg/jetbrains/completion/full/line/local/tokenizer/Status;", "sentences", "", "", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Status;Ljava/util/List;)V", "getSentences", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/completion/full/line/local/tokenizer/Status;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.fullLine.local"})
    public static final class DecodingResult {
        @NotNull
        private final Status status;
        @NotNull
        private final List<String> sentences;

        public DecodingResult(@NotNull Status status, @NotNull List<String> sentences) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
            this.status = status;
            this.sentences = sentences;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @NotNull
        public final List<String> getSentences() {
            return this.sentences;
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        @NotNull
        public final List<String> component2() {
            return this.sentences;
        }

        @NotNull
        public final DecodingResult copy(@NotNull Status status, @NotNull List<String> sentences) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
            return new DecodingResult(status, sentences);
        }

        public static /* synthetic */ DecodingResult copy$default(DecodingResult decodingResult, Status status, List list, int n, Object object) {
            if ((n & 1) != 0) {
                status = decodingResult.status;
            }
            if ((n & 2) != 0) {
                list = decodingResult.sentences;
            }
            return decodingResult.copy(status, list);
        }

        @NotNull
        public String toString() {
            return "DecodingResult(status=" + this.status + ", sentences=" + this.sentences + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + ((Object)this.sentences).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecodingResult)) {
                return false;
            }
            DecodingResult decodingResult = (DecodingResult)other;
            if (!Intrinsics.areEqual((Object)this.status, (Object)decodingResult.status)) {
                return false;
            }
            return Intrinsics.areEqual(this.sentences, decodingResult.sentences);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$EncodingConfig;", "", "bos", "", "eos", "reverse", "dropoutProb", "", "(ZZZD)V", "getBos", "()Z", "getDropoutProb", "()D", "getEos", "getReverse", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.fullLine.local"})
    public static final class EncodingConfig {
        private final boolean bos;
        private final boolean eos;
        private final boolean reverse;
        private final double dropoutProb;

        public EncodingConfig(boolean bos, boolean eos, boolean reverse, double dropoutProb) {
            this.bos = bos;
            this.eos = eos;
            this.reverse = reverse;
            this.dropoutProb = dropoutProb;
        }

        public final boolean getBos() {
            return this.bos;
        }

        public final boolean getEos() {
            return this.eos;
        }

        public final boolean getReverse() {
            return this.reverse;
        }

        public final double getDropoutProb() {
            return this.dropoutProb;
        }

        public final boolean component1() {
            return this.bos;
        }

        public final boolean component2() {
            return this.eos;
        }

        public final boolean component3() {
            return this.reverse;
        }

        public final double component4() {
            return this.dropoutProb;
        }

        @NotNull
        public final EncodingConfig copy(boolean bos, boolean eos, boolean reverse, double dropoutProb) {
            return new EncodingConfig(bos, eos, reverse, dropoutProb);
        }

        public static /* synthetic */ EncodingConfig copy$default(EncodingConfig encodingConfig, boolean bl, boolean bl2, boolean bl3, double d, int n, Object object) {
            if ((n & 1) != 0) {
                bl = encodingConfig.bos;
            }
            if ((n & 2) != 0) {
                bl2 = encodingConfig.eos;
            }
            if ((n & 4) != 0) {
                bl3 = encodingConfig.reverse;
            }
            if ((n & 8) != 0) {
                d = encodingConfig.dropoutProb;
            }
            return encodingConfig.copy(bl, bl2, bl3, d);
        }

        @NotNull
        public String toString() {
            return "EncodingConfig(bos=" + this.bos + ", eos=" + this.eos + ", reverse=" + this.reverse + ", dropoutProb=" + this.dropoutProb + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.bos);
            result = result * 31 + Boolean.hashCode(this.eos);
            result = result * 31 + Boolean.hashCode(this.reverse);
            result = result * 31 + Double.hashCode(this.dropoutProb);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncodingConfig)) {
                return false;
            }
            EncodingConfig encodingConfig = (EncodingConfig)other;
            if (this.bos != encodingConfig.bos) {
                return false;
            }
            if (this.eos != encodingConfig.eos) {
                return false;
            }
            if (this.reverse != encodingConfig.reverse) {
                return false;
            }
            return Double.compare(this.dropoutProb, encodingConfig.dropoutProb) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001f\u0010\u0004\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder$EncodingResult;", "", "status", "Lorg/jetbrains/completion/full/line/local/tokenizer/Status;", "ids", "", "", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Status;Ljava/util/List;)V", "getIds", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/completion/full/line/local/tokenizer/Status;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.fullLine.local"})
    public static final class EncodingResult {
        @NotNull
        private final Status status;
        @Nullable
        private final List<List<Integer>> ids;

        public EncodingResult(@NotNull Status status, @Nullable List<? extends List<Integer>> ids2) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.status = status;
            this.ids = ids2;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @Nullable
        public final List<List<Integer>> getIds() {
            return this.ids;
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        @Nullable
        public final List<List<Integer>> component2() {
            return this.ids;
        }

        @NotNull
        public final EncodingResult copy(@NotNull Status status, @Nullable List<? extends List<Integer>> ids2) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new EncodingResult(status, ids2);
        }

        public static /* synthetic */ EncodingResult copy$default(EncodingResult encodingResult, Status status, List list, int n, Object object) {
            if ((n & 1) != 0) {
                status = encodingResult.status;
            }
            if ((n & 2) != 0) {
                list = encodingResult.ids;
            }
            return encodingResult.copy(status, list);
        }

        @NotNull
        public String toString() {
            return "EncodingResult(status=" + this.status + ", ids=" + this.ids + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + (this.ids == null ? 0 : ((Object)this.ids).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncodingResult)) {
                return false;
            }
            EncodingResult encodingResult = (EncodingResult)other;
            if (!Intrinsics.areEqual((Object)this.status, (Object)encodingResult.status)) {
                return false;
            }
            return Intrinsics.areEqual(this.ids, encodingResult.ids);
        }
    }
}

