/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.UtilsKt;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchGraph;
import org.jetbrains.completion.full.line.local.generation.search.Search;
import org.jetbrains.completion.full.line.local.tokenizer.Tokenizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020#H\u0002J\u0014\u00101\u001a\u00020/2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020/2\u0006\u00106\u001a\u000207R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR6\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R6\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R6\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R6\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R6\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020#@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R6\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/generation/SearchState;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;", "searchSize", "", "prefix", "", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;ILjava/lang/String;)V", "prefixes", "", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;ILjava/util/List;)V", "graph", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "getGraph", "()Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "<set-?>", "", "", "hypothesesNormalizedProbabilities", "getHypothesesNormalizedProbabilities", "()Ljava/util/List;", "hypothesesNormalizedScores", "getHypothesesNormalizedScores", "hypothesesNormalizedTokenScores", "getHypothesesNormalizedTokenScores", "hypothesesProbabilities", "getHypothesesProbabilities", "hypothesesScores", "getHypothesesScores", "hypothesesTokenScores", "getHypothesesTokenScores", "hypothesesTokens", "getHypothesesTokens", "lastPredictions", "", "getLastPredictions", "()[I", "length", "getLength", "()I", "getPrefixes", "sortMask", "getSortMask", "tokenEntropies", "getTokenEntropies", "applySliceToState", "", "tensorSlice", "dropHypotheses", "indices", "isEmpty", "", "update", "stepResult", "Lorg/jetbrains/completion/full/line/local/generation/search/Search$StepResult;", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nSearchState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchState.kt\norg/jetbrains/completion/full/line/local/generation/generation/SearchState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n1864#2,3:98\n766#2:101\n857#2,2:102\n11095#3:104\n11430#3,3:105\n11095#3:108\n11430#3,3:109\n11095#3:112\n11430#3,3:113\n11095#3:116\n11430#3,3:117\n11095#3:120\n11430#3,3:121\n11095#3:124\n11430#3,3:125\n*S KotlinDebug\n*F\n+ 1 SearchState.kt\norg/jetbrains/completion/full/line/local/generation/generation/SearchState\n*L\n65#1:98,3\n77#1:101\n77#1:102,2\n88#1:104\n88#1:105,3\n89#1:108\n89#1:109,3\n90#1:112\n90#1:113,3\n91#1:116\n91#1:117,3\n92#1:120\n92#1:121,3\n93#1:124\n93#1:125,3\n*E\n"})
public final class SearchState {
    @NotNull
    private final Tokenizer tokenizer;
    private final int searchSize;
    @NotNull
    private List<String> prefixes;
    private int length;
    @NotNull
    private List<? extends List<Integer>> hypothesesTokens;
    @NotNull
    private List<? extends List<Double>> hypothesesProbabilities;
    @NotNull
    private List<? extends List<Double>> hypothesesNormalizedProbabilities;
    @NotNull
    private List<? extends List<Double>> hypothesesTokenScores;
    @NotNull
    private List<? extends List<Double>> hypothesesNormalizedTokenScores;
    @NotNull
    private List<Double> hypothesesScores;
    @NotNull
    private List<Double> hypothesesNormalizedScores;
    @NotNull
    private List<? extends List<Double>> tokenEntropies;
    private int[] sortMask;
    @NotNull
    private final BeamSearchGraph graph;

    public SearchState(@NotNull Tokenizer tokenizer, int searchSize, @NotNull List<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        this.tokenizer = tokenizer;
        this.searchSize = searchSize;
        this.prefixes = prefixes;
        this.hypothesesTokens = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesProbabilities = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesNormalizedProbabilities = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesTokenScores = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesNormalizedTokenScores = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesScores = CollectionsKt.listOf((Object)0.0);
        this.hypothesesNormalizedScores = CollectionsKt.listOf((Object)0.0);
        this.tokenEntropies = CollectionsKt.listOf((Object)new ArrayList());
        this.graph = new BeamSearchGraph(this.tokenizer);
    }

    public SearchState(@NotNull Tokenizer tokenizer, int searchSize, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        this(tokenizer, searchSize, CollectionsKt.listOf((Object)prefix2));
    }

    @NotNull
    public final List<String> getPrefixes() {
        return this.prefixes;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final List<List<Integer>> getHypothesesTokens() {
        return this.hypothesesTokens;
    }

    @NotNull
    public final List<List<Double>> getHypothesesProbabilities() {
        return this.hypothesesProbabilities;
    }

    @NotNull
    public final List<List<Double>> getHypothesesNormalizedProbabilities() {
        return this.hypothesesNormalizedProbabilities;
    }

    @NotNull
    public final List<List<Double>> getHypothesesTokenScores() {
        return this.hypothesesTokenScores;
    }

    @NotNull
    public final List<List<Double>> getHypothesesNormalizedTokenScores() {
        return this.hypothesesNormalizedTokenScores;
    }

    @NotNull
    public final List<Double> getHypothesesScores() {
        return this.hypothesesScores;
    }

    @NotNull
    public final List<Double> getHypothesesNormalizedScores() {
        return this.hypothesesNormalizedScores;
    }

    @NotNull
    public final List<List<Double>> getTokenEntropies() {
        return this.tokenEntropies;
    }

    @NotNull
    public final int[] getSortMask() {
        if (this.sortMask != null) {
            return this.sortMask;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sortMask");
        return null;
    }

    @NotNull
    public final BeamSearchGraph getGraph() {
        return this.graph;
    }

    @NotNull
    public final int[] getLastPredictions() {
        if (this.isEmpty()) {
            return new int[0];
        }
        int n = 0;
        int n2 = this.hypothesesTokens.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ((Number)CollectionsKt.last(this.hypothesesTokens.get(n3))).intValue();
        }
        return nArray;
    }

    public final boolean isEmpty() {
        return this.hypothesesTokens.isEmpty() || this.hypothesesTokens.get(0).size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull Search.StepResult stepResult) {
        Intrinsics.checkNotNullParameter((Object)stepResult, (String)"stepResult");
        int n = 0;
        int n2 = stepResult.getNewTokens().length;
        int[] nArray = new int[n2];
        SearchState searchState = this;
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        searchState.sortMask = nArray;
        this.applySliceToState(stepResult.getSortMask());
        this.hypothesesScores = ArraysKt.toMutableList((double[])stepResult.getScores());
        this.hypothesesNormalizedScores = ArraysKt.toMutableList((double[])stepResult.getNormalizedScores());
        n2 = this.hypothesesTokens.size();
        for (int i = 0; i < n2; ++i) {
            this.hypothesesTokens.get(i).add(stepResult.getNewTokens()[i]);
            this.hypothesesProbabilities.get(i).add(stepResult.getProbabilities()[i]);
            this.hypothesesNormalizedProbabilities.get(i).add(stepResult.getNormalizedProbabilities()[i]);
            this.hypothesesTokenScores.get(i).add(stepResult.getScores()[i]);
            this.hypothesesNormalizedTokenScores.get(i).add(stepResult.getNormalizedScores()[i]);
            this.tokenEntropies.get(i).add(stepResult.getEntropies()[i]);
        }
        ++this.length;
        ArrayList<String> result = new ArrayList<String>(this.prefixes.size());
        Iterable $this$forEachIndexed$iv = this.prefixes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String newPrefix;
            void prefix2;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n4;
            boolean bl = false;
            int tokenId = ((Number)CollectionsKt.last(this.hypothesesTokens.get(i))).intValue();
            String token = this.tokenizer.decode(tokenId);
            Intrinsics.checkNotNullExpressionValue((Object)prefix2.substring(Math.min(prefix2.length(), token.length())), (String)"substring(...)");
            result.add(newPrefix);
        }
        this.prefixes = result;
        this.graph.update(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropHypotheses(@NotNull List<Integer> indices) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)this.hypothesesScores);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(!indices.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int[] newSortMask = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        this.applySliceToState(newSortMask);
        int[] topBsMask = UtilsKt.topk1d(CollectionsKt.toDoubleArray((Collection)this.hypothesesScores), Math.min(this.searchSize, this.hypothesesScores.size()));
        this.applySliceToState(topBsMask);
        this.graph.terminateHypotheses(this.length - 1, indices);
    }

    private final void applySliceToState(int[] tensorSlice) {
        int n;
        int it;
        Collection collection;
        int item$iv$iv2;
        int[] $this$mapTo$iv$iv;
        int[] $this$map$iv;
        this.prefixes = UtilsKt.slice(this.prefixes, tensorSlice);
        this.hypothesesScores = CollectionsKt.toMutableList((Collection)UtilsKt.slice(this.hypothesesScores, tensorSlice));
        this.hypothesesNormalizedScores = CollectionsKt.toMutableList((Collection)UtilsKt.slice(this.hypothesesNormalizedScores, tensorSlice));
        int[] nArray = tensorSlice;
        SearchState searchState = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (int item$iv$iv2 : $this$mapTo$iv$iv) {
            void var10_11 = item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesTokens.get(it)));
        }
        searchState.hypothesesTokens = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesProbabilities.get(it)));
        }
        searchState.hypothesesProbabilities = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesNormalizedProbabilities.get(it)));
        }
        searchState.hypothesesNormalizedProbabilities = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesTokenScores.get(it)));
        }
        searchState.hypothesesTokenScores = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesNormalizedTokenScores.get(it)));
        }
        searchState.hypothesesNormalizedTokenScores = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.tokenEntropies.get(it)));
        }
        searchState.tokenEntropies = (List)destination$iv$iv;
        this.sortMask = UtilsKt.sliceArray(this.getSortMask(), tensorSlice);
    }
}

