/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestIndexProvider;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestConstants;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestElements;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrBoostTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static CidrBoostTestFramework getInstance() {
        return (CidrBoostTestFramework)CidrBoostTestFramework.getInstance(CidrBoostTestFramework.class);
    }

    public CidrBoostTestFramework() {
        super("Boost Test", new Class[]{OCMacroCall.class, OCCppNamespace.class, OCFunctionDefinition.class});
    }

    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(0);
        }
        Map map = CidrTestIndexProvider.INSTANCE.gatherTestLinks(file, "boost");
        if (map == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(2);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = CidrBoostTestFramework.getFrameworkVersionUsingImportedMacro((PsiFile)file, (String)"BOOST_AUTO_TEST_CASE");
        if (cidrTestFrameworkVersion == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(3);
        }
        return cidrTestFrameworkVersion;
    }

    @NonNls
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ":";
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return "boost://";
    }

    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        if (element == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(4);
        }
        return this.getTestObjectFromTestHolder(element, CidrBoostTestConstants.BOOST_TEST_MACRO_NAMES);
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(5);
        }
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project, new OCSymbolKind[]{OCSymbolKind.FUNCTION_DECLARATION});
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestNamespace(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(6);
        }
        return this.standardProbe(symbol, element, OCCppNamespace.class, project, new OCSymbolKind[]{OCSymbolKind.NAMESPACE});
    }

    @Nullable
    public CidrTestScopeElement generateVirtualTestScopeElement(String suitePath, String testPath, @NotNull String testSource) {
        if (testSource == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(7);
        }
        return "boost".equals(testSource) ? CidrBoostTestElements.createTestScopeElementForSuiteAndTest(suitePath, testPath) : null;
    }

    @NotNull
    protected Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function = CidrBoostTestElements.getGenerator();
        if (function == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(8);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestFramework";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestObjectsDirectly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameworkVersionDirectly";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestObjectsDirectly";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkVersionDirectly";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractTest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateVirtualTestScopeElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 8 -> new IllegalStateException(string);
        };
    }
}

