/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JTreeAddRootIfInvisibleTask;
import org.assertj.swing.driver.JTreePathFinder;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;

final class JTreeMatchingPathQuery {
    @Nonnull
    @RunsInEDT
    static TreePath verifyJTreeIsReadyAndFindMatchingPath(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        TreePath result2 = GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            @Nonnull
            protected TreePath executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                return JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            }
        });
        return (TreePath)Preconditions.checkNotNull((Object)result2);
    }

    @Nonnull
    @RunsInEDT
    static TreePath matchingPathFor(@Nonnull JTree tree, @Nonnull String path, @Nonnull JTreePathFinder pathFinder) {
        TreePath result2 = GuiActionRunner.execute(() -> JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder));
        return (TreePath)Preconditions.checkNotNull((Object)result2);
    }

    @Nonnull
    @RunsInCurrentThread
    static TreePath matchingPathWithRootIfInvisible(@Nonnull JTree tree, @Nonnull String path, @Nonnull JTreePathFinder pathFinder) {
        TreePath matchingPath = pathFinder.findMatchingPath(tree, path);
        return JTreeAddRootIfInvisibleTask.addRootIfInvisible(tree, matchingPath);
    }

    private JTreeMatchingPathQuery() {
    }
}

