/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.AbstractJTableCellWriter;
import org.assertj.swing.driver.JTextComponentDriver;
import org.assertj.swing.exception.ActionFailedException;

public class JTableTextComponentEditorCellWriter
extends AbstractJTableCellWriter {
    protected final JTextComponentDriver driver;

    public JTableTextComponentEditorCellWriter(@Nonnull Robot robot) {
        super(robot);
        this.driver = new JTextComponentDriver(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        JTextComponent editor2 = this.doStartCellEditing(table, row, column);
        this.driver.replaceText(editor2, value);
        this.stopCellEditing(table, row, column);
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        this.doStartCellEditing(table, row, column);
    }

    @Nonnull
    @RunsInEDT
    private JTextComponent doStartCellEditing(@Nonnull JTable table, int row, int column) {
        Point cellLocation = JTableTextComponentEditorCellWriter.cellLocation(table, row, column, this.location());
        JTextComponent textComponent = null;
        try {
            textComponent = this.activateEditorWithF2Key(table, row, column, cellLocation);
        }
        catch (ActionFailedException e) {
            textComponent = this.activateEditorWithDoubleClick(table, row, column, cellLocation);
        }
        this.cellEditor(JTableTextComponentEditorCellWriter.cellEditor(table, row, column));
        return (JTextComponent)Preconditions.checkNotNull((Object)textComponent);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent activateEditorWithF2Key(@Nonnull JTable table, int row, int column, @Nonnull Point cellLocation) {
        this.robot.click((Component)table, cellLocation);
        this.robot.pressAndReleaseKeys(113);
        return this.waitForEditorActivation(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent activateEditorWithDoubleClick(@Nonnull JTable table, int row, int column, @Nonnull Point cellLocation) {
        this.robot.click(table, cellLocation, MouseButton.LEFT_BUTTON, 2);
        return this.waitForEditorActivation(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent waitForEditorActivation(@Nonnull JTable table, int row, int column) {
        return this.waitForEditorActivation(table, row, column, JTextComponent.class);
    }
}

