/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import javax.swing.JSlider;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JSliderLocation;
import org.assertj.swing.driver.JSliderSetValueTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.GenericRange;
import org.assertj.swing.util.Pair;

@InternalApi
public class JSliderDriver
extends JComponentDriver {
    private final JSliderLocation location = new JSliderLocation();

    public JSliderDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void slideToMaximum(@Nonnull JSlider slider) {
        this.slide(slider, JSliderDriver.findSlideToMaximumInfo(slider, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findSlideToMaximumInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location) {
        Pair<Integer, GenericRange<Point>> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(slider);
                int value = slider.getMaximum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return Pair.of(value, fromAndTo);
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    public void slideToMinimum(@Nonnull JSlider slider) {
        this.slide(slider, JSliderDriver.findSlideToMinimumInfo(slider, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findSlideToMinimumInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location) {
        Pair<Integer, GenericRange<Point>> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(slider);
                int value = slider.getMinimum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return Pair.of(value, fromAndTo);
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    private void slide(@Nonnull JSlider slider, @Nonnull Pair<Integer, GenericRange<Point>> slideInfo) {
        this.slide(slider, (Integer)slideInfo.first, (GenericRange)Preconditions.checkNotNull(slideInfo.second));
    }

    @RunsInEDT
    public void slide(@Nonnull JSlider slider, int value) {
        GenericRange<Point> slideInfo = JSliderDriver.findSlideInfo(slider, this.location(), value);
        this.slide(slider, value, slideInfo);
    }

    @RunsInEDT
    private void slide(@Nonnull JSlider slider, int value, @Nonnull GenericRange<Point> fromAndTo) {
        this.moveMouseIgnoringAnyError(slider, fromAndTo.from());
        this.moveMouseIgnoringAnyError(slider, fromAndTo.to());
        JSliderSetValueTask.setValue(slider, value);
        this.robot.waitForIdle();
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findSlideInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location, final int value) {
        GenericRange<Point> result2 = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JSliderDriver.checkValueInBounds(slider, value);
                ComponentPreconditions.checkEnabledAndShowing(slider);
                return JSliderDriver.slideInfo(slider, location, value);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result2);
    }

    @RunsInCurrentThread
    private static void checkValueInBounds(@Nonnull JSlider slider, int value) {
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        if (value >= min && value <= max) {
            return;
        }
        String msg = String.format("Value <%d> is not within the JSlider bounds of <%d> and <%d>", value, min, max);
        throw new IllegalArgumentException(msg);
    }

    @RunsInCurrentThread
    private static GenericRange<Point> slideInfo(@Nonnull JSlider slider, JSliderLocation location, int value) {
        Point from = location.pointAt(slider, slider.getValue());
        Point to = location.pointAt(slider, value);
        return new GenericRange<Point>(from, to);
    }

    @Nonnull
    private JSliderLocation location() {
        return this.location;
    }
}

