/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.AbstractButtonArmedQuery;
import org.assertj.swing.driver.AbstractButtonSelectedQuery;
import org.assertj.swing.driver.AbstractButtonTextQuery;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.driver.TextDisplayDriver;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class AbstractButtonDriver
extends JComponentDriver
implements TextDisplayDriver<AbstractButton> {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String ARMED_PROPERTY = "armed";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull AbstractButton button, @Nullable String expected) {
        ((TextAssert)((Object)TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)))).isEqualOrMatches(expected);
    }

    @Override
    public void requireText(@Nonnull AbstractButton button, @Nonnull Pattern pattern) {
        ((TextAssert)((Object)TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)))).matches(pattern);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public String textOf(@Nonnull AbstractButton button) {
        return AbstractButtonTextQuery.textOf(button);
    }

    @RunsInEDT
    public void select(@Nonnull AbstractButton button) {
        if (AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    public void deselect(@Nonnull AbstractButton button) {
        if (!AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    private static boolean checkSelected(@Nonnull AbstractButton button) {
        Boolean result2 = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(button);
            return button.isSelected();
        });
        return (Boolean)Preconditions.checkNotNull((Object)result2);
    }

    @RunsInEDT
    public void requireSelected(@Nonnull AbstractButton button) {
        this.assertThatButtonIsSelected(button, true);
    }

    @RunsInEDT
    public void requireNotSelected(@Nonnull AbstractButton button) {
        this.assertThatButtonIsSelected(button, false);
    }

    @RunsInEDT
    private void assertThatButtonIsSelected(@Nonnull AbstractButton button, boolean selected) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)AbstractButtonSelectedQuery.isSelected(button)).as(AbstractButtonDriver.selectedProperty(button))).isEqualTo(selected);
    }

    @Nonnull
    @RunsInEDT
    private static Description selectedProperty(@Nonnull AbstractButton button) {
        return AbstractButtonDriver.propertyName(button, SELECTED_PROPERTY);
    }

    @RunsInEDT
    public void requireArmed(@Nonnull AbstractButton button) {
        this.assertThatButtonIsArmed(button, true);
    }

    @RunsInEDT
    public void requireNotArmed(@Nonnull AbstractButton button) {
        this.assertThatButtonIsArmed(button, false);
    }

    @RunsInEDT
    private void assertThatButtonIsArmed(@Nonnull AbstractButton button, boolean armed) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)AbstractButtonArmedQuery.isArmed(button)).as(AbstractButtonDriver.armedProperty(button))).isEqualTo(armed);
    }

    @Nonnull
    @RunsInEDT
    private static Description armedProperty(@Nonnull AbstractButton button) {
        return AbstractButtonDriver.propertyName(button, ARMED_PROPERTY);
    }
}

