/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.find.FindSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import icons.XpathIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.XPathAction;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.XPathProjectComponent;
import org.intellij.plugins.xpathView.eval.EvalExpressionDialog;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.ui.InputExpressionDialog;
import org.intellij.plugins.xpathView.util.CachedVariableContext;
import org.intellij.plugins.xpathView.util.HighlighterUtil;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.jaxen.JaxenException;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathSyntaxException;
import org.jaxen.saxpath.SAXPathException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathEvalAction
extends XPathAction {
    private static final Logger LOG = Logger.getInstance(XPathEvalAction.class);

    @Override
    protected void updateToolbar(AnActionEvent event) {
        super.updateToolbar(event);
        event.getPresentation().setIcon(XpathIcons.Xml);
    }

    @Override
    protected boolean isEnabledAt(XmlFile xmlFile, int offset) {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            XPathEvalAction.$$$reportNull$$$0(0);
        }
        if ((project = event.getProject()) == null) {
            LOG.debug("No project");
            return;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            FileEditorManager fem = FileEditorManager.getInstance((Project)project);
            editor = fem.getSelectedTextEditor();
        }
        if (editor == null) {
            LOG.debug("No editor");
            return;
        }
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = pdm.getPsiFile(editor.getDocument());
        if (!(psiFile instanceof XmlFile)) {
            LOG.debug("No XML-File: " + psiFile);
            return;
        }
        pdm.commitDocument(editor.getDocument());
        this.execute(editor);
    }

    private void execute(Editor editor) {
        InputExpressionDialog.Context input;
        Project project = editor.getProject();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        XmlElement contextNode = null;
        Config cfg = XPathAppComponent.getInstance().getConfig();
        do {
            Language dataLanguage;
            PsiFile templateDataFile;
            FileViewProvider fileViewProvider;
            RangeHighlighter contextHighlighter = null;
            if (cfg.isUseContextAtCursor() && (contextNode = MyPsiUtil.findContextNode(psiFile, editor)) != null) {
                contextHighlighter = HighlighterUtil.highlightNode(editor, (PsiElement)contextNode, cfg.getContextAttributes(), cfg);
            }
            if (contextNode == null && (contextNode = ((XmlFile)psiFile).getDocument()) == null && (fileViewProvider = psiFile.getViewProvider()) instanceof TemplateLanguageFileViewProvider && (templateDataFile = fileViewProvider.getPsi(dataLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage())) instanceof XmlFile) {
                contextNode = ((XmlFile)templateDataFile).getDocument();
            }
            input = XPathEvalAction.inputXPathExpression(project, contextNode);
            if (contextHighlighter != null) {
                contextHighlighter.dispose();
            }
            if (input == null) {
                return;
            }
            HighlighterUtil.clearHighlighters(editor);
        } while (contextNode != null && this.evaluateExpression(input, contextNode, editor, cfg));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateExpression(InputExpressionDialog.Context context, XmlElement contextNode, Editor editor, Config cfg) {
        Project project = editor.getProject();
        try {
            XPathSupport support = XPathSupport.getInstance();
            XPath xpath = support.createXPath((XmlFile)contextNode.getContainingFile(), context.input.expression, context.input.namespaces);
            xpath.setVariableContext((VariableContext)new CachedVariableContext(context.input.variables, xpath, contextNode));
            Object result = xpath.evaluate((Object)contextNode);
            LOG.debug("result = " + result);
            LOG.assertTrue(result != null, (Object)"null result?");
            if (result instanceof List) {
                List list = (List)result;
                if (!list.isEmpty()) {
                    if (cfg.HIGHLIGHT_RESULTS) {
                        XPathEvalAction.highlightResult(contextNode, editor, list);
                    }
                    if (cfg.SHOW_USAGE_VIEW) {
                        this.showUsageView(editor, xpath, contextNode, list);
                    }
                    if (cfg.SHOW_USAGE_VIEW) return false;
                    if (cfg.HIGHLIGHT_RESULTS) return false;
                    String s = StringUtil.pluralize((String)XPathBundle.message("dialog.message.match", new Object[0]), (int)list.size());
                    Messages.showInfoMessage((Project)project, (String)(XPathBundle.message("dialog.message.expression.produced", new Object[0]) + list.size() + " " + s), (String)XPathBundle.message("dialog.title.xpath.result", new Object[0]));
                    return false;
                }
                if (Messages.showOkCancelDialog((Project)project, (String)XPathBundle.message("dialog.message.sorry.your.expression.did.not.return.any.result", new Object[0]), (String)XPathBundle.message("dialog.title.xpath.result", new Object[0]), (String)XPathBundle.message("button.ok", new Object[0]), (String)XPathBundle.message("button.edit.expression", new Object[0]), (Icon)Messages.getInformationIcon()) == 0) return false;
                return true;
            }
            if (result instanceof String) {
                Messages.showMessageDialog((String)("'" + result + "'"), (String)XPathBundle.message("dialog.title.xpath.result.string", new Object[0]), (Icon)Messages.getInformationIcon());
                return false;
            }
            if (result instanceof Number) {
                String s = result.toString();
                Messages.showMessageDialog((String)s, (String)XPathBundle.message("dialog.title.xpath.result.number", new Object[0]), (Icon)Messages.getInformationIcon());
                return false;
            }
            if (result instanceof Boolean) {
                String s = result.toString();
                Messages.showMessageDialog((String)s, (String)XPathBundle.message("dialog.title.xpath.result.boolean", new Object[0]), (Icon)Messages.getInformationIcon());
                return false;
            }
            LOG.error("Unknown XPath result: " + result);
            return false;
        }
        catch (XPathSyntaxException e) {
            LOG.debug((Throwable)e);
            if (Messages.showOkCancelDialog((Project)project, (String)e.getMultilineMessage(), (String)XPathBundle.message("dialog.title.xpath.syntax.error", new Object[0]), (String)XPathBundle.message("button.edit.expression", new Object[0]), (String)XPathBundle.message("button.cancel", new Object[0]), (Icon)Messages.getErrorIcon()) != 0) return false;
            return true;
        }
        catch (SAXPathException e) {
            LOG.debug((Throwable)e);
            Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)XPathBundle.message("dialog.title.xpath.error", new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return false;
    }

    private void showUsageView(final Editor editor, XPath xPath, XmlElement contextNode, List<?> result) {
        Project project = editor.getProject();
        ArrayList _result = new ArrayList(result);
        Factory searcherFactory = () -> new MyUsageSearcher(_result, xPath, contextNode);
        MyUsageTarget usageTarget = new MyUsageTarget(xPath.toString(), contextNode);
        XPathEvalAction.showUsageView(project, usageTarget, (Factory<UsageSearcher>)searcherFactory, new EditExpressionAction(){
            final Config config = XPathAppComponent.getInstance().getConfig();

            @Override
            protected void execute() {
                XPathEvalAction.this.execute(editor);
            }
        });
    }

    public static void showUsageView(@NotNull Project project, MyUsageTarget usageTarget, Factory<UsageSearcher> searcherFactory, final EditExpressionAction editAction) {
        if (project == null) {
            XPathEvalAction.$$$reportNull$$$0(1);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTargetsNodeText(XPathBundle.message("list.item.xpath.expression", new Object[0]));
        presentation.setCodeUsages(false);
        presentation.setCodeUsagesString(XPathBundle.message("list.item.found.matches", new Object[0]));
        presentation.setNonCodeUsagesString(XPathBundle.message("list.item.result", new Object[0]));
        presentation.setUsagesString(XPathBundle.message("xpath.result", new Object[0]));
        ItemPresentation targetPresentation = usageTarget.getPresentation();
        if (targetPresentation != null) {
            presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)XPathBundle.message("tab.title.xpath", targetPresentation.getPresentableText()), (int)60, (int)0, (boolean)true));
        } else {
            presentation.setTabText("XPath");
        }
        presentation.setScopeText("XML Files");
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowPanelIfOnlyOneUsage(true);
        processPresentation.setShowNotFoundMessage(true);
        UsageTarget[] usageTargets = new UsageTarget[]{usageTarget};
        UsageViewManager.getInstance((Project)project).searchAndShowUsages(usageTargets, searcherFactory, processPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    2.$$$reportNull$$$0(0);
                }
                usageView.addButtonToLowerPane((Runnable)editAction, XPathBundle.message("button.edit.expression.with.mnemonic", new Object[0]));
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "org/intellij/plugins/xpathView/XPathEvalAction$2", "usageViewCreated"));
            }
        });
    }

    @Nullable
    private static InputExpressionDialog.Context inputXPathExpression(Project project, XmlElement contextNode) {
        XPathProjectComponent pc = XPathProjectComponent.getInstance(project);
        LOG.assertTrue(pc != null);
        HistoryElement[] history = pc.getHistory();
        EvalExpressionDialog dialog = new EvalExpressionDialog(project, XPathAppComponent.getInstance().getConfig(), history);
        if (!dialog.show(contextNode)) {
            LOG.debug("Input canceled");
            return null;
        }
        InputExpressionDialog.Context context = dialog.getContext();
        LOG.debug("expression = " + context.input.expression);
        pc.addHistory(context.input);
        return context;
    }

    private static void highlightResult(XmlElement contextNode, @NotNull Editor editor, List<?> list) {
        if (editor == null) {
            XPathEvalAction.$$$reportNull$$$0(2);
        }
        Config cfg = XPathAppComponent.getInstance().getConfig();
        int lowestOffset = Integer.MAX_VALUE;
        for (Object o : list) {
            LOG.assertTrue(o != null, (Object)"null element?");
            if (o instanceof PsiElement) {
                PsiElement element = (PsiElement)o;
                if (element.getContainingFile() == contextNode.getContainingFile()) {
                    lowestOffset = XPathEvalAction.highlightElement(editor, element, cfg, lowestOffset);
                }
            } else {
                LOG.info("Don't know what to do with " + o + " in a list context");
            }
            LOG.debug("o = " + o);
        }
        if (cfg.isScrollToFirst() && lowestOffset != Integer.MAX_VALUE) {
            editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(lowestOffset), ScrollType.MAKE_VISIBLE);
            editor.getCaretModel().moveToOffset(lowestOffset);
        }
        SwingUtilities.invokeLater(() -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(editor.getProject());
            statusBar.setInfo(XPathBundle.message("status.bar.text.xpath.choice.match.matches.found.press.escape.to.remove.highlighting", list.size(), list.size() == 1 ? 0 : 1));
        });
    }

    private static int highlightElement(Editor editor, PsiElement element, Config cfg, int offset) {
        RangeHighlighter highlighter = HighlighterUtil.highlightNode(editor, element, cfg.getAttributes(), cfg);
        HighlighterUtil.addHighlighter(editor, highlighter);
        return Math.min(highlighter.getStartOffset(), offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/xpathView/XPathEvalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showUsageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyUsageTarget
    implements UsageTarget {
        private final ItemPresentation myItemPresentation;
        private final XmlElement myContextNode;

        public MyUsageTarget(String expression, XmlElement contextNode) {
            this.myContextNode = contextNode;
            this.myItemPresentation = new PresentationData(expression, null, null, null);
        }

        public void findUsages() {
            throw new IllegalArgumentException();
        }

        public boolean isValid() {
            return this.myContextNode == null || this.myContextNode.isValid();
        }

        public String getName() {
            return "Expression";
        }

        public ItemPresentation getPresentation() {
            return this.myItemPresentation;
        }
    }

    public static abstract class EditExpressionAction
    implements Runnable {
        @Override
        public void run() {
            this.execute();
        }

        protected abstract void execute();
    }

    private static class MyUsageSearcher
    implements UsageSearcher {
        private final List<?> myResult;
        private final XPath myXPath;
        private final XmlElement myContextNode;

        MyUsageSearcher(List<?> result, XPath xPath, XmlElement contextNode) {
            this.myResult = result;
            this.myXPath = xPath;
            this.myContextNode = contextNode;
        }

        public void generate(@NotNull Processor<? super Usage> processor) {
            if (processor == null) {
                MyUsageSearcher.$$$reportNull$$$0(0);
            }
            Runnable runnable = () -> {
                List list;
                if (this.myResult.isEmpty()) {
                    try {
                        list = this.myXPath.selectNodes((Object)this.myContextNode);
                    }
                    catch (JaxenException e) {
                        LOG.debug((Throwable)e);
                        Messages.showMessageDialog((Project)this.myContextNode.getProject(), (String)e.getMessage(), (String)XPathBundle.message("dialog.title.xpath.error", new Object[0]), (Icon)Messages.getErrorIcon());
                        return;
                    }
                } else {
                    list = this.myResult;
                }
                int size = list.size();
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(XPathBundle.message("progress.text.collecting.matches", new Object[0]));
                list.sort((o1, o2) -> {
                    indicator.checkCanceled();
                    if (o1 instanceof PsiElement && o2 instanceof PsiElement) {
                        return ((PsiElement)o1).getTextRange().getStartOffset() - ((PsiElement)o2).getTextRange().getStartOffset();
                    }
                    return String.valueOf(o1).compareTo(String.valueOf(o2));
                });
                for (int i = 0; i < size; ++i) {
                    indicator.checkCanceled();
                    Object o = list.get(i);
                    if (o instanceof PsiElement) {
                        PsiElement element = (PsiElement)o;
                        processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo(element)));
                        indicator.setText2(element.getContainingFile().getName());
                    }
                    indicator.setFraction((double)i / (double)size);
                }
                list.clear();
            };
            ApplicationManager.getApplication().runReadAction(runnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/intellij/plugins/xpathView/XPathEvalAction$MyUsageSearcher", "generate"));
        }
    }
}

