/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.utils;

import com.intellij.clouds.docker.gateway.utils.RemotePathUtilsHelper;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.progress.TtySinkKt;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0010H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"pathString", "", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "getPathString", "(Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;)Ljava/lang/String;", "copyWithProgress", "", "", "prefix", "pipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "target", "Ljava/io/OutputStream;", "isDevcontainerFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/clouds/docker/gateway/utils/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class UtilsKt {
    public static final boolean isDevcontainerFile(@NotNull PsiFile $this$isDevcontainerFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isDevcontainerFile, (String)"<this>");
        VirtualFile virtualFile = $this$isDevcontainerFile.getVirtualFile();
        return virtualFile != null ? UtilsKt.isDevcontainerFile(virtualFile) : false;
    }

    public static final boolean isDevcontainerFile(@NotNull VirtualFile $this$isDevcontainerFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isDevcontainerFile, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isDevcontainerFile.getName(), (Object)".devcontainer.json") || Intrinsics.areEqual((Object)$this$isDevcontainerFile.getName(), (Object)"devcontainer.json");
    }

    @NotNull
    public static final String getPathString(@NotNull ShellArgument.RemotePath $this$pathString) {
        Intrinsics.checkNotNullParameter((Object)$this$pathString, (String)"<this>");
        String string = RemotePathUtilsHelper.toString($this$pathString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyWithProgress(@NotNull byte[] $this$copyWithProgress, @Nls @NotNull String prefix, @NotNull DockerTerminalPipe.WithTty pipe, @NotNull OutputStream target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyWithProgress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int totalSize = $this$copyWithProgress.length;
        Closeable closeable = new ByteArrayInputStream($this$copyWithProgress);
        Throwable throwable = null;
        try {
            ByteArrayInputStream inputStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            long bytesTransferred = 0L;
            int bytesRead = 0;
            boolean needClearPrevLine = false;
            while (true) {
                int n;
                int it = n = inputStream.read(buffer);
                boolean bl2 = false;
                bytesRead = it;
                if (n < 0) break;
                target.write(buffer, 0, bytesRead);
                bytesTransferred += (long)bytesRead;
                target.flush();
                if (needClearPrevLine) {
                    TtySinkKt.ttyClearPreviousLine((TtySink)pipe.asTtySink());
                }
                long percent = bytesTransferred * (long)100 / (long)totalSize;
                String text2 = prefix + " " + percent + "% (" + DockerProgressDetailsFormat.Companion.humanSizeBytes((double)bytesTransferred) + "/" + DockerProgressDetailsFormat.Companion.humanSizeBytes((double)totalSize) + ")";
                pipe.println(text2);
                needClearPrevLine = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

