/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenFileHelper;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import com.jetbrains.cidr.meson.MesonLog;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.wizard.OpenProjectSpec;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/meson/wizard/MesonProjectOpenProcessor;", "Lcom/jetbrains/cidr/CidrProjectOpenProcessor;", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "Companion", "intellij.clion.meson"})
public final class MesonProjectOpenProcessor
extends CidrProjectOpenProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<OpenProjectSpec> DATA_KEY;
    @NotNull
    private static final ProjectOpenFileHelper<OpenProjectSpec> helper;

    public MesonProjectOpenProcessor() {
        super((ProjectOpenHelper)helper);
    }

    @NotNull
    public String getName() {
        return MesonBundle.message("meson", new Object[0]);
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = helper.findSupportedSubFile(file);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile mesonFile = virtualFile;
        return super.canOpenProject(mesonFile);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile virtualFile2 = helper.findSupportedSubFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile mesonFile = virtualFile2;
        MesonLog.INSTANCE.getLOG().assertTrue(!mesonFile.isDirectory());
        Project existingProject = helper.openExistingProjectInDirectory(mesonFile, projectToClose, forceOpenInNewFrame);
        if (existingProject != null) {
            return existingProject;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)mesonFile);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        OpenProjectSpec spec = new OpenProjectSpec(file);
        Project project = helper.openProject(mesonFile, projectToClose, forceOpenInNewFrame, (Object)spec);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        CidrExternalUsageUtil.INSTANCE.logProjectCreated(MesonUtilKt.getID(), project2);
        VirtualFile externalProjectPath = mesonFile.getParent();
        Intrinsics.checkNotNull((Object)externalProjectPath);
        MesonUtil.INSTANCE.linkMesonProject(project2, externalProjectPath);
        return project2;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Project;
    }

    static {
        Key key = Key.create((String)"MESON_TO_OPEN_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DATA_KEY = key;
        helper = new ProjectOpenFileHelper(CollectionsKt.listOf((Object)"meson.build"), DATA_KEY);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/meson/wizard/MesonProjectOpenProcessor$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/meson/wizard/OpenProjectSpec;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "helper", "Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "getHelper", "()Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "intellij.clion.meson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectOpenFileHelper<OpenProjectSpec> getHelper() {
            return helper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

