/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.meson.MesonWorkspace;
import com.jetbrains.cidr.meson.project.MesonWorkspaceInitializationUtilKt;
import com.jetbrains.cidr.meson.settings.MesonSettingsAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J$\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\u001c\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0016\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/meson/settings/MesonAutoReloadSettingsListener;", "Lcom/jetbrains/cidr/meson/settings/MesonSettingsAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onBuildDirectoryChanged", "", "oldBuildDirectory", "", "newBuildDirectory", "onMesonExecutableChanged", "oldMesonExecutable", "newMesonExecutable", "onSetupOptionsChanged", "oldMesonSetupOptions", "", "newMesonSetupOptions", "onToolchainChanged", "oldToolchainName", "newToolchainName", "scheduleReload", "intellij.clion.meson"})
public final class MesonAutoReloadSettingsListener
extends MesonSettingsAdapter {
    @NotNull
    private final Project project;

    public MesonAutoReloadSettingsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void onToolchainChanged(@Nullable String oldToolchainName, @Nullable String newToolchainName) {
        this.scheduleReload();
    }

    @Override
    public void onSetupOptionsChanged(@NotNull List<String> oldMesonSetupOptions, @NotNull List<String> newMesonSetupOptions) {
        Intrinsics.checkNotNullParameter(oldMesonSetupOptions, (String)"oldMesonSetupOptions");
        Intrinsics.checkNotNullParameter(newMesonSetupOptions, (String)"newMesonSetupOptions");
        this.scheduleReload();
    }

    @Override
    public void onBuildDirectoryChanged(@NotNull String oldBuildDirectory, @NotNull String newBuildDirectory) {
        Intrinsics.checkNotNullParameter((Object)oldBuildDirectory, (String)"oldBuildDirectory");
        Intrinsics.checkNotNullParameter((Object)newBuildDirectory, (String)"newBuildDirectory");
        this.scheduleReload();
    }

    @Override
    public void onMesonExecutableChanged(@NotNull String oldMesonExecutable, @NotNull String newMesonExecutable) {
        Intrinsics.checkNotNullParameter((Object)oldMesonExecutable, (String)"oldMesonExecutable");
        Intrinsics.checkNotNullParameter((Object)newMesonExecutable, (String)"newMesonExecutable");
        this.scheduleReload();
    }

    private final void scheduleReload() {
        MesonWorkspace workspace = MesonWorkspace.Companion.getInstance(this.project);
        MesonWorkspaceInitializationUtilKt.runAfterMesonInitialized(this.project, (Disposable)workspace, (Function0<Unit>)((Function0)new Function0<Unit>(workspace){
            final /* synthetic */ MesonWorkspace $workspace;
            {
                this.$workspace = $workspace;
                super(0);
            }

            public final void invoke() {
                this.$workspace.scheduleReload();
            }
        }));
    }
}

