/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.meson.project.resolver.MesonRemoteUtilKt;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.system.RemoteProjectUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonRemoteUtil;", "", "()V", "isSyncNeeded", "", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "syncBuildToLocal", "", "localBuildDir", "Ljava/nio/file/Path;", "syncProjectToRemote", "project", "Lcom/intellij/openapi/project/Project;", "localProjectDir", "intellij.clion.meson"})
public final class MesonRemoteUtil {
    @NotNull
    public static final MesonRemoteUtil INSTANCE = new MesonRemoteUtil();

    private MesonRemoteUtil() {
    }

    @JvmStatic
    public static final boolean isSyncNeeded(@NotNull CPPEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return environment.getHostMachine().isRemote() && !environment.getHostMachine().isWsl();
    }

    @JvmStatic
    @RequiresBackgroundThread
    public static final void syncProjectToRemote(@NotNull Project project, @NotNull Path localProjectDir, @NotNull CPPEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localProjectDir, (String)"localProjectDir");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!MesonRemoteUtil.isSyncNeeded(environment)) {
            return;
        }
        MesonRemoteUtilKt.access$getLOG$p().info("Remote copying sync project to remote from local project directory \"" + localProjectDir + "\"");
        List excludedDirs = new ArrayList();
        if (Registry.is((String)"clion.remote.mark.dir.excluded")) {
            for (File root : (Collection)ReadAction.compute(() -> MesonRemoteUtil.syncProjectToRemote$lambda$0(project))) {
                String string = root.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                excludedDirs.add(string);
            }
        }
        RemoteProjectUtil.syncToHosts((List)CollectionsKt.listOf((Object)environment), (Project)project, (String)((Object)localProjectDir).toString(), (List)excludedDirs);
    }

    @JvmStatic
    @RequiresBackgroundThread
    public static final void syncBuildToLocal(@NotNull Path localBuildDir, @NotNull CPPEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)localBuildDir, (String)"localBuildDir");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!MesonRemoteUtil.isSyncNeeded(environment)) {
            return;
        }
        MesonRemoteUtilKt.access$getLOG$p().info("Remote copying sync build directory to local build dir \"" + localBuildDir + "\"");
        Path path = localBuildDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        Path absoluteLocalBuildDir = path;
        Path path2 = environment.getHostMachine().getPath(((Object)absoluteLocalBuildDir).toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        Path remoteBuildDir = path2;
        environment.getHostMachine().resolvePath(remoteBuildDir);
    }

    private static final Collection syncProjectToRemote$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return CidrRootConfiguration.Companion.getInstance($project).getExcludeRoots();
    }
}

