/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.jetbrains.cidr.execution.build.issue.EnvironmentIssue;
import com.jetbrains.cidr.meson.project.resolver.CancellationExceptionIssue;
import com.jetbrains.cidr.meson.project.resolver.MesonEnvironmentProblemException;
import com.jetbrains.cidr.meson.project.resolver.MesonEventData;
import com.jetbrains.cidr.meson.project.resolver.MesonNotFoundException;
import com.jetbrains.cidr.meson.project.resolver.MesonNotFoundIssue;
import com.jetbrains.cidr.meson.project.resolver.MesonResolverIssuesKt;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/ExceptionIssue;", "Lcom/intellij/build/issue/BuildIssue;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "currentEvent", "Lcom/jetbrains/cidr/meson/project/resolver/MesonEventData;", "(Ljava/lang/Exception;Lcom/jetbrains/cidr/meson/project/resolver/MesonEventData;)V", "description", "", "getDescription", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "title", "getTitle", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "Companion", "intellij.clion.meson"})
public class ExceptionIssue
implements BuildIssue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Exception ex;
    @NotNull
    private final MesonEventData currentEvent;
    @NotNull
    private final String description;
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;

    public ExceptionIssue(@NotNull Exception ex, @NotNull MesonEventData currentEvent) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)currentEvent, (String)"currentEvent");
        this.ex = ex;
        this.currentEvent = currentEvent;
        this.description = "";
        this.quickFixes = CollectionsKt.emptyList();
    }

    @NotNull
    public String getTitle() {
        String message = this.ex.getMessage();
        if (message == null) {
            MesonResolverIssuesKt.access$getLOG$p().warn("Exception without an error message", (Throwable)this.ex);
            String string = this.currentEvent.getStartEvent().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }
        return message;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(ex=" + this.ex + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/ExceptionIssue$Companion;", "", "()V", "createFrom", "Lcom/intellij/build/issue/BuildIssue;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "currentEvent", "Lcom/jetbrains/cidr/meson/project/resolver/MesonEventData;", "intellij.clion.meson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuildIssue createFrom(@NotNull Exception ex, @NotNull MesonEventData currentEvent) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            Intrinsics.checkNotNullParameter((Object)currentEvent, (String)"currentEvent");
            Exception exception = ex;
            return exception instanceof CancellationException ? (BuildIssue)new CancellationExceptionIssue((CancellationException)ex, currentEvent) : (exception instanceof MesonNotFoundException ? (BuildIssue)new MesonNotFoundIssue((MesonNotFoundException)ex, currentEvent) : (exception instanceof MesonEnvironmentProblemException ? (BuildIssue)new EnvironmentIssue((EnvironmentProblems.Problem)((MesonEnvironmentProblemException)ex).getEnvironmentProblems().getProblems().get(0)) : (BuildIssue)new ExceptionIssue(ex, currentEvent)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

