/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.connection;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.platform.dap.connection.DebugAdapterHandle;
import com.intellij.platform.dap.connection.LocalDebugAdapterProcessKt;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/dap/connection/DebugAdapterProcessHandleImpl;", "Lcom/intellij/platform/dap/connection/DebugAdapterHandle;", "processHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "(Lcom/intellij/execution/process/OSProcessHandler;)V", "input", "Ljava/io/InputStream;", "getInput", "()Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "getOutput", "()Ljava/io/OutputStream;", "getProcessHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "processListener", "Lcom/intellij/platform/dap/connection/DebugAdapterProcessHandleImpl$DebugAdapterProcessListener;", "disconnect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DebugAdapterProcessListener", "intellij.platform.dap"})
public final class DebugAdapterProcessHandleImpl
implements DebugAdapterHandle {
    @NotNull
    private final OSProcessHandler processHandler;
    @NotNull
    private final DebugAdapterProcessListener processListener;

    public DebugAdapterProcessHandleImpl(@NotNull OSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.processHandler = processHandler;
        this.processListener = new DebugAdapterProcessListener();
        this.processHandler.addProcessListener((ProcessListener)this.processListener);
        this.processHandler.startNotify();
    }

    @NotNull
    public final OSProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    @Override
    @NotNull
    public InputStream getInput() {
        return this.processListener.getPipedInputStream();
    }

    @Override
    @NotNull
    public OutputStream getOutput() {
        OutputStream outputStream = this.processHandler.getProcessInput();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
        return outputStream;
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        if (!this.processHandler.isProcessTerminating() && !this.processHandler.isProcessTerminated()) {
            LocalDebugAdapterProcessKt.access$getLOG$p().info("Stopping debug adapter process: " + this.processHandler.getCommandLine());
            ExecutionManagerImpl.Companion.stopProcess((ProcessHandler)this.processHandler);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/dap/connection/DebugAdapterProcessHandleImpl$DebugAdapterProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "()V", "outputStreamWriter", "Ljava/io/OutputStreamWriter;", "pipedInputStream", "Ljava/io/PipedInputStream;", "getPipedInputStream", "()Ljava/io/PipedInputStream;", "pipedOutputStream", "Ljava/io/PipedOutputStream;", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.dap"})
    @SourceDebugExtension(value={"SMAP\nLocalDebugAdapterProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDebugAdapterProcess.kt\ncom/intellij/platform/dap/connection/DebugAdapterProcessHandleImpl$DebugAdapterProcessListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n23#2:80\n*S KotlinDebug\n*F\n+ 1 LocalDebugAdapterProcess.kt\ncom/intellij/platform/dap/connection/DebugAdapterProcessHandleImpl$DebugAdapterProcessListener\n*L\n75#1:80\n*E\n"})
    private static final class DebugAdapterProcessListener
    implements ProcessListener {
        @NotNull
        private final PipedOutputStream pipedOutputStream = new PipedOutputStream();
        @NotNull
        private final OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.pipedOutputStream, StandardCharsets.UTF_8);
        @NotNull
        private final PipedInputStream pipedInputStream = new PipedInputStream(this.pipedOutputStream);

        @NotNull
        public final PipedInputStream getPipedInputStream() {
            return this.pipedInputStream;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            if (ProcessOutputType.isStdout(outputType)) {
                try {
                    this.outputStreamWriter.write(event.getText());
                    this.outputStreamWriter.flush();
                }
                catch (IOException e) {
                    ExecutionManagerImpl.Companion.stopProcess(event.getProcessHandler());
                }
            } else if (ProcessOutputType.isStderr(outputType)) {
                Logger logger = LocalDebugAdapterProcessKt.access$getLOG$p();
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                logger.info("STDERR: " + ((Object)StringsKt.trimEnd((CharSequence)string)).toString());
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DebugAdapterProcessListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DebugAdapterProcessListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Closeable[] closeableArray = new Closeable[]{this.outputStreamWriter, this.pipedOutputStream};
            IOUtil.closeSafe((Logger)logger, (Closeable[])closeableArray);
            super.processTerminated(event);
        }
    }
}

