/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.detectors;

import com.jetbrains.cidr.cpp.io.CPPLocalPathFactory;
import com.jetbrains.cidr.cpp.makefile.io.MkPathUtils;
import com.jetbrains.cidr.cpp.makefile.io.file.MkPath;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.api.MkAbstractBuildSystemDetector;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.detectors.MkAutotoolsDetector;
import com.jetbrains.cidr.cpp.makefile.util.command.MkParsedArg;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00070\u0004\u00a2\u0006\u0002\b\u001b2\u0006\u0010!\u001a\u00020\"H\u0017R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u00060\bj\u0002`\rX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\f\u0012\b\u0012\u00060\bj\u0002`\r0\u0007X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u000bR\u001e\u0010\u0018\u001a\f\u0012\b\u0012\u00060\bj\u0002`\r0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0019\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/detectors/MkAutotoolsDetector;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/api/MkAbstractBuildSystemDetector;", "()V", "MAKEFILE_AM", "", "MAKEFILE_IN", "buildTargets", "", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArg;", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArgs;", "getBuildTargets", "()Ljava/util/List;", "defaultBuildDirectory", "Lcom/jetbrains/cidr/cpp/makefile/io/MkEnvPath;", "getDefaultBuildDirectory-fR0g1-M", "()Ljava/lang/String;", "Ljava/lang/String;", "excludeBuildDirectory", "", "getExcludeBuildDirectory", "()Z", "extraExcludedPaths", "getExtraExcludedPaths$annotations", "getExtraExcludedPaths", "makefilePrototypes", "getMakefilePrototypes", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "isApplicableTo", "projectDirectory", "Lcom/jetbrains/cidr/cpp/makefile/io/file/MkPath;", "preConfigureCommands", "localProjectDirectory", "Ljava/nio/file/Path;", "Companion", "intellij.clion.makefile"})
public final class MkAutotoolsDetector
extends MkAbstractBuildSystemDetector {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Language(value="sh")
    @NotNull
    private final String MAKEFILE_AM = MkParsedArg.toString-impl(this.getMakefile-fR0g1-M()) + ".am";
    @Language(value="sh")
    @NotNull
    private final String MAKEFILE_IN = MkParsedArg.toString-impl(this.getMakefile-fR0g1-M()) + ".in";
    @NotNull
    private final List<MkParsedArg> makefilePrototypes;
    @NotNull
    private final String defaultBuildDirectory;
    private final boolean excludeBuildDirectory;
    @NotNull
    private final List<MkParsedArg> extraExcludedPaths;
    @NotNull
    private final List<MkParsedArg> buildTargets;
    @NotNull
    private final String name;
    @Language(value="sh")
    @NotNull
    private static final String AUTORECONF = "autoreconf";
    @Language(value="sh")
    @NotNull
    private static final String CONFIGURE = "configure";
    @Language(value="sh")
    @NotNull
    private static final String CONFIGURE_AC = "configure.ac";
    @Language(value="sh")
    @NotNull
    private static final String CONFIGURE_IN = "configure.in";

    public MkAutotoolsDetector() {
        Object[] objectArray = new String[]{CONFIGURE, CONFIGURE_AC, CONFIGURE_IN, this.MAKEFILE_AM, this.MAKEFILE_IN};
        this.makefilePrototypes = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)makefilePrototypes.1.INSTANCE));
        this.defaultBuildDirectory = MkParsedArg.constructor-impl("build");
        this.excludeBuildDirectory = true;
        objectArray = new String[]{"autom4te.cache", "config.h.in~", ".deps", MkParsedArg.toString-impl(this.getMakefile-fR0g1-M()), "config.h", "config.log", "config.status", "libtool", "stamp-h1"};
        this.extraExcludedPaths = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)extraExcludedPaths.1.INSTANCE));
        this.buildTargets = CollectionsKt.listOf((Object)MkParsedArg.box-impl(MkParsedArg.constructor-impl("check")));
        this.name = "GNU Autotools";
    }

    @Override
    @NotNull
    public List<MkParsedArg> getMakefilePrototypes() {
        return this.makefilePrototypes;
    }

    @Override
    @NotNull
    public String getDefaultBuildDirectory-fR0g1-M() {
        return this.defaultBuildDirectory;
    }

    @Override
    public boolean getExcludeBuildDirectory() {
        return this.excludeBuildDirectory;
    }

    @Override
    @NotNull
    public List<MkParsedArg> getExtraExcludedPaths() {
        return this.extraExcludedPaths;
    }

    public static /* synthetic */ void getExtraExcludedPaths$annotations() {
    }

    @Override
    @Language(value="sh")
    @NotNull
    public String preConfigureCommands(@NotNull Path localProjectDirectory) {
        Intrinsics.checkNotNullParameter((Object)localProjectDirectory, (String)"localProjectDirectory");
        Path localBuildDirectory = localProjectDirectory.resolve(this.getDefaultBuildDirectory-fR0g1-M()).normalize();
        Intrinsics.checkNotNull((Object)localBuildDirectory);
        Path relativeProjectDirectory = MkPathUtils.isSameFileAs(localProjectDirectory, localBuildDirectory) ? CPPLocalPathFactory.INSTANCE.getPath(".", new String[0]) : PathsKt.relativeToOrSelf((Path)localProjectDirectory, (Path)localBuildDirectory);
        String projectDirectory = "${PROJECT_DIR:-" + relativeProjectDirectory + "}";
        return StringsKt.trimIndent((String)("\n      #!/bin/sh\n      #\n      # GNU Autotools template, feel free to customize.\n      #\n      which autoreconf >/dev/null && autoreconf --install --force --verbose \"" + projectDirectory + "\" 2>&1; /bin/sh \"" + projectDirectory + "/configure\"\n    "));
    }

    @Override
    @NotNull
    public List<MkParsedArg> getBuildTargets() {
        return this.buildTargets;
    }

    @Override
    public boolean isApplicableTo(@NotNull MkPath projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        MkPath mkPath = projectDirectory.findChild(this.MAKEFILE_AM);
        boolean makefileAmExists = mkPath != null ? mkPath.isRegularFile() : false;
        MkPath mkPath2 = projectDirectory.findChild(this.MAKEFILE_IN);
        boolean makefileInExists = mkPath2 != null ? mkPath2.isRegularFile() : false;
        MkPath mkPath3 = projectDirectory.findChild(CONFIGURE_AC);
        boolean configureAcExists = mkPath3 != null ? mkPath3.isRegularFile() : false;
        MkPath mkPath4 = projectDirectory.findChild(CONFIGURE_IN);
        boolean configureInExists = mkPath4 != null ? mkPath4.isRegularFile() : false;
        return (makefileAmExists || makefileInExists) && configureAcExists ^ configureInExists && super.isApplicableTo(projectDirectory);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/detectors/MkAutotoolsDetector$Companion;", "", "()V", "AUTORECONF", "", "CONFIGURE", "CONFIGURE_AC", "CONFIGURE_IN", "intellij.clion.makefile"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

