/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.cpp.makefile.MakefileBundle;
import com.jetbrains.cidr.cpp.makefile.MakefileUtil;
import com.jetbrains.cidr.cpp.makefile.MakefileWorkspace;
import com.jetbrains.cidr.cpp.makefile.execution.build.MakefileBuildTarget;
import com.jetbrains.cidr.cpp.makefile.execution.build.MakefileBuildTargetsManager;
import com.jetbrains.cidr.cpp.makefile.settings.MakefileLocalSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="MakefileWorkspace")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0017J8\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\r\u0010\u001b\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001cH\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/MakefileWorkspace;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/WorkspaceWithEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "targets", "", "Lcom/jetbrains/cidr/cpp/makefile/execution/build/MakefileBuildTarget;", "getTargets", "()Ljava/util/List;", "collectExcludeRoots", "Ljava/io/File;", "contentRoot", "createEnvironment", "toolchainNameOrNullForDefault", "", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "getClientKey", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.clion.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileWorkspace.kt\ncom/jetbrains/cidr/cpp/makefile/MakefileWorkspace\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,150:1\n31#2,2:151\n*S KotlinDebug\n*F\n+ 1 MakefileWorkspace.kt\ncom/jetbrains/cidr/cpp/makefile/MakefileWorkspace\n*L\n74#1:151,2\n*E\n"})
public final class MakefileWorkspace
extends ExternalWorkspace
implements WorkspaceWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MakefileWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getClientKey() {
        String string = MakefileUtil.ID.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @Nullable
    public CPPEnvironment createEnvironment(@Nullable Project project, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        return CPPToolchains.createCPPEnvironment((Project)project, (File)this.getProjectPath().toFile(), (String)toolchainNameOrNullForDefault, (EnvironmentProblems)problems, (boolean)checkIfFunctional, (Runnable)onMissingToolchain);
    }

    @NotNull
    public final CPPEnvironment createEnvironment(@Nullable String toolchainNameOrNullForDefault) throws ExecutionException {
        CPPEnvironment cPPEnvironment;
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.myProject, toolchainNameOrNullForDefault, environmentProblems, false, null);
        if (environmentProblems.hasProblems() || environment == null) {
            environmentProblems.throwAsExecutionException();
            Unit unit = Unit.INSTANCE;
            Void void_ = unit instanceof Void ? (Void)unit : null;
            if (void_ == null) {
                throw new ExecutionException(MakefileBundle.message("error.no.environment", new Object[0]));
            }
            cPPEnvironment = (CPPEnvironment)void_;
        } else {
            cPPEnvironment = environment;
        }
        return cPPEnvironment;
    }

    @NotNull
    public final List<MakefileBuildTarget> getTargets() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MakefileBuildTargetsManager> serviceClass$iv = MakefileBuildTargetsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((MakefileBuildTargetsManager)object).getTargets();
    }

    @NotNull
    public final CPPEnvironment getEnvironment() throws ExecutionException {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        MakefileLocalSettings localSettings = MakefileLocalSettings.Companion.getInstance(project);
        return this.createEnvironment(localSettings.getToolchainName());
    }

    @RequiresReadLock
    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot) throws IOException {
        List list;
        if (this.isInitialized()) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)MakefileUtil.linkedProjectSettings(project)), (Function1)collectExcludeRoots.1.INSTANCE)), (Function1)collectExcludeRoots.2.INSTANCE));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        List list;
        try {
            list = CollectionsKt.listOf((Object)this.getEnvironment());
        }
        catch (ExecutionException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final MakefileWorkspace getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/MakefileWorkspace$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/cpp/makefile/MakefileWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.makefile"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MakefileWorkspace getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(MakefileWorkspace.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (MakefileWorkspace)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

