/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.doctest;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestBundle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CidrDoctestTestLinker {
    List<String> myEscapedPathParts;
    @NonNls
    public static final String DUPLICATE_TAIL = "[cidr#reopen]";
    @NonNls
    public static final String TEMPLATE_PARAM_SEPARATOR = "<";
    @NonNls
    public static final String TEMPLATE_TEXT_SUFFIX = "<*";

    @Contract(pure=true)
    private CidrDoctestTestLinker() {
    }

    @NotNull
    public String getPatternForCommandLine() {
        if (this.myEscapedPathParts.size() == 1) {
            String string = this.myEscapedPathParts.get(0);
            if (string == null) {
                CidrDoctestTestLinker.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "[" + StringUtil.join(this.myEscapedPathParts, (String)"][") + "]";
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isTest() {
        return this.myEscapedPathParts.size() > 1 && !this.myEscapedPathParts.get(1).endsWith(TEMPLATE_TEXT_SUFFIX);
    }

    public static String normalizePattern(@NotNull String patternForCommandLine) {
        if (patternForCommandLine == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(2);
        }
        return patternForCommandLine;
    }

    @NotNull
    public String getFindPath() {
        StringBuilder path = new StringBuilder();
        if (this.myEscapedPathParts.size() == 1) {
            path.append('[').append(this.myEscapedPathParts.get(0)).append(']');
        } else if (this.myEscapedPathParts.size() > 1) {
            path.append("[][").append(this.myEscapedPathParts.get(1)).append(']');
        }
        String string = path.toString();
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<String> getUnescapedPathParts() {
        List list = ContainerUtil.map(this.myEscapedPathParts, StringUtil::unescapeStringCharacters);
        if (list == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public String getConfigurationName() {
        String string = StringUtil.unescapeStringCharacters((String)this.myEscapedPathParts.get(this.myEscapedPathParts.size() - 1));
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static CidrDoctestTestLinker create(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(6);
        }
        CidrDoctestTestLinker linker = new CidrDoctestTestLinker();
        linker.myEscapedPathParts = CidrDoctestTestLinker.splitLocationPathToEscapedParts(locationTestPath.trim());
        CidrDoctestTestLinker cidrDoctestTestLinker = linker;
        if (cidrDoctestTestLinker == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(7);
        }
        return cidrDoctestTestLinker;
    }

    @NotNull
    static List<String> splitLocationPathToEscapedParts(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(8);
        }
        if (CidrDoctestTestLinker.isWrapped(locationTestPath)) {
            while (locationTestPath.endsWith(DUPLICATE_TAIL)) {
                locationTestPath = locationTestPath.substring(0, locationTestPath.length() - DUPLICATE_TAIL.length());
            }
            List<String> list = Arrays.asList(locationTestPath.substring(1, locationTestPath.length() - 1).split("(?<!\\\\)]\\[", -1));
            if (list == null) {
                CidrDoctestTestLinker.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Collections.singletonList(locationTestPath);
        if (list == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static String getLocationWrapperIfNeed(@NotNull String testPath) {
        if (testPath == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(11);
        }
        if (CidrDoctestTestLinker.isWrapped(testPath)) {
            String string = testPath;
            if (string == null) {
                CidrDoctestTestLinker.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = "[" + CidrDoctestTestLinker.escapeCommandChars(testPath) + "]";
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isWrapped(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(14);
        }
        return locationTestPath.startsWith("[") && locationTestPath.endsWith("]");
    }

    @NotNull
    public static String getNoName() {
        String string = CidrDoctestBundle.message("doctest.test.noname", new Object[0]);
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCommandChars(@NotNull String nameFromCode) {
        if (nameFromCode == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(16);
        }
        String string = StringUtil.escapeChars((String)nameFromCode, (char[])new char[]{',', '[', ']'});
        if (string == null) {
            CidrDoctestTestLinker.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 6, 8, 11, 14, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestLinker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternForCommandLine";
                break;
            }
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationTestPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFromCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternForCommandLine";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestLinker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnescapedPathParts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLocationPathToEscapedParts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationWrapperIfNeed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCommandChars";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizePattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "splitLocationPathToEscapedParts";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocationWrapperIfNeed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWrapped";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "escapeCommandChars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 6, 8, 11, 14, 16 -> new IllegalArgumentException(string);
        };
    }
}

