/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.ui.projectStatus;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.external.system.project.ui.ExternalProjectStatusAndFixesProviderBase;
import com.jetbrains.cidr.cpp.external.system.project.ui.SelectAndLoadProjectActionBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/ui/projectStatus/CompDBProjectStatusAndFixesProvider;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase;", "()V", "createLoadAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSelectAndLoadAction", "rootDirectory", "isBuildFile", "", "file", "LoadCompDBAction", "SelectAndLoadCompDBAction", "intellij.clion.compdb"})
public final class CompDBProjectStatusAndFixesProvider
extends ExternalProjectStatusAndFixesProviderBase {
    public boolean isBuildFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CompDBUtil.INSTANCE.isCompDBFile(file);
    }

    @NotNull
    public AnAction createLoadAction(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return new LoadCompDBAction(project, buildFile);
    }

    @NotNull
    public AnAction createSelectAndLoadAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        return (AnAction)new SelectAndLoadCompDBAction(project, rootDirectory);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/ui/projectStatus/CompDBProjectStatusAndFixesProvider$LoadCompDBAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "compdbFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.compdb"})
    private static final class LoadCompDBAction
    extends AnAction {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile compdbFile;

        public LoadCompDBAction(@NotNull Project project, @NotNull VirtualFile compdbFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)compdbFile, (String)"compdbFile");
            super(CompDBBundle.message("action.CompDB.LoadMakefileProject.text", new Object[0]));
            this.project = project;
            this.compdbFile = compdbFile;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile virtualFile = this.compdbFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            CompDBUtil.INSTANCE.linkCompDBProject(this.project, virtualFile);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/ui/projectStatus/CompDBProjectStatusAndFixesProvider$SelectAndLoadCompDBAction;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/SelectAndLoadProjectActionBase;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "isBuildFile", "", "file", "linkProject", "", "intellij.clion.compdb"})
    private static final class SelectAndLoadCompDBAction
    extends SelectAndLoadProjectActionBase {
        public SelectAndLoadCompDBAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            String string = CompDBBundle.message("project.status.action.select", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(project, rootDirectory, string);
        }

        public boolean isBuildFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return CompDBUtil.INSTANCE.isCompDBFile(file);
        }

        public void linkProject(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            CompDBUtil.INSTANCE.linkCompDBProject(project, rootDirectory);
        }
    }
}

