/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.project.CompDBLoggingListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/project/CompDBLoggingListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "()V", "onCancel", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "workingDir", "", "onStatusChange", "event", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent;", "onSuccess", "Companion", "intellij.clion.compdb"})
public final class CompDBLoggingListener
implements ExternalSystemTaskNotificationListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void onStart(@NotNull ExternalSystemTaskId id, @Nullable String workingDir) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (CompDBLoggingListener.Companion.applicableTaskId(id)) {
            CompDBLog.INSTANCE.getLOG().debug("Task " + id + " started in working directory: " + workingDir);
        }
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!CompDBLog.INSTANCE.getLOG().isDebugEnabled()) break block5;
                ExternalSystemTaskId externalSystemTaskId = event.getId();
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
                if (CompDBLoggingListener.Companion.applicableTaskId(externalSystemTaskId) && event instanceof ExternalSystemTaskExecutionEvent) break block6;
            }
            return;
        }
        ExternalSystemProgressEvent externalSystemProgressEvent = ((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemProgressEvent, (String)"getProgressEvent(...)");
        ExternalSystemProgressEvent progressEvent = externalSystemProgressEvent;
        if (!(progressEvent instanceof ExternalSystemFinishEvent)) {
            return;
        }
        OperationResult operationResult = ((ExternalSystemFinishEvent)progressEvent).getOperationResult();
        if (!(operationResult instanceof FailureResult)) {
            return;
        }
        Logger logger = CompDBLog.INSTANCE.getLOG();
        ExternalSystemTaskId externalSystemTaskId = ((ExternalSystemTaskExecutionEvent)event).getId();
        List list = ((FailureResult)operationResult).getFailures();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFailures(...)");
        logger.debug("Task " + externalSystemTaskId + " failed with message: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)onStatusChange.1.INSTANCE, (int)31, null));
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (CompDBLoggingListener.Companion.applicableTaskId(id)) {
            CompDBLog.INSTANCE.getLOG().debug("Task " + id + " finished successfully");
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (CompDBLoggingListener.Companion.applicableTaskId(id)) {
            CompDBLog.INSTANCE.getLOG().debug("Task " + id + " finished with failure: " + e);
        }
    }

    public void onCancel(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (CompDBLoggingListener.Companion.applicableTaskId(id)) {
            CompDBLog.INSTANCE.getLOG().debug("Task " + id + " canceled");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/project/CompDBLoggingListener$Companion;", "", "()V", "applicableTaskId", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "intellij.clion.compdb"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean applicableTaskId(ExternalSystemTaskId taskId) {
            return Intrinsics.areEqual((Object)CompDBUtilKt.getID(), (Object)taskId.getProjectSystemId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

