/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.panels;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.remote.LocalRecentConnectionUiData;
import com.jetbrains.gateway.remote.LocalRecentConnectionsAdapter;
import com.jetbrains.gateway.ssh.HostDeployContext;
import com.jetbrains.gateway.ssh.LocalRecentConnectionsManager;
import com.jetbrains.gateway.ssh.panels.RemoteRecentConnectionsPanel;
import com.jetbrains.gateway.ssh.panels.recentConnections.CommonActionsKt;
import com.jetbrains.gateway.ssh.panels.recentConnections.RecentProjectsPanel;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0002:\u0001!BQ\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel;", "TConfig", "", "THostDeployContext", "Lcom/jetbrains/gateway/ssh/HostDeployContext;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "setViewPortView", "Lkotlin/Function1;", "Ljavax/swing/JComponent;", "", "setContentCallback", "Ljava/awt/Component;", "adapter", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;", "ui", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;)V", "emptyPanel", "Ljavax/swing/JPanel;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "recentProjectsPanel", "Lcom/jetbrains/gateway/ssh/panels/recentConnections/RecentProjectsPanel;", "recents", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "getSetContentCallback", "()Lkotlin/jvm/functions/Function1;", "getSetViewPortView", "adviseUIUpdate", "chooseRecentPanel", "createEmptyRecentProjectsPanel", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshRecentConnections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshRecentConnections.kt\ncom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,281:1\n13#2:282\n*S KotlinDebug\n*F\n+ 1 SshRecentConnections.kt\ncom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel\n*L\n89#1:282\n*E\n"})
public final class RemoteRecentConnectionsPanel<TConfig, THostDeployContext extends HostDeployContext<TConfig>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Function1<JComponent, Unit> setViewPortView;
    @NotNull
    private final Function1<Component, Unit> setContentCallback;
    @NotNull
    private final LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter;
    @NotNull
    private final LocalRecentConnectionUiData ui;
    @NotNull
    private final ViewableList<LocalRecentConnectionsManager.RecentConnection<TConfig>> recents;
    @NotNull
    private final RecentProjectsPanel<TConfig, THostDeployContext> recentProjectsPanel;
    @NotNull
    private final JPanel emptyPanel;
    @NotNull
    private static final Logger logger;

    public RemoteRecentConnectionsPanel(@NotNull Lifetime lifetime, @NotNull Function1<? super JComponent, Unit> setViewPortView, @NotNull Function1<? super Component, Unit> setContentCallback, @NotNull LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter, @NotNull LocalRecentConnectionUiData ui) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(setViewPortView, (String)"setViewPortView");
        Intrinsics.checkNotNullParameter(setContentCallback, (String)"setContentCallback");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.lifetime = lifetime;
        this.setViewPortView = setViewPortView;
        this.setContentCallback = setContentCallback;
        this.adapter = adapter;
        this.ui = ui;
        this.recents = this.adapter.getRecentConnectionsManager().getRecents();
        this.recentProjectsPanel = new RecentProjectsPanel<TConfig, THostDeployContext>(this.lifetime, this.adapter, this.ui, this.setContentCallback);
        this.emptyPanel = this.createEmptyRecentProjectsPanel();
        this.setViewPortView.invoke((Object)this.chooseRecentPanel());
        this.adviseUIUpdate();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function1<JComponent, Unit> getSetViewPortView() {
        return this.setViewPortView;
    }

    @NotNull
    public final Function1<Component, Unit> getSetContentCallback() {
        return this.setContentCallback;
    }

    private final JPanel chooseRecentPanel() {
        JPanel jPanel;
        if (this.recents.isEmpty()) {
            logger.info("Recent projects are empty, empty panel is shown");
            jPanel = this.emptyPanel;
        } else {
            logger.info("Showing recent projects panel");
            jPanel = this.recentProjectsPanel;
        }
        return jPanel;
    }

    private final void adviseUIUpdate() {
        this.adapter.reportNumberOfHosts(this.recents.size());
        this.recents.advise(this.lifetime, new Function1<IViewableList.Event<? extends LocalRecentConnectionsManager.RecentConnection<TConfig>>, Unit>(this){
            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IViewableList.Event<LocalRecentConnectionsManager.RecentConnection<TConfig>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                RdCoroutinesUtilKt.launchOnUiAllowInlining$default((Lifetime)this.this$0.getLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.getSetViewPortView().invoke((Object)RemoteRecentConnectionsPanel.access$chooseRecentPanel(this.this$0));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    private final JPanel createEmptyRecentProjectsPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createEmptyRecentProjectsPanel_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(RemoteRecentConnectionsPanel.access$getUi$p(this.this$0).getPanelHeader()).applyToComponent((Function1)createEmptyRecentProjectsPanel.1.INSTANCE);
                            }
                        }), (int)1, null);
                    }
                }).customize(UnscaledGapsKt.UnscaledGaps((int)20, (int)24, (int)0, (int)0));
                $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.icon(RemoteRecentConnectionsPanel.access$getUi$p(this.this$0).getIcon()).align((Align)AlignX.CENTER.INSTANCE);
                            }
                        }), (int)1, null);
                        Row lastWelcomeRow = null;
                        for (String line : RemoteRecentConnectionsPanel.access$getUi$p(this.this$0).getWelcomeLines()) {
                            lastWelcomeRow = Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(line){
                                final /* synthetic */ String $line;
                                {
                                    this.$line = $line;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    $this$row.label(this.$line).align((Align)AlignX.CENTER.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)0, (int)15, null));
                                }
                            }), (int)1, null);
                        }
                        Row row = lastWelcomeRow;
                        if (row != null) {
                            row.bottomGap(BottomGap.MEDIUM);
                        }
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = GatewayBundle.INSTANCE.message("ssh.new.host", new Object[0]);
                                AbstractAction newHost2 = new AbstractAction(this.this$0, string){
                                    final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super($super_call_param$1);
                                    }

                                    public void actionPerformed(@Nullable ActionEvent e) {
                                        CommonActionsKt.navigateToHostSelection(this.this$0.getLifetime(), RemoteRecentConnectionsPanel.access$getAdapter$p(this.this$0), this.this$0.getSetContentCallback());
                                    }
                                };
                                String string2 = GatewayBundle.INSTANCE.message("ssh.new.project", new Object[0]);
                                AbstractAction newProject2 = new AbstractAction(this.this$0, string2){
                                    final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super($super_call_param$1);
                                    }

                                    public void actionPerformed(@Nullable ActionEvent e) {
                                        GatewayConnector gatewayConnector = RemoteRecentConnectionsPanel.access$getAdapter$p(this.this$0).getGatewayConnector();
                                        if (gatewayConnector == null) {
                                            return;
                                        }
                                        GatewayConnector connector2 = gatewayConnector;
                                        GatewayUsagesCollector.INSTANCE.onConnectLeftClick(connector2.getClass());
                                        JComponent component2 = connector2.createView(this.this$0.getLifetime()).getComponent();
                                        this.this$0.getSetContentCallback().invoke((Object)component2);
                                    }
                                };
                                Action[] actionArray = new Action[]{newHost2};
                                JBOptionButton newProjectOrHost = new JBOptionButton((Action)newProject2, actionArray);
                                $this$row.cell((JComponent)newProjectOrHost).applyToComponent((Function1)createEmptyRecentProjectsPanel.1.INSTANCE).align((Align)AlignX.CENTER.INSTANCE);
                            }
                        }), (int)1, null).topGap(TopGap.MEDIUM);
                    }
                }).customize(UnscaledGapsKt.UnscaledGaps((int)137, (int)200, (int)0, (int)200));
            }
        }));
        boolean bl = false;
        $this$createEmptyRecentProjectsPanel_u24lambda_u240.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        return (JPanel)dialogPanel;
    }

    public static final /* synthetic */ JPanel access$chooseRecentPanel(RemoteRecentConnectionsPanel $this) {
        return $this.chooseRecentPanel();
    }

    public static final /* synthetic */ LocalRecentConnectionUiData access$getUi$p(RemoteRecentConnectionsPanel $this) {
        return $this.ui;
    }

    public static final /* synthetic */ LocalRecentConnectionsAdapter access$getAdapter$p(RemoteRecentConnectionsPanel $this) {
        return $this.adapter;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteRecentConnectionsPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteRecentConnectionsPanel.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

