/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidationDriver {
    private static final PropertyId[] requiredProperties = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER};
    private static final Class[] defaultClasses = new Class[]{class$com$thaiopensource$xml$sax$Jaxp11XMLReaderCreator == null ? (class$com$thaiopensource$xml$sax$Jaxp11XMLReaderCreator = ValidationDriver.class$("com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator")) : class$com$thaiopensource$xml$sax$Jaxp11XMLReaderCreator, class$com$thaiopensource$xml$sax$ErrorHandlerImpl == null ? (class$com$thaiopensource$xml$sax$ErrorHandlerImpl = ValidationDriver.class$("com.thaiopensource.xml.sax.ErrorHandlerImpl")) : class$com$thaiopensource$xml$sax$ErrorHandlerImpl};
    private final XMLReaderCreator xrc;
    private XMLReader xr;
    private final CountingErrorHandler eh;
    private final SchemaReader sr;
    private final PropertyMap schemaProperties;
    private final PropertyMap instanceProperties;
    private Validator validator;
    private Schema schema;
    static /* synthetic */ Class class$com$thaiopensource$xml$sax$Jaxp11XMLReaderCreator;
    static /* synthetic */ Class class$com$thaiopensource$xml$sax$ErrorHandlerImpl;

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2, SchemaReader schemaReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
        int n = 0;
        while (n < requiredProperties.length) {
            if (!propertyMapBuilder.contains(requiredProperties[n])) {
                try {
                    propertyMapBuilder.put(requiredProperties[n], defaultClasses[n].newInstance());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n;
        }
        this.schemaProperties = propertyMapBuilder.toPropertyMap();
        propertyMapBuilder = new PropertyMapBuilder(propertyMap2);
        int n2 = 0;
        while (n2 < requiredProperties.length) {
            if (!propertyMapBuilder.contains(requiredProperties[n2])) {
                propertyMapBuilder.put(requiredProperties[n2], this.schemaProperties.get(requiredProperties[n2]));
            }
            ++n2;
        }
        this.eh = new CountingErrorHandler((ErrorHandler)propertyMapBuilder.get(ValidateProperty.ERROR_HANDLER));
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.eh);
        this.instanceProperties = propertyMapBuilder.toPropertyMap();
        this.xrc = ValidateProperty.XML_READER_CREATOR.get(this.instanceProperties);
        this.sr = schemaReader == null ? new AutoSchemaReader() : schemaReader;
    }

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2) {
        this(propertyMap, propertyMap2, null);
    }

    public ValidationDriver(PropertyMap propertyMap, SchemaReader schemaReader) {
        this(propertyMap, propertyMap, schemaReader);
    }

    public ValidationDriver(PropertyMap propertyMap) {
        this(propertyMap, propertyMap, null);
    }

    public ValidationDriver(SchemaReader schemaReader) {
        this(PropertyMap.EMPTY, schemaReader);
    }

    public ValidationDriver() {
        this(PropertyMap.EMPTY, PropertyMap.EMPTY, null);
    }

    public boolean loadSchema(InputSource inputSource) throws SAXException, IOException {
        try {
            this.schema = this.sr.createSchema(inputSource, this.schemaProperties);
            this.validator = null;
            return true;
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(InputSource inputSource) throws SAXException, IOException {
        if (this.schema == null) {
            throw new IllegalStateException("cannot validate without schema");
        }
        if (this.validator == null) {
            this.validator = this.schema.createValidator(this.instanceProperties);
        }
        if (this.xr == null) {
            this.xr = this.xrc.createXMLReader();
            this.xr.setErrorHandler(this.eh);
        }
        this.eh.reset();
        this.xr.setContentHandler(this.validator.getContentHandler());
        DTDHandler dTDHandler = this.validator.getDTDHandler();
        if (dTDHandler != null) {
            this.xr.setDTDHandler(dTDHandler);
        }
        try {
            this.xr.parse(inputSource);
            boolean bl = !this.eh.getHadErrorOrFatalError();
            Object var5_4 = null;
            this.validator.reset();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.validator.reset();
            throw throwable;
        }
    }

    public static InputSource fileInputSource(String string2) throws MalformedURLException {
        return ValidationDriver.fileInputSource(new File(string2));
    }

    public static InputSource fileInputSource(File file) throws MalformedURLException {
        return new InputSource(UriOrFile.fileToUri(file));
    }

    public static InputSource uriOrFileInputSource(String string2) throws MalformedURLException {
        return new InputSource(UriOrFile.toUri(string2));
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

