/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorageKt;
import com.jetbrains.jsonSchema.impl.light.nodes.MissingJsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.RootJsonSchemaObjectBackedByJackson;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u0005*\u00020\u000eH\u0002R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage;", "", "()V", "parsedSchemaById", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage$SchemaId;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "Lorg/jetbrains/annotations/NotNull;", "supportedFileTypeNames", "", "", "createRootSchemaObject", "schemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getComputedSchemaRootOrNull", "maybeSchemaFile", "getOrComputeSchemaRootObject", "isNotLoadedHttpFile", "", "maybeHttpFile", "isSupportedSchemaFile", "isSupportedSchemaFileType", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "parseSchemaFileSafe", "Lcom/fasterxml/jackson/databind/JsonNode;", "asSchemaId", "Companion", "SchemaId", "intellij.json"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJsonSchemaObjectStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaObjectStorage.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class JsonSchemaObjectStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<SchemaId, JsonSchemaObject> parsedSchemaById;
    @NotNull
    private final Set<String> supportedFileTypeNames;

    public JsonSchemaObjectStorage() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> JsonSchemaObjectStorage.parsedSchemaById$lambda$0((Function1)new Function1<SchemaId, JsonSchemaObject>(this){
            final /* synthetic */ JsonSchemaObjectStorage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JsonSchemaObject invoke(SchemaId id) {
                return JsonSchemaObjectStorage.access$createRootSchemaObject(this.this$0, id.getSchemaFile());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.parsedSchemaById = concurrentMap;
        Object[] objectArray = new String[]{"JSON", "JSON5", "YAML"};
        this.supportedFileTypeNames = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public final JsonSchemaObject getOrComputeSchemaRootObject(@NotNull VirtualFile schemaFile) {
        Intrinsics.checkNotNullParameter((Object)schemaFile, (String)"schemaFile");
        if (!this.isSupportedSchemaFile(schemaFile)) {
            return null;
        }
        Object v = this.parsedSchemaById.get(this.asSchemaId(schemaFile));
        JsonSchemaObject it = (JsonSchemaObject)v;
        boolean bl = false;
        return (JsonSchemaObject)(!(it instanceof MissingJsonSchemaObject) ? v : null);
    }

    @Nullable
    public final JsonSchemaObject getComputedSchemaRootOrNull(@NotNull VirtualFile maybeSchemaFile) {
        Intrinsics.checkNotNullParameter((Object)maybeSchemaFile, (String)"maybeSchemaFile");
        if (!this.parsedSchemaById.containsKey(this.asSchemaId(maybeSchemaFile))) {
            return null;
        }
        Object v = this.parsedSchemaById.get(this.asSchemaId(maybeSchemaFile));
        JsonSchemaObject it = (JsonSchemaObject)v;
        boolean bl = false;
        return (JsonSchemaObject)(!(it instanceof MissingJsonSchemaObject) ? v : null);
    }

    private final boolean isSupportedSchemaFile(VirtualFile maybeSchemaFile) {
        FileType fileType = maybeSchemaFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return this.isSupportedSchemaFileType(fileType) && !this.isNotLoadedHttpFile(maybeSchemaFile);
    }

    private final boolean isSupportedSchemaFileType(FileType fileType) {
        return this.supportedFileTypeNames.contains(fileType.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotLoadedHttpFile(VirtualFile maybeHttpFile) {
        if (!(maybeHttpFile instanceof HttpVirtualFile)) return false;
        RemoteFileInfo remoteFileInfo = ((HttpVirtualFile)maybeHttpFile).getFileInfo();
        if ((remoteFileInfo != null ? remoteFileInfo.getState() : null) == RemoteFileState.DOWNLOADED) return false;
        return true;
    }

    private final SchemaId asSchemaId(VirtualFile $this$asSchemaId) {
        return $this$asSchemaId instanceof LightVirtualFile ? new SchemaId($this$asSchemaId, -1L) : new SchemaId($this$asSchemaId, $this$asSchemaId.getModificationStamp());
    }

    private final JsonSchemaObject createRootSchemaObject(VirtualFile schemaFile) {
        JsonNode parsedSchemaRoot = this.parseSchemaFileSafe(schemaFile);
        return parsedSchemaRoot == null ? (JsonSchemaObject)MissingJsonSchemaObject.INSTANCE : (JsonSchemaObject)new RootJsonSchemaObjectBackedByJackson(parsedSchemaRoot, schemaFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonNode parseSchemaFileSafe(VirtualFile schemaFile) {
        Closeable closeable;
        ObjectMapper objectMapper2;
        String string2 = schemaFile.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        switch (string2) {
            case "JSON5": 
            case "JSON": {
                objectMapper2 = JsonSchemaObjectStorageKt.getJson5ObjectMapper();
                break;
            }
            case "YAML": {
                objectMapper2 = JsonSchemaObjectStorageKt.getYamlObjectMapper();
                break;
            }
            default: {
                String providedFileTypeId;
                Logger.getInstance((String)"JsonSchemaReader").warn("Unsupported json schema file type: " + providedFileTypeId);
                return null;
            }
        }
        ObjectMapper suitableReader = objectMapper2;
        try {
            JsonNode jsonNode;
            InputStream inputStream = schemaFile.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            closeable = inputStream;
            Intrinsics.checkNotNull((Object)suitableReader);
            ObjectMapper objectMapper3 = suitableReader;
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)closeable;
                boolean bl = false;
                jsonNode = objectMapper3.readTree(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = jsonNode;
        }
        catch (Exception exception) {
            Logger.getInstance((String)"JsonSchemaReader2").warn("Unable to parse JSON schema from the given file '" + schemaFile.getName() + "'", (Throwable)exception);
            closeable = null;
        }
        return closeable;
    }

    private static final JsonSchemaObject parsedSchemaById$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JsonSchemaObject)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JsonSchemaObjectStorage getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ JsonSchemaObject access$createRootSchemaObject(JsonSchemaObjectStorage $this, VirtualFile schemaFile) {
        return $this.createRootSchemaObject(schemaFile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.json"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaObjectStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaObjectStorage.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,126:1\n31#2,2:127\n*S KotlinDebug\n*F\n+ 1 JsonSchemaObjectStorage.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage$Companion\n*L\n32#1:127,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonSchemaObjectStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<JsonSchemaObjectStorage> serviceClass$iv = JsonSchemaObjectStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JsonSchemaObjectStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectStorage$SchemaId;", "", "schemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "modificationStamp", "", "(Lcom/intellij/openapi/vfs/VirtualFile;J)V", "getModificationStamp", "()J", "getSchemaFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.json"})
    private static final class SchemaId {
        @NotNull
        private final VirtualFile schemaFile;
        private final long modificationStamp;

        public SchemaId(@NotNull VirtualFile schemaFile, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)schemaFile, (String)"schemaFile");
            this.schemaFile = schemaFile;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        public final VirtualFile getSchemaFile() {
            return this.schemaFile;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.schemaFile;
        }

        public final long component2() {
            return this.modificationStamp;
        }

        @NotNull
        public final SchemaId copy(@NotNull VirtualFile schemaFile, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)schemaFile, (String)"schemaFile");
            return new SchemaId(schemaFile, modificationStamp);
        }

        public static /* synthetic */ SchemaId copy$default(SchemaId schemaId, VirtualFile virtualFile, long l, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = schemaId.schemaFile;
            }
            if ((n & 2) != 0) {
                l = schemaId.modificationStamp;
            }
            return schemaId.copy(virtualFile, l);
        }

        @NotNull
        public String toString() {
            return "SchemaId(schemaFile=" + this.schemaFile + ", modificationStamp=" + this.modificationStamp + ")";
        }

        public int hashCode() {
            int result2 = this.schemaFile.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.modificationStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SchemaId)) {
                return false;
            }
            SchemaId schemaId = (SchemaId)other;
            if (!Intrinsics.areEqual((Object)this.schemaFile, (Object)schemaId.schemaFile)) {
                return false;
            }
            return this.modificationStamp == schemaId.modificationStamp;
        }
    }
}

