/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlPsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class ScriptSupportUtil {
    private static final Key<CachedValue<XmlTag[]>> CachedScriptTagsKey = Key.create((String)"script tags");
    private static final ThreadLocal<String> ProcessingDeclarationsFlag = new ThreadLocal();

    private ScriptSupportUtil() {
    }

    public static void clearCaches(XmlFile element) {
        element.putUserData(CachedScriptTagsKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processDeclarations(XmlFile element, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        CachedValue myCachedScriptTags = (CachedValue)element.getUserData(CachedScriptTagsKey);
        if (myCachedScriptTags == null) {
            myCachedScriptTags = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
                final ArrayList scriptTags = new ArrayList();
                XmlDocument document2 = HtmlPsiUtil.getRealXmlDocument(element.getDocument());
                if (document2 != null) {
                    PsiElementProcessor psiElementProcessor = new PsiElementProcessor(){

                        public boolean execute(@NotNull PsiElement element1) {
                            XmlElementDescriptor descriptor;
                            XmlTag tag;
                            if (element1 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element1 instanceof XmlTag && "script".equalsIgnoreCase((tag = (XmlTag)element1).getName()) && (descriptor = tag.getDescriptor()) != null && "script".equals(descriptor.getName())) {
                                scriptTags.add(tag);
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/source/html/ScriptSupportUtil$1", "execute"));
                        }
                    };
                    XmlPsiUtil.processXmlElements(document2, (PsiElementProcessor<? super PsiElement>)psiElementProcessor, true);
                }
                return new CachedValueProvider.Result((Object)scriptTags.toArray(XmlTag.EMPTY), new Object[]{element});
            }, false);
            element.putUserData(CachedScriptTagsKey, myCachedScriptTags);
        }
        if (ProcessingDeclarationsFlag.get() != null) {
            return true;
        }
        try {
            ProcessingDeclarationsFlag.set("");
            for (XmlTag tag : (XmlTag[])myCachedScriptTags.getValue()) {
                PsiFile psiFile;
                XmlAttribute attribute;
                XmlTagChild[] children;
                for (XmlTagChild child : children = tag.getValue().getChildren()) {
                    if (child.processDeclarations(processor, state, null, place)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (tag.getAttributeValue("src") == null || (attribute = tag.getAttribute("src", null)) == null || (psiFile = FileReferenceUtil.findFile((PsiElement)attribute.getValueElement())) == null || !psiFile.isValid() || psiFile.processDeclarations(processor, state, null, place)) continue;
                int n = 0;
                return n != 0;
            }
        }
        finally {
            ProcessingDeclarationsFlag.set(null);
        }
        return true;
    }
}

