/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@State(name="IssueNavigationConfiguration", storages={@Storage(value="vcs.xml")})
public class IssueNavigationConfiguration
extends SimpleModificationTracker
implements PersistentStateComponent<IssueNavigationConfiguration> {
    private static final Logger LOG = Logger.getInstance(IssueNavigationConfiguration.class);
    private List<IssueNavigationLink> myLinks = new ArrayList<IssueNavigationLink>();

    public static IssueNavigationConfiguration getInstance(Project project2) {
        return (IssueNavigationConfiguration)((Object)project2.getService(IssueNavigationConfiguration.class));
    }

    public List<IssueNavigationLink> getLinks() {
        return this.myLinks;
    }

    public void setLinks(List<? extends IssueNavigationLink> links) {
        this.myLinks = new ArrayList<IssueNavigationLink>(links);
        this.incModificationCount();
    }

    public IssueNavigationConfiguration getState() {
        return this;
    }

    public void loadState(@NotNull IssueNavigationConfiguration state) {
        if (state == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public List<LinkMatch> findIssueLinks(CharSequence text2) {
        ArrayList<LinkMatch> result2 = new ArrayList<LinkMatch>();
        try {
            TextRange match2;
            for (IssueNavigationLink link : this.myLinks) {
                IssueNavigationConfiguration.findIssueLinkMatches(text2, link, result2);
            }
            int lastOffset = 0;
            while ((match2 = URLUtil.findUrl((CharSequence)text2, (int)lastOffset, (int)text2.length())) != null) {
                IssueNavigationConfiguration.addMatch(result2, match2, match2.subSequence(text2).toString());
                lastOffset = match2.getEndOffset();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        Collections.sort(result2);
        return result2;
    }

    public static void findIssueLinkMatches(@NotNull CharSequence text2, @NotNull IssueNavigationLink link, @NotNull List<LinkMatch> result2) {
        if (text2 == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(1);
        }
        if (link == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(3);
        }
        Pattern issuePattern = link.getIssuePattern();
        Matcher m = issuePattern.matcher(text2);
        while (m.find()) {
            try {
                String replacement = issuePattern.matcher(m.group(0)).replaceFirst(link.getLinkRegexp());
                IssueNavigationConfiguration.addMatch(result2, new TextRange(m.start(), m.end()), replacement);
            }
            catch (Exception e) {
                LOG.debug("Malformed regex replacement. IssueLink: " + link + "; text: " + text2, (Throwable)e);
            }
        }
    }

    private static void addMatch(List<LinkMatch> result2, TextRange range, String replacement) {
        Iterator<LinkMatch> iterator = result2.iterator();
        while (iterator.hasNext()) {
            LinkMatch oldMatch = iterator.next();
            if (!oldMatch.getRange().intersectsStrict(range)) continue;
            if (oldMatch.getRange().getStartOffset() <= range.getStartOffset() && !oldMatch.getRange().equals((Object)range)) {
                return;
            }
            iterator.remove();
        }
        result2.add(new LinkMatch(range, replacement));
    }

    public static void processTextWithLinks(@Nls String text2, @NotNull List<? extends LinkMatch> matches, @NotNull Consumer<? super @Nls String> textConsumer, @NotNull BiConsumer<? super @Nls String, ? super @NlsSafe String> linkWithTargetConsumer) {
        if (matches == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(4);
        }
        if (textConsumer == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(5);
        }
        if (linkWithTargetConsumer == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(6);
        }
        int pos = 0;
        for (LinkMatch linkMatch : matches) {
            TextRange textRange = linkMatch.getRange();
            LOG.assertTrue(pos <= textRange.getStartOffset());
            if (textRange.getStartOffset() > pos) {
                textConsumer.accept(text2.substring(pos, textRange.getStartOffset()));
            }
            linkWithTargetConsumer.accept(textRange.substring(text2), linkMatch.getTargetUrl());
            pos = textRange.getEndOffset();
        }
        if (pos < text2.length()) {
            textConsumer.accept(text2.substring(pos));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textConsumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkWithTargetConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/IssueNavigationConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findIssueLinkMatches";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextWithLinks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LinkMatch
    implements Comparable {
        private final TextRange myRange;
        private final String myTargetUrl;

        public LinkMatch(TextRange range, String targetUrl) {
            this.myRange = range;
            this.myTargetUrl = targetUrl;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public String getTargetUrl() {
            return this.myTargetUrl;
        }

        public int compareTo(Object o) {
            if (!(o instanceof LinkMatch)) {
                return 0;
            }
            return this.myRange.getStartOffset() - ((LinkMatch)o).getRange().getStartOffset();
        }
    }
}

