/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class XmlLocationCompletionContributor
extends CompletionContributor {
    public static final Function<Object, LookupElement> MAPPING = o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((Object)o);

    XmlLocationCompletionContributor() {
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiReference reference;
        if (parameters == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) instanceof URLReference) {
            if (((URLReference)reference).isSchemaLocation()) {
                Object[] objects = XmlLocationCompletionContributor.completeSchemaLocation(reference.getElement());
                result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
                if (objects.length > 0) {
                    result2.stopHere();
                }
                return;
            }
            Object[] objects = XmlLocationCompletionContributor.completeNamespace(reference.getElement());
            result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
            if (objects.length > 0) {
                result2.stopHere();
            }
            return;
        }
        if (reference instanceof PsiMultiReference) {
            reference = ((PsiMultiReference)reference).getReferences()[0];
        }
        if (reference instanceof DependentNSReference) {
            MultiMap<String, String> map = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(parameters.getOriginalFile().getProject());
            String namespace = ((DependentNSReference)reference).getNamespaceReference().getCanonicalText();
            Collection strings = map.get((Object)namespace);
            for (String string2 : strings) {
                if (namespace.equals(string2)) continue;
                result2.consume(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string2), (double)100.0));
            }
            if (!strings.isEmpty()) {
                result2.stopHere();
            }
        }
    }

    private static Object[] completeNamespace(PsiElement myElement) {
        XmlFile file = (XmlFile)myElement.getContainingFile();
        PsiElement parent = myElement.getParent();
        HashSet<String> list2 = new HashSet<String>();
        for (XmlSchemaProvider provider : XmlSchemaProvider.EP_NAME.getExtensionList()) {
            if (!provider.isAvailable(file)) continue;
            list2.addAll(provider.getAvailableNamespaces(file, null));
        }
        if (!list2.isEmpty()) {
            return ArrayUtil.toObjectArray(list2);
        }
        HashSet set = new HashSet(ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(myElement.getProject()).keySet());
        Set fromIndex = XmlNamespaceIndex.getAllResources(null, myElement.getProject()).stream().filter(resource -> "xsd".equals(resource.getFile().getExtension())).map(resource -> ((XsdNamespaceBuilder)resource.getValue()).getNamespace()).collect(Collectors.toSet());
        ContainerUtil.addAllNotNull(set, fromIndex);
        Object[] resourceUrls = set.toArray();
        XmlDocument document2 = file.getDocument();
        assert (document2 != null);
        XmlTag rootTag = document2.getRootTag();
        ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas(rootTag, (Processor<? super XmlTag>)((Processor)xmlTag -> {
                String s = xmlTag.getAttributeValue("targetNamespace");
                if (s != null) {
                    additionalNs.add(s);
                }
                return true;
            }));
        }
        resourceUrls = ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtilRt.toStringArray(additionalNs));
        HashSet<String> preferred = new HashSet<String>();
        if (parent instanceof XmlAttribute && "xmlns".equals(((XmlAttribute)parent).getName())) {
            XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(file);
            preferred.addAll(helper.guessUnboundNamespaces(parent.getParent(), file));
        }
        return ContainerUtil.map2Array((Object[])resourceUrls, o -> {
            LookupElementBuilder builder2 = LookupElementBuilder.create((Object)o);
            return preferred.contains(o) ? PrioritizedLookupElement.withPriority((LookupElement)builder2, (double)100.0) : builder2;
        });
    }

    private static Object[] completeSchemaLocation(PsiElement element) {
        XmlTag tag = (XmlTag)element.getParent().getParent();
        Object[] attributes = tag.getAttributes();
        PsiReference[] refs = element.getReferences();
        return ContainerUtil.mapNotNull((Object[])attributes, attribute -> {
            String attributeValue2 = attribute.getValue();
            return attributeValue2 != null && attribute.isNamespaceDeclaration() && ContainerUtil.find((Object[])refs, ref -> ref.getCanonicalText().equals(attributeValue2)) == null ? attributeValue2 + " " : null;
        }, (Object[])ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlLocationCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

